/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.util.ByteUtil;
import com.hivemc.chunker.util.LegacyIdentifier;

public class JavaChunkReader {
    protected final Converter converter;
    protected final JavaResolvers resolvers;
    protected final ChunkerColumn column;
    protected final ChunkerChunk chunk;

    public JavaChunkReader(Converter converter, JavaResolvers resolvers, ChunkerColumn column, ChunkerChunk chunk) {
        this.converter = converter;
        this.resolvers = resolvers;
        this.column = column;
        this.chunk = chunk;
    }

    public void readChunk(CompoundTag nbt) {
        Task.asyncConsume("Reading Palette", TaskWeight.HIGHER, this::readPalette, nbt);
        if (this.converter.shouldProcessLighting()) {
            Task.asyncConsume("Reading Lighting", TaskWeight.HIGHER, this::readLighting, nbt);
        }
    }

    protected void readPalette(CompoundTag nbt) {
        byte[] blocks = nbt.getByteArray("Blocks", null);
        if (blocks == null) {
            this.chunk.setPalette(ChunkerBlockIdentifier.AIR.asFilledChunkPalette());
            return;
        }
        byte[] data = nbt.getByteArray("Data", null);
        byte[] extraData = nbt.getByteArray("Add", null);
        ShortBasedPalette<LegacyIdentifier> intPalette = new ShortBasedPalette<LegacyIdentifier>(16, 16);
        for (int i = 0; i < 4096; ++i) {
            int x = i & 0xF;
            int z = i >> 4 & 0xF;
            int y = i >> 8 & 0xF;
            int nibbleIndex = i >> 1;
            boolean lowestBits = (i & 1) == 0;
            byte extraByte = 0;
            if (extraData != null) {
                extraByte = ByteUtil.getNibbleFromByte(extraData[nibbleIndex], lowestBits);
            }
            LegacyIdentifier identifier = new LegacyIdentifier(blocks[i] & 0xFF | (extraByte & 0xFF) << 8, data == null ? (byte)0 : ByteUtil.getNibbleFromByte(data[nibbleIndex], lowestBits));
            intPalette.set(x, y, z, identifier);
        }
        this.chunk.setPalette(intPalette.map(this.resolvers::readBlock));
    }

    protected void readLighting(CompoundTag nbt) {
        byte[] blockLight = nbt.getByteArray("BlockLight", null);
        byte[] skyLight = nbt.getByteArray("SkyLight", null);
        if (blockLight != null) {
            this.chunk.setBlockLight(new byte[16][16][16]);
        }
        if (skyLight != null) {
            this.chunk.setSkyLight(new byte[16][16][16]);
        }
        if (blockLight != null || skyLight != null) {
            for (int i = 0; i < 4096; ++i) {
                boolean lowestBits;
                int x = i & 0xF;
                int z = i >> 4 & 0xF;
                int y = i >> 8 & 0xF;
                int nibbleIndex = i >> 1;
                boolean bl = lowestBits = (i & 1) == 0;
                if (blockLight != null) {
                    this.chunk.getBlockLight()[x][y][z] = ByteUtil.getNibbleFromByte(blockLight[nibbleIndex], lowestBits);
                }
                if (skyLight == null) continue;
                this.chunk.getSkyLight()[x][y][z] = ByteUtil.getNibbleFromByte(skyLight[nibbleIndex], lowestBits);
            }
        }
    }
}

