/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityResolver;
import com.hivemc.chunker.conversion.encoding.java.JavaDataVersion;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.banner.ChunkerBannerPattern;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.horn.ChunkerHornInstrument;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimMaterial;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimPattern;
import com.hivemc.chunker.conversion.intermediate.column.entity.PaintingEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.LegacyIdentifier;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;

public class JavaResolversBuilder {
    private final Converter converter;
    private final Version version;
    private final boolean enableCaching;
    private Resolver<CompoundTag, Identifier> nbtBlockIdentifierResolver;
    private Resolver<Integer, String> blockIDResolver;
    private Resolver<Identifier, ChunkerItemStack> itemIdentifierResolver;
    private Resolver<Identifier, ChunkerBlockIdentifier> blockIdentifierResolver;
    private Resolver<String, ChunkerEntityType> entityTypeResolver;
    private Resolver<String, ChunkerBiome> biomeNameResolver;
    private Resolver<Integer, ChunkerBiome> biomeIDResolver;
    private Resolver<String, ChunkerEffectType> effectResolver;
    private Resolver<Integer, ChunkerEffectType> effectIDResolver;
    private Resolver<String, ChunkerEnchantmentType> enchantmentResolver;
    private Resolver<Integer, ChunkerEnchantmentType> enchantmentIDResolver;
    private Resolver<String, ChunkerHornInstrument> hornInstrumentResolver;
    private Resolver<String, PaintingEntity.Motive> paintingMotiveResolver;
    private Resolver<String, ChunkerPotionType> potionTypeResolver;
    private Resolver<byte[], byte[]> mapColorsResolver;
    private Resolver<String, ChunkerTrimPattern> trimPatternResolver;
    private Resolver<String, ChunkerTrimMaterial> trimMaterialResolver;
    private Resolver<String, ChunkerBannerPattern> bannerPatternResolver;
    private Resolver<String, ChunkerBannerPattern> bannerPatternShortNameResolver;
    private Function<JavaResolvers, Resolver<CompoundTag, ChunkerItemStack>> itemStackResolverConstructor;
    private Function<JavaResolvers, BlockEntityResolver<JavaResolvers, CompoundTag>> blockEntityResolverConstructor;
    private Function<JavaResolvers, EntityResolver<JavaResolvers, CompoundTag>> entityResolverConstructor;
    private PreTransformManager preTransformManager;

    public JavaResolversBuilder(Converter converter, Version version, boolean enableCaching) {
        this.converter = converter;
        this.version = version;
        this.enableCaching = enableCaching;
    }

    public JavaResolvers build() {
        final Resolver<CompoundTag, ChunkerBlockIdentifier> nbtChunkerBlockIdentifierResolver = this.nbtBlockIdentifierResolver.then(this.blockIdentifierResolver);
        final JavaDataVersion dataVersion = JavaDataVersion.getNearestVersion(this.version);
        return new JavaResolvers(){
            private final Resolver<CompoundTag, ChunkerItemStack> itemStackResolver;
            private final BlockEntityResolver<JavaResolvers, CompoundTag> blockEntityResolver;
            private final EntityResolver<JavaResolvers, CompoundTag> entityResolver;
            {
                this.itemStackResolver = JavaResolversBuilder.this.itemStackResolverConstructor.apply(this);
                this.blockEntityResolver = JavaResolversBuilder.this.blockEntityResolverConstructor.apply(this);
                this.entityResolver = JavaResolversBuilder.this.entityResolverConstructor.apply(this);
            }

            @Override
            public ChunkerBlockIdentifier readBlock(CompoundTag input) {
                return nbtChunkerBlockIdentifierResolver.to(input).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, input.toSNBT());
                    return ChunkerBlockIdentifier.AIR;
                });
            }

            @Override
            public ChunkerBlockIdentifier readBlock(LegacyIdentifier input) {
                Optional output = JavaResolversBuilder.this.blockIDResolver.to(input.id()).map(identifier -> Identifier.fromData(identifier, OptionalInt.of(input.data()))).flatMap(JavaResolversBuilder.this.blockIdentifierResolver::to);
                return output.orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(input));
                    return ChunkerBlockIdentifier.AIR;
                });
            }

            @Override
            public ChunkerBlockIdentifier readBlockIdentifier(Identifier input) {
                return JavaResolversBuilder.this.blockIdentifierResolver.to(input).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(input));
                    return ChunkerBlockIdentifier.AIR;
                });
            }

            @Override
            public ChunkerItemStack readItem(CompoundTag input) {
                if (!JavaResolversBuilder.this.converter.shouldProcessItems()) {
                    return new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
                }
                return this.itemStackResolver.to(input).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.ITEM, input.toSNBT());
                    return new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
                });
            }

            @Override
            public ChunkerItemStack readItemIdentifier(Identifier input) {
                if (!JavaResolversBuilder.this.converter.shouldProcessItems()) {
                    return new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
                }
                Optional<ChunkerItemStack> itemStack = JavaResolversBuilder.this.itemIdentifierResolver.to(input);
                return itemStack.orElseGet(() -> new ChunkerItemStack(this.readBlockIdentifier(input)));
            }

            @Override
            public Optional<CompoundTag> writeItem(ChunkerItemStack chunkerItemStack) {
                return Optional.ofNullable(this.itemStackResolver.from(chunkerItemStack).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.ITEM, String.valueOf(chunkerItemStack));
                    return null;
                }));
            }

            @Override
            public Identifier writeItemIdentifier(ChunkerItemStack chunkerItemStack) {
                Optional<Identifier> itemStack = JavaResolversBuilder.this.itemIdentifierResolver.from(chunkerItemStack);
                return itemStack.orElseGet(() -> {
                    ChunkerItemStackIdentifier patt9515$temp = chunkerItemStack.getIdentifier();
                    if (patt9515$temp instanceof ChunkerBlockIdentifier) {
                        ChunkerBlockIdentifier chunkerBlockIdentifier = (ChunkerBlockIdentifier)patt9515$temp;
                        return this.writeBlockIdentifier(chunkerBlockIdentifier, true).orElseGet(() -> this.writeBlockIdentifier(ChunkerBlockIdentifier.AIR, false).orElseThrow());
                    }
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.ITEM, String.valueOf(chunkerItemStack));
                    return this.writeBlockIdentifier(ChunkerBlockIdentifier.AIR, false).orElseThrow();
                });
            }

            @Override
            public ChunkerBiome readBiome(String biome, Dimension dimension) {
                return JavaResolversBuilder.this.biomeNameResolver.to(biome).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BIOME, biome);
                    return this.getFallbackBiome(dimension);
                });
            }

            @Override
            public ChunkerBiome readBiome(int biome, Dimension dimension) {
                return JavaResolversBuilder.this.biomeIDResolver.to(biome).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BIOME, String.valueOf(biome));
                    return this.getFallbackBiome(dimension);
                });
            }

            @Override
            public int writeBiomeID(ChunkerBiome biome, Dimension dimension) {
                return JavaResolversBuilder.this.biomeIDResolver.from(biome).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BIOME, String.valueOf(biome));
                    return JavaResolversBuilder.this.biomeIDResolver.from(this.getFallbackBiome(dimension)).orElseThrow();
                });
            }

            @Override
            public String writeBiome(ChunkerBiome biome, Dimension dimension) {
                return JavaResolversBuilder.this.biomeNameResolver.from(biome).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BIOME, String.valueOf(biome));
                    return JavaResolversBuilder.this.biomeNameResolver.from(this.getFallbackBiome(dimension)).orElseThrow();
                });
            }

            @Override
            public CompoundTag writeBlock(ChunkerBlockIdentifier chunkerBlockIdentifier) {
                return nbtChunkerBlockIdentifierResolver.from(chunkerBlockIdentifier).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(chunkerBlockIdentifier));
                    return (CompoundTag)nbtChunkerBlockIdentifierResolver.from(ChunkerBlockIdentifier.AIR).orElseThrow();
                });
            }

            @Override
            public Optional<Identifier> writeBlockIdentifier(ChunkerBlockIdentifier identifier, boolean reportMissing) {
                Optional<Identifier> result = JavaResolversBuilder.this.blockIdentifierResolver.from(identifier);
                if (result.isEmpty() && reportMissing) {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(identifier));
                }
                return result;
            }

            @Override
            public LegacyIdentifier writeLegacyBlockIdentifier(ChunkerBlockIdentifier chunkerBlockIdentifier) {
                return JavaResolversBuilder.this.blockIdentifierResolver.from(chunkerBlockIdentifier).flatMap(identifier -> JavaResolversBuilder.this.blockIDResolver.from(identifier.getIdentifier()).map(id -> new LegacyIdentifier((int)id, (byte)identifier.getDataValue().orElse(0)))).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(chunkerBlockIdentifier));
                    return new LegacyIdentifier(0, 0);
                });
            }

            @Override
            public ChunkerEffectType readEffect(String effect) {
                return JavaResolversBuilder.this.effectResolver.to(effect).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.EFFECT, effect);
                    return ChunkerEffectType.EMPTY;
                });
            }

            @Override
            public String writeEffect(ChunkerEffectType effect) {
                return JavaResolversBuilder.this.effectResolver.from(effect).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.EFFECT, String.valueOf((Object)effect));
                    return "minecraft:empty";
                });
            }

            @Override
            public ChunkerEffectType readEffectID(int effectID) {
                return JavaResolversBuilder.this.effectIDResolver.to(effectID).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.EFFECT, String.valueOf(effectID));
                    return ChunkerEffectType.EMPTY;
                });
            }

            @Override
            public int writeEffectID(ChunkerEffectType effect) {
                return JavaResolversBuilder.this.effectIDResolver.from(effect).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.EFFECT, String.valueOf((Object)effect));
                    return 0;
                });
            }

            @Override
            public ChunkerHornInstrument readHornInstrument(String identifier) {
                return JavaResolversBuilder.this.hornInstrumentResolver.to(identifier).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.HORN, identifier);
                    return ChunkerHornInstrument.PONDER_GOAT_HORN;
                });
            }

            @Override
            public String writeHornInstrument(ChunkerHornInstrument hornInstrument) {
                return JavaResolversBuilder.this.hornInstrumentResolver.from(hornInstrument).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.HORN, String.valueOf((Object)hornInstrument));
                    return JavaResolversBuilder.this.hornInstrumentResolver.from(ChunkerHornInstrument.PONDER_GOAT_HORN).orElseThrow();
                });
            }

            @Override
            public ChunkerPotionType readPotionType(String identifier) {
                return JavaResolversBuilder.this.potionTypeResolver.to(identifier).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.POTION, identifier);
                    return ChunkerPotionType.WATER;
                });
            }

            @Override
            public String writePotionType(ChunkerPotionType potionType) {
                return JavaResolversBuilder.this.potionTypeResolver.from(potionType).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.POTION, String.valueOf((Object)potionType));
                    return JavaResolversBuilder.this.potionTypeResolver.from(ChunkerPotionType.WATER).orElseThrow();
                });
            }

            @Override
            public PaintingEntity.Motive readPaintingMotive(String identifier) {
                return JavaResolversBuilder.this.paintingMotiveResolver.to(identifier).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.PAINTING, identifier);
                    return PaintingEntity.Motive.KEBAB;
                });
            }

            @Override
            public String writePaintingMotive(PaintingEntity.Motive motive) {
                return JavaResolversBuilder.this.paintingMotiveResolver.from(motive).orElseGet(() -> {
                    JavaResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.PAINTING, String.valueOf((Object)motive));
                    return JavaResolversBuilder.this.paintingMotiveResolver.from(PaintingEntity.Motive.KEBAB).orElseThrow();
                });
            }

            @Override
            public byte[] readMapColors(byte[] javaMapColors) {
                return JavaResolversBuilder.this.mapColorsResolver.to(javaMapColors).orElse(null);
            }

            @Override
            public byte[] writeMapColors(byte[] chunkerMapColors) {
                return JavaResolversBuilder.this.mapColorsResolver.from(chunkerMapColors).orElse(null);
            }

            @Override
            public BlockEntityResolver<JavaResolvers, CompoundTag> blockEntityResolver() {
                return this.blockEntityResolver;
            }

            @Override
            public EntityResolver<JavaResolvers, CompoundTag> entityResolver() {
                return this.entityResolver;
            }

            @Override
            public Resolver<String, ChunkerEntityType> entityTypeResolver() {
                return JavaResolversBuilder.this.entityTypeResolver;
            }

            @Override
            public Resolver<String, ChunkerEnchantmentType> enchantmentResolver() {
                return JavaResolversBuilder.this.enchantmentResolver;
            }

            @Override
            public Resolver<Integer, ChunkerEnchantmentType> enchantmentIDResolver() {
                return JavaResolversBuilder.this.enchantmentIDResolver;
            }

            @Override
            public Resolver<String, ChunkerTrimPattern> trimPatternResolver() {
                return JavaResolversBuilder.this.trimPatternResolver;
            }

            @Override
            public Resolver<String, ChunkerTrimMaterial> trimMaterialResolver() {
                return JavaResolversBuilder.this.trimMaterialResolver;
            }

            @Override
            public Resolver<String, ChunkerBannerPattern> bannerPatternResolver() {
                return JavaResolversBuilder.this.bannerPatternResolver;
            }

            @Override
            public Resolver<String, ChunkerBannerPattern> bannerPatternShortNameResolver() {
                return JavaResolversBuilder.this.bannerPatternShortNameResolver;
            }

            @Override
            public PreTransformManager preTransformManager() {
                return JavaResolversBuilder.this.preTransformManager;
            }

            @Override
            public Converter converter() {
                return JavaResolversBuilder.this.converter;
            }

            @Override
            public JavaDataVersion dataVersion() {
                return dataVersion;
            }

            @Override
            public Resolver<Identifier, ChunkerItemStack> chunkerItemIdentifierResolver() {
                return JavaResolversBuilder.this.itemIdentifierResolver;
            }

            @Override
            public ChunkerBiome getFallbackBiome(Dimension dimension) {
                return switch (dimension) {
                    default -> throw new IncompatibleClassChangeError();
                    case Dimension.OVERWORLD -> ChunkerBiome.ChunkerVanillaBiome.PLAINS;
                    case Dimension.NETHER -> ChunkerBiome.ChunkerVanillaBiome.NETHER_WASTES;
                    case Dimension.THE_END -> ChunkerBiome.ChunkerVanillaBiome.THE_END;
                };
            }
        };
    }

    public JavaResolversBuilder nbtBlockIdentifierResolver(Resolver<CompoundTag, Identifier> resolver) {
        this.nbtBlockIdentifierResolver = resolver;
        return this;
    }

    public JavaResolversBuilder itemIdentifierResolver(Resolver<Identifier, ChunkerItemStack> resolver) {
        this.itemIdentifierResolver = resolver;
        return this;
    }

    public JavaResolversBuilder blockIdentifierResolver(Resolver<Identifier, ChunkerBlockIdentifier> resolver) {
        this.blockIdentifierResolver = this.enableCaching ? resolver.cached() : resolver;
        return this;
    }

    public JavaResolversBuilder entityTypeResolver(Resolver<String, ChunkerEntityType> resolver) {
        this.entityTypeResolver = resolver;
        return this;
    }

    public JavaResolversBuilder biomeNameResolver(Resolver<String, ChunkerBiome> resolver) {
        this.biomeNameResolver = resolver;
        return this;
    }

    public JavaResolversBuilder biomeIDResolver(Resolver<Integer, ChunkerBiome> resolver) {
        this.biomeIDResolver = resolver;
        return this;
    }

    public JavaResolversBuilder effectResolver(Resolver<String, ChunkerEffectType> resolver) {
        this.effectResolver = resolver;
        return this;
    }

    public JavaResolversBuilder effectIDResolver(Resolver<Integer, ChunkerEffectType> resolver) {
        this.effectIDResolver = resolver;
        return this;
    }

    public JavaResolversBuilder enchantmentResolver(Resolver<String, ChunkerEnchantmentType> resolver) {
        this.enchantmentResolver = resolver;
        return this;
    }

    public JavaResolversBuilder enchantmentIDResolver(Resolver<Integer, ChunkerEnchantmentType> resolver) {
        this.enchantmentIDResolver = resolver;
        return this;
    }

    public JavaResolversBuilder hornInstrumentResolver(Resolver<String, ChunkerHornInstrument> resolver) {
        this.hornInstrumentResolver = resolver;
        return this;
    }

    public JavaResolversBuilder paintingMotiveResolver(Resolver<String, PaintingEntity.Motive> resolver) {
        this.paintingMotiveResolver = resolver;
        return this;
    }

    public JavaResolversBuilder potionTypeResolver(Resolver<String, ChunkerPotionType> resolver) {
        this.potionTypeResolver = resolver;
        return this;
    }

    public JavaResolversBuilder mapColorsResolver(Resolver<byte[], byte[]> resolver) {
        this.mapColorsResolver = resolver;
        return this;
    }

    public JavaResolversBuilder blockIDResolver(Resolver<Integer, String> resolver) {
        this.blockIDResolver = resolver;
        return this;
    }

    public JavaResolversBuilder trimPatternResolver(Resolver<String, ChunkerTrimPattern> resolver) {
        this.trimPatternResolver = resolver;
        return this;
    }

    public JavaResolversBuilder trimMaterialResolver(Resolver<String, ChunkerTrimMaterial> resolver) {
        this.trimMaterialResolver = resolver;
        return this;
    }

    public JavaResolversBuilder bannerPatternResolver(Resolver<String, ChunkerBannerPattern> resolver) {
        this.bannerPatternResolver = resolver;
        return this;
    }

    public JavaResolversBuilder bannerPatternShortNameResolver(Resolver<String, ChunkerBannerPattern> resolver) {
        this.bannerPatternShortNameResolver = resolver;
        return this;
    }

    public JavaResolversBuilder itemStackResolverConstructor(Function<JavaResolvers, Resolver<CompoundTag, ChunkerItemStack>> constructor) {
        this.itemStackResolverConstructor = constructor;
        return this;
    }

    public JavaResolversBuilder blockEntityResolverConstructor(Function<JavaResolvers, BlockEntityResolver<JavaResolvers, CompoundTag>> constructor) {
        this.blockEntityResolverConstructor = constructor;
        return this;
    }

    public JavaResolversBuilder entityResolverConstructor(Function<JavaResolvers, EntityResolver<JavaResolvers, CompoundTag>> constructor) {
        this.entityResolverConstructor = constructor;
        return this;
    }

    public JavaResolversBuilder preTransformManager(PreTransformManager resolver) {
        this.preTransformManager = resolver;
        return this;
    }
}

