/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.biome;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaBiomeIDResolver
implements Resolver<Integer, ChunkerBiome> {
    private final InvertibleMap<ChunkerBiome.ChunkerVanillaBiome, Integer> mapping = InvertibleMap.enumKeys(ChunkerBiome.ChunkerVanillaBiome.class);

    public JavaBiomeIDResolver(Version javaVersion) {
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OCEAN, 0);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.PLAINS, 1);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DESERT, 2);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_HILLS, 3);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FOREST, 4);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.TAIGA, 5);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SWAMP, 6);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.RIVER, 7);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.NETHER_WASTES, 8);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.THE_END, 9);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FROZEN_OCEAN, 10);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FROZEN_RIVER, 11);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_PLAINS, 12);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_MOUNTAINS, 13);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MUSHROOM_FIELDS, 14);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MUSHROOM_FIELD_SHORE, 15);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BEACH, 16);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DESERT_HILLS, 17);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WOODED_HILLS, 18);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.TAIGA_HILLS, 19);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MOUNTAIN_EDGE, 20);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.JUNGLE, 21);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.JUNGLE_HILLS, 22);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SPARSE_JUNGLE, 23);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_OCEAN, 24);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.STONY_SHORE, 25);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_BEACH, 26);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BIRCH_FOREST, 27);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BIRCH_FOREST_HILLS, 28);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DARK_FOREST, 29);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_TAIGA, 30);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_TAIGA_HILLS, 31);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OLD_GROWTH_PINE_TAIGA, 32);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.GIANT_TREE_TAIGA_HILLS, 33);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_FOREST, 34);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SAVANNA, 35);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SAVANNA_PLATEAU, 36);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BADLANDS, 37);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WOODED_BADLANDS, 38);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BADLANDS_PLATEAU, 39);
        if (javaVersion.isGreaterThanOrEqual(1, 13, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SMALL_END_ISLANDS, 40);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.END_MIDLANDS, 41);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.END_HIGHLANDS, 42);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.END_BARRENS, 43);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WARM_OCEAN, 44);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.LUKEWARM_OCEAN, 45);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.COLD_OCEAN, 46);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_WARM_OCEAN, 47);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_LUKEWARM_OCEAN, 48);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_COLD_OCEAN, 49);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_FROZEN_OCEAN, 50);
        }
        if (javaVersion.isGreaterThanOrEqual(1, 9, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.THE_VOID, 127);
        }
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SUNFLOWER_PLAINS, 129);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DESERT_LAKES, 130);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_GRAVELLY_HILLS, 131);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FLOWER_FOREST, 132);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.TAIGA_MOUNTAINS, 133);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SWAMP_HILLS, 134);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.ICE_SPIKES, 140);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MODIFIED_JUNGLE, 149);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MODIFIED_JUNGLE_EDGE, 151);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OLD_GROWTH_BIRCH_FOREST, 155);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.TALL_BIRCH_HILLS, 156);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DARK_FOREST_HILLS, 157);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_TAIGA_MOUNTAINS, 158);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OLD_GROWTH_SPRUCE_TAIGA, 160);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.GIANT_SPRUCE_TAIGA_HILLS, 161);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MODIFIED_GRAVELLY_MOUNTAINS, 162);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_SAVANNA, 163);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SHATTERED_SAVANNA_PLATEAU, 164);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.ERODED_BADLANDS, 165);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MODIFIED_WOODED_BADLANDS_PLATEAU, 166);
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MODIFIED_BADLANDS_PLATEAU, 167);
        if (javaVersion.isGreaterThanOrEqual(1, 14, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BAMBOO_JUNGLE, 168);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BAMBOO_JUNGLE_HILLS, 169);
        }
        if (javaVersion.isGreaterThanOrEqual(1, 16, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SOUL_SAND_VALLEY, 170);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.CRIMSON_FOREST, 171);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WARPED_FOREST, 172);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BASALT_DELTAS, 173);
        }
        if (javaVersion.isGreaterThanOrEqual(1, 17, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DRIPSTONE_CAVES, 174);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.LUSH_CAVES, 175);
        }
        if (javaVersion.isGreaterThanOrEqual(1, 18, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MEADOW, 177);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.GROVE, 178);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_SLOPES, 179);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FROZEN_PEAKS, 180);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.JAGGED_PEAKS, 181);
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.STONY_PEAKS, 182);
        }
    }

    @Override
    public Optional<Integer> from(ChunkerBiome input) {
        ChunkerBiome.ChunkerVanillaBiome fallback;
        ChunkerBiome.ChunkerVanillaBiome chunkerVanillaBiome = null;
        if (input instanceof ChunkerBiome.ChunkerVanillaBiome) {
            ChunkerBiome.ChunkerVanillaBiome biome;
            chunkerVanillaBiome = biome = (ChunkerBiome.ChunkerVanillaBiome)input;
        } else if (input != null) {
            chunkerVanillaBiome = input.getFallback();
        }
        if (chunkerVanillaBiome == null) {
            return Optional.empty();
        }
        Integer mapped = this.mapping.forward().get(chunkerVanillaBiome);
        if (mapped == null && (fallback = chunkerVanillaBiome.getFallback()) != null) {
            mapped = this.mapping.forward().get(fallback);
        }
        return Optional.ofNullable(mapped);
    }

    @Override
    public Optional<ChunkerBiome> to(Integer input) {
        return Optional.ofNullable((ChunkerBiome)this.mapping.inverse().get(input));
    }
}

