/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.CustomItemNBTBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.ChiseledBookshelfBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class JavaChiseledBookshelfBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, ChiseledBookshelfBlockEntity>
implements CustomItemNBTBlockEntityHandler<JavaResolvers, ChiseledBookshelfBlockEntity> {
    public JavaChiseledBookshelfBlockEntityHandler() {
        super("minecraft:chiseled_bookshelf", ChiseledBookshelfBlockEntity.class, ChiseledBookshelfBlockEntity::new);
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull ChiseledBookshelfBlockEntity value) {
        ListTag items = input.getList("Items", CompoundTag.class, null);
        if (items != null) {
            byte index = 0;
            for (CompoundTag itemTag : items) {
                ChunkerItemStack item = resolvers.readItem(itemTag);
                if (item.getIdentifier().isAir()) continue;
                byte by = index;
                index = (byte)(index + 1);
                byte slot = itemTag.getByte("Slot", by);
                if (slot < 0 || slot >= 6) continue;
                value.getBooks()[slot] = item;
            }
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull ChiseledBookshelfBlockEntity value) {
        ListTag items = new ListTag(TagType.COMPOUND, 4);
        for (int i = 0; i < value.getBooks().length; ++i) {
            Optional<CompoundTag> item;
            ChunkerItemStack itemStack = value.getBooks()[i];
            if (itemStack == null || itemStack.getIdentifier().isAir() || (item = resolvers.writeItem(itemStack)).isEmpty()) continue;
            item.get().put("Slot", (byte)i);
            items.add(item.get());
        }
        output.put("Items", items);
    }

    @Override
    public boolean generateFromItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull ChiseledBookshelfBlockEntity output, @NotNull CompoundTag input) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return false;
        }
        CompoundTag components = input.getCompound("components");
        if (components == null) {
            return false;
        }
        ListTag items = components.getList("minecraft:container", CompoundTag.class, null);
        if (items != null) {
            int index = 0;
            for (CompoundTag itemTag : items) {
                byte slot = (byte)itemTag.getInt("slot", index);
                if ((itemTag = itemTag.getCompound("item")) == null) continue;
                ChunkerItemStack item = resolvers.readItem(itemTag);
                if (slot < 0 || slot >= output.getBooks().length) continue;
                output.getBooks()[slot] = item;
                index = (byte)(index + 1);
            }
        }
        return true;
    }

    @Override
    public boolean writeToItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull ChiseledBookshelfBlockEntity input, @NotNull CompoundTag output) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return true;
        }
        CompoundTag components = output.getOrCreateCompound("components");
        ListTag items = new ListTag(TagType.COMPOUND, input.getBooks().length);
        for (int i = 0; i < input.getBooks().length; ++i) {
            Optional<CompoundTag> item;
            ChunkerItemStack chunkerItem = input.getBooks()[i];
            if (chunkerItem == null || chunkerItem.getIdentifier().isAir() || (item = resolvers.writeItem(chunkerItem)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag(2);
            itemTag.put("slot", i);
            itemTag.put("item", item.get());
            items.add(itemTag);
        }
        components.put("minecraft:container", items);
        return false;
    }
}

