/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.CustomItemNBTBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.ContainerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.util.JsonTextUtil;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class JavaContainerBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, ContainerBlockEntity>
implements CustomItemNBTBlockEntityHandler<JavaResolvers, ContainerBlockEntity> {
    public JavaContainerBlockEntityHandler() {
        super("minecraft:container", ContainerBlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to initialize type of container");
        });
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull ContainerBlockEntity value) {
        ListTag items = input.getList("Items", CompoundTag.class, null);
        if (items != null) {
            byte index = 0;
            for (CompoundTag itemTag : items) {
                byte slot = itemTag.getByte("Slot", index);
                ChunkerItemStack item = resolvers.readItem(itemTag);
                value.getItems().put(slot, item);
                index = (byte)(index + 1);
            }
        }
        value.setCustomName(input.getOptional("CustomName", Tag.class).map(JsonTextUtil::fromNBT).orElse(null));
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull ContainerBlockEntity value) {
        ListTag items = new ListTag(TagType.COMPOUND, value.getItems().size());
        for (Byte2ObjectMap.Entry tag : value.getItems().byte2ObjectEntrySet()) {
            Optional<CompoundTag> item;
            if (((ChunkerItemStack)tag.getValue()).getIdentifier().isAir() || (item = resolvers.writeItem((ChunkerItemStack)tag.getValue())).isEmpty()) continue;
            item.get().put("Slot", tag.getByteKey());
            items.add(item.get());
        }
        output.put("Items", items);
        if (value.getCustomName() != null) {
            output.put("CustomName", JsonTextUtil.toNBT(value.getCustomName(), resolvers.dataVersion()));
        }
    }

    @Override
    public boolean generateFromItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull ContainerBlockEntity output, @NotNull CompoundTag input) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return false;
        }
        CompoundTag components = input.getCompound("components");
        if (components == null) {
            return false;
        }
        ListTag items = components.getList("minecraft:container", CompoundTag.class, null);
        if (items != null) {
            int index = 0;
            for (CompoundTag itemTag : items) {
                byte slot = (byte)itemTag.getInt("slot", index);
                if ((itemTag = itemTag.getCompound("item")) == null) continue;
                ChunkerItemStack item = resolvers.readItem(itemTag);
                output.getItems().put(slot, item);
                index = (byte)(index + 1);
            }
        }
        output.setCustomName(components.getOptional("minecraft:custom_name", Tag.class).map(JsonTextUtil::fromNBT).orElse(null));
        return true;
    }

    @Override
    public boolean writeToItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull ContainerBlockEntity input, @NotNull CompoundTag output) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return true;
        }
        CompoundTag components = output.getOrCreateCompound("components");
        ListTag items = new ListTag(TagType.COMPOUND, input.getItems().size());
        for (Byte2ObjectMap.Entry tag : input.getItems().byte2ObjectEntrySet()) {
            Optional<CompoundTag> item;
            if (((ChunkerItemStack)tag.getValue()).getIdentifier().isAir() || (item = resolvers.writeItem((ChunkerItemStack)tag.getValue())).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag(2);
            itemTag.put("slot", (int)tag.getByteKey());
            itemTag.put("item", item.get());
            items.add(itemTag);
        }
        components.put("minecraft:container", items);
        if (input.getCustomName() != null) {
            components.put("minecraft:custom_name", JsonTextUtil.toNBT(input.getCustomName(), resolvers.dataVersion()));
        }
        return false;
    }
}

