/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.CustomItemNBTBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.RandomizableContainerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaRandomizableContainerBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, RandomizableContainerBlockEntity>
implements CustomItemNBTBlockEntityHandler<JavaResolvers, RandomizableContainerBlockEntity> {
    public static final Set<String> UNSUPPORTED_LOOT_TABLES = Set.of("minecraft:chests/monster_room", "minecraft:chests/village_two_room_house");
    public static final BiMap<String, String> PRE_1_14_LOOT_TABLES = ((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("minecraft:chests/village/village_weaponsmith", "minecraft:chests/village_blacksmith")).build();
    private final boolean enableLootTables;

    public JavaRandomizableContainerBlockEntityHandler(boolean enabledLootTables) {
        super("RandomizableBlockEntity", RandomizableContainerBlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to construct RandomizableBlockEntity, invalid type!");
        });
        this.enableLootTables = enabledLootTables;
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull RandomizableContainerBlockEntity blockEntity) {
        String lootTable = input.getString("LootTable", null);
        if (lootTable != null && !lootTable.isEmpty() && this.enableLootTables) {
            blockEntity.setLootTable(this.applyVersionSpecificLootTableFixes(resolvers, lootTable, false));
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull RandomizableContainerBlockEntity blockEntity) {
        if (blockEntity.getLootTable() != null && !blockEntity.getLootTable().isEmpty() && !UNSUPPORTED_LOOT_TABLES.contains(blockEntity.getLootTable()) && this.enableLootTables) {
            output.put("LootTable", this.applyVersionSpecificLootTableFixes(resolvers, blockEntity.getLootTable(), true));
        }
    }

    @Override
    public boolean generateFromItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull RandomizableContainerBlockEntity output, @NotNull CompoundTag input) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return false;
        }
        CompoundTag components = input.getCompound("components");
        if (components == null || !this.enableLootTables) {
            return false;
        }
        CompoundTag component = components.getCompound("minecraft:container_loot");
        if (component == null) {
            return false;
        }
        String lootTable = component.getString("loot_table", null);
        if (lootTable != null && !lootTable.isEmpty()) {
            output.setLootTable(this.applyVersionSpecificLootTableFixes(resolvers, lootTable, false));
        }
        return false;
    }

    @Override
    public boolean writeToItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull RandomizableContainerBlockEntity input, @NotNull CompoundTag output) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5) || !this.enableLootTables) {
            return true;
        }
        if (input.getLootTable() != null && !input.getLootTable().isEmpty() && !UNSUPPORTED_LOOT_TABLES.contains(input.getLootTable())) {
            output.getOrCreateCompound("components").getOrCreateCompound("minecraft:container_loot").put("loot_table", this.applyVersionSpecificLootTableFixes(resolvers, input.getLootTable(), true));
        }
        return false;
    }

    public String applyVersionSpecificLootTableFixes(@NotNull JavaResolvers resolvers, String lootTable, boolean writing) {
        if (!writing) {
            return lootTable;
        }
        if (resolvers.dataVersion().getVersion().isLessThan(1, 14, 0)) {
            return PRE_1_14_LOOT_TABLES.getOrDefault(lootTable, lootTable);
        }
        return PRE_1_14_LOOT_TABLES.inverse().getOrDefault(lootTable, lootTable);
    }
}

