/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.entity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EmptyEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.handlers.JavaEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.handlers.JavaHangingEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.handlers.JavaItemFrameEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.handlers.JavaPaintingEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.entity.GlowItemFrameEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerVanillaEntityType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Optional;

public class JavaEntityResolver
extends EntityResolver<JavaResolvers, CompoundTag> {
    public JavaEntityResolver(Version version, JavaResolvers resolvers) {
        super(version, resolvers, resolvers.converter().shouldAllowNBTCopying());
    }

    @Override
    protected void registerTypeHandlers(Version version) {
        this.register(new JavaEntityHandler());
        this.register(new JavaHangingEntityHandler());
        this.register(new JavaPaintingEntityHandler());
        this.register(new JavaItemFrameEntityHandler());
        this.register(new EmptyEntityHandler(ChunkerVanillaEntityType.GLOW_ITEM_FRAME, GlowItemFrameEntity.class, GlowItemFrameEntity::new));
    }

    @Override
    protected CompoundTag constructDataType(ChunkerEntityType type) {
        Optional<String> key = ((JavaResolvers)this.resolvers).entityTypeResolver().from(type);
        if (key.isEmpty()) {
            return null;
        }
        CompoundTag compoundTag = new CompoundTag(4);
        compoundTag.put("id", key.get());
        return compoundTag;
    }

    @Override
    public Optional<ChunkerEntityType> getKey(CompoundTag input) {
        return input.getOptionalValue("id", String.class).flatMap(((JavaResolvers)this.resolvers).entityTypeResolver()::to);
    }
}

