/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.banner.ChunkerBannerPattern;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaBannerPatternResolver
implements Resolver<String, ChunkerBannerPattern> {
    private final InvertibleMap<ChunkerBannerPattern, String> mapping = InvertibleMap.enumKeys(ChunkerBannerPattern.class);

    public JavaBannerPatternResolver(Version version) {
        this.mapping.put(ChunkerBannerPattern.BASE, "minecraft:base");
        this.mapping.put(ChunkerBannerPattern.SQUARE_BOTTOM_LEFT, "minecraft:square_bottom_left");
        this.mapping.put(ChunkerBannerPattern.SQUARE_BOTTOM_RIGHT, "minecraft:square_bottom_right");
        this.mapping.put(ChunkerBannerPattern.SQUARE_TOP_LEFT, "minecraft:square_top_left");
        this.mapping.put(ChunkerBannerPattern.SQUARE_TOP_RIGHT, "minecraft:square_top_right");
        this.mapping.put(ChunkerBannerPattern.STRIPE_BOTTOM, "minecraft:stripe_bottom");
        this.mapping.put(ChunkerBannerPattern.STRIPE_TOP, "minecraft:stripe_top");
        this.mapping.put(ChunkerBannerPattern.STRIPE_LEFT, "minecraft:stripe_left");
        this.mapping.put(ChunkerBannerPattern.STRIPE_RIGHT, "minecraft:stripe_right");
        this.mapping.put(ChunkerBannerPattern.STRIPE_CENTER, "minecraft:stripe_center");
        this.mapping.put(ChunkerBannerPattern.STRIPE_MIDDLE, "minecraft:stripe_middle");
        this.mapping.put(ChunkerBannerPattern.STRIPE_DOWNRIGHT, "minecraft:stripe_downright");
        this.mapping.put(ChunkerBannerPattern.STRIPE_DOWNLEFT, "minecraft:stripe_downleft");
        this.mapping.put(ChunkerBannerPattern.STRIPE_SMALL, "minecraft:small_stripes");
        this.mapping.put(ChunkerBannerPattern.CROSS, "minecraft:cross");
        this.mapping.put(ChunkerBannerPattern.STRAIGHT_CROSS, "minecraft:straight_cross");
        this.mapping.put(ChunkerBannerPattern.TRIANGLE_BOTTOM, "minecraft:triangle_bottom");
        this.mapping.put(ChunkerBannerPattern.TRIANGLE_TOP, "minecraft:triangle_top");
        this.mapping.put(ChunkerBannerPattern.TRIANGLES_BOTTOM, "minecraft:triangles_bottom");
        this.mapping.put(ChunkerBannerPattern.TRIANGLES_TOP, "minecraft:triangles_top");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_LEFT, "minecraft:diagonal_left");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_RIGHT, "minecraft:diagonal_up_right");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_LEFT_MIRROR, "minecraft:diagonal_up_left");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_RIGHT_MIRROR, "minecraft:diagonal_right");
        this.mapping.put(ChunkerBannerPattern.CIRCLE_MIDDLE, "minecraft:circle");
        this.mapping.put(ChunkerBannerPattern.RHOMBUS_MIDDLE, "minecraft:rhombus");
        this.mapping.put(ChunkerBannerPattern.HALF_VERTICAL, "minecraft:half_vertical");
        this.mapping.put(ChunkerBannerPattern.HALF_HORIZONTAL, "minecraft:half_horizontal");
        this.mapping.put(ChunkerBannerPattern.HALF_VERTICAL_MIRROR, "minecraft:half_vertical_right");
        this.mapping.put(ChunkerBannerPattern.HALF_HORIZONTAL_MIRROR, "minecraft:half_horizontal_bottom");
        this.mapping.put(ChunkerBannerPattern.BORDER, "minecraft:border");
        this.mapping.put(ChunkerBannerPattern.CURLY_BORDER, "minecraft:curly_border");
        this.mapping.put(ChunkerBannerPattern.GRADIENT, "minecraft:gradient");
        this.mapping.put(ChunkerBannerPattern.GRADIENT_UP, "minecraft:gradient_up");
        this.mapping.put(ChunkerBannerPattern.BRICKS, "minecraft:bricks");
        this.mapping.put(ChunkerBannerPattern.GLOBE, "minecraft:globe");
        this.mapping.put(ChunkerBannerPattern.CREEPER, "minecraft:creeper");
        this.mapping.put(ChunkerBannerPattern.SKULL, "minecraft:skull");
        this.mapping.put(ChunkerBannerPattern.FLOWER, "minecraft:flower");
        this.mapping.put(ChunkerBannerPattern.MOJANG, "minecraft:mojang");
        this.mapping.put(ChunkerBannerPattern.PIGLIN, "minecraft:piglin");
        if (version.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerBannerPattern.FLOW, "minecraft:flow");
            this.mapping.put(ChunkerBannerPattern.GUSTER, "minecraft:guster");
        }
    }

    @Override
    public Optional<String> from(ChunkerBannerPattern input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerBannerPattern> to(String input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

