/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.TagWithName;
import com.hivemc.chunker.nbt.tags.array.ByteArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.util.ByteUtil;
import com.hivemc.chunker.util.LegacyIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaChunkWriter {
    public static final byte[] EMPTY_LIGHT_ARRAY = new byte[2048];
    protected final JavaResolvers resolvers;
    protected final Converter converter;
    protected final Dimension dimension;
    protected final ChunkerColumn chunkerColumn;

    public JavaChunkWriter(Converter converter, JavaResolvers resolvers, Dimension dimension, ChunkerColumn chunkerColumn) {
        this.resolvers = resolvers;
        this.converter = converter;
        this.dimension = dimension;
        this.chunkerColumn = chunkerColumn;
    }

    @Nullable
    public CompoundTag writeChunk(@Nullable ChunkerChunk chunkerChunk) {
        if (chunkerChunk == null || this.converter.shouldDiscardEmptyChunks() && chunkerChunk.isEmpty()) {
            return null;
        }
        if (!this.isChunkHeightSupported(chunkerChunk.getY())) {
            return null;
        }
        CompoundTag output = new CompoundTag(4);
        output.put("Y", chunkerChunk.getY());
        List<TagWithName<?>> outputs = Collections.synchronizedList(new ArrayList(3));
        List<Task<Void>> tasks = this.createChunkTasks(chunkerChunk, outputs);
        Task.join(tasks).then("Combining Chunk NBT", TaskWeight.LOW, () -> {
            for (TagWithName tag : outputs) {
                if (tag == null) continue;
                output.put(tag.name(), (Tag<?>)tag.tag());
            }
        });
        return output;
    }

    protected List<Task<Void>> createChunkTasks(ChunkerChunk chunkerChunk, List<TagWithName<?>> outputs) {
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(2);
        tasks.add(Task.async("Writing Block Palette", TaskWeight.HIGH, () -> this.writeBlockPalette(chunkerChunk, outputs)));
        tasks.add(Task.async("Writing Light Data", TaskWeight.MEDIUM, () -> this.writeLightData(chunkerChunk, outputs)));
        return tasks;
    }

    protected boolean isChunkHeightSupported(byte chunkY) {
        return chunkY >= 0 && chunkY < 16;
    }

    protected void writeBlockPalette(ChunkerChunk chunk, List<TagWithName<?>> output) {
        byte[] blockArray = new byte[4096];
        byte[] addArray = new byte[2048];
        byte[] dataArray = new byte[2048];
        if (!chunk.isEmpty()) {
            for (int i = 0; i < 4096; ++i) {
                int x = i & 0xF;
                int z = i >> 4 & 0xF;
                int y = i >> 8 & 0xF;
                int nibbleIndex = i >> 1;
                boolean lowestBits = (i & 1) == 0;
                ChunkerBlockIdentifier identifier = chunk.getPalette().get(x, y, z, ChunkerBlockIdentifier.AIR);
                LegacyIdentifier legacyIdentifier = this.resolvers.writeLegacyBlockIdentifier(identifier);
                byte blockValue = (byte)(legacyIdentifier.id() & 0xFF);
                byte addValue = (byte)(legacyIdentifier.id() >> 8 & 0xFF);
                blockArray[i] = blockValue;
                addArray[nibbleIndex] = ByteUtil.updateNibble(addArray[nibbleIndex], addValue, lowestBits);
                dataArray[nibbleIndex] = ByteUtil.updateNibble(dataArray[nibbleIndex], legacyIdentifier.data(), lowestBits);
            }
        }
        output.add(new TagWithName<ByteArrayTag>("Blocks", new ByteArrayTag(blockArray)));
        output.add(new TagWithName<ByteArrayTag>("Add", new ByteArrayTag(addArray)));
        output.add(new TagWithName<ByteArrayTag>("Data", new ByteArrayTag(dataArray)));
    }

    protected void writeLightData(ChunkerChunk chunk, List<TagWithName<?>> output) {
        if (chunk.getBlockLight() != null) {
            byte[] blockLightArray = ByteUtil.convertToNibbleArray(chunk.getBlockLight());
            output.add(new TagWithName<ByteArrayTag>("BlockLight", new ByteArrayTag(blockLightArray)));
        } else {
            output.add(new TagWithName<ByteArrayTag>("BlockLight", new ByteArrayTag(EMPTY_LIGHT_ARRAY)));
        }
        if (this.dimension != Dimension.NETHER) {
            if (chunk.getSkyLight() != null) {
                byte[] skyLightArray = ByteUtil.convertToNibbleArray(chunk.getSkyLight());
                output.add(new TagWithName<ByteArrayTag>("SkyLight", new ByteArrayTag(skyLightArray)));
            } else {
                output.add(new TagWithName<ByteArrayTag>("SkyLight", new ByteArrayTag(EMPTY_LIGHT_ARRAY)));
            }
        }
    }
}

