/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaLevelReader;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaColumnWriter;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JavaWorldWriter
implements WorldWriter {
    public static final int OVERSIZED_THRESHOLD = 0x100000;
    protected final File outputFolder;
    protected final Converter converter;
    protected final JavaResolvers resolvers;
    protected final Map<File, RandomAccessFile> mcaFiles = new ConcurrentHashMap<File, RandomAccessFile>();

    public JavaWorldWriter(File outputFolder, Converter converter, JavaResolvers resolvers) {
        this.outputFolder = outputFolder;
        this.converter = converter;
        this.resolvers = resolvers;
    }

    @Override
    public ColumnWriter writeWorld(ChunkerWorld chunkerWorld) {
        File directory = JavaLevelReader.getDimensionBaseDirectory(this.outputFolder, chunkerWorld.getDimension());
        directory.mkdirs();
        return this.createColumnWriter(chunkerWorld.getDimension());
    }

    @Override
    public void flushWorld(ChunkerWorld chunkerWorld) {
    }

    @Override
    public void flushWorlds() throws IOException {
        for (RandomAccessFile randomAccessFile : this.mcaFiles.values()) {
            try {
                randomAccessFile.close();
            }
            catch (Exception e) {
                this.converter.logNonFatalException(e);
            }
        }
    }

    public void writeMCAData(Dimension dimension, ChunkCoordPair chunkCoordPair, CompoundTag chunkData) throws Exception {
        File directory = new File(JavaLevelReader.getDimensionBaseDirectory(this.outputFolder, dimension), "region");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File regionFile = new File(directory, "r." + chunkCoordPair.regionX() + "." + chunkCoordPair.regionZ() + ".mca");
        this.writeMCAData(regionFile, chunkCoordPair, chunkData);
    }

    public void writePOIData(Dimension dimension, ChunkCoordPair chunkCoordPair, CompoundTag chunkData) throws Exception {
        File directory = new File(JavaLevelReader.getDimensionBaseDirectory(this.outputFolder, dimension), "poi");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File regionFile = new File(directory, "r." + chunkCoordPair.regionX() + "." + chunkCoordPair.regionZ() + ".mca");
        this.writeMCAData(regionFile, chunkCoordPair, chunkData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMCAData(File file, ChunkCoordPair chunkCoordPair, CompoundTag chunkData) throws Exception {
        RandomAccessFile randomAccessFile;
        boolean oversized;
        byte[] bytes = Tag.writeZLibJavaNBT(chunkData);
        long columnLookupOffset = (chunkCoordPair.chunkX() & 0x1F) + ((chunkCoordPair.chunkZ() & 0x1F) << 5) << 2;
        boolean bl = oversized = bytes.length >= 0x100000;
        if (oversized) {
            File oversizedFile = new File(file.getParent(), "c." + chunkCoordPair.chunkX() + "." + chunkCoordPair.chunkZ() + ".mcc");
            Files.write(oversizedFile.toPath(), bytes, new OpenOption[0]);
        }
        int sectorCount = oversized ? 1 : (int)Math.ceil((double)(bytes.length + 5) / 4096.0);
        RandomAccessFile randomAccessFile2 = randomAccessFile = this.mcaFiles.computeIfAbsent(file, target -> {
            try {
                return new RandomAccessFile((File)target, "rw");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        synchronized (randomAccessFile2) {
            Writer writer = Writer.toJavaWriter(randomAccessFile);
            randomAccessFile.seek(Math.max(8192L, randomAccessFile.length()));
            long position = randomAccessFile.getFilePointer();
            int sectorPosition = (int)(position >> 12);
            if (oversized) {
                writer.writeInt(1);
                writer.writeByte(130);
            } else {
                writer.writeInt(bytes.length + 1);
                writer.writeByte(2);
                writer.writeBytes(bytes);
            }
            randomAccessFile.setLength((long)(sectorPosition + sectorCount) << 12);
            randomAccessFile.seek(columnLookupOffset);
            writer.writeUnsignedInt24(sectorPosition);
            writer.writeByte(sectorCount);
        }
    }

    public JavaColumnWriter createColumnWriter(Dimension dimension) {
        return new JavaColumnWriter(this, this.converter, this.resolvers, dimension);
    }
}

