/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.util;

import com.google.common.io.Resources;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FontUtil {
    private static final Int2ByteMap CODE_POINT_TO_WIDTH = new Int2ByteOpenHashMap();

    public static int getWidth(int codePoint) {
        return CODE_POINT_TO_WIDTH.getOrDefault(codePoint, (byte)0);
    }

    public static int getWidth(String input) {
        int codePoint;
        int width = 0;
        for (int i = 0; i < input.length(); i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            width += FontUtil.getWidth(codePoint);
        }
        return width;
    }

    public static List<String> splitLine(int maxWidth, String input) {
        int codePoint;
        ArrayList<String> lines = new ArrayList<String>();
        int lineWidth = 0;
        int wordWidth = 0;
        boolean skipNext = false;
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentWord = new StringBuilder();
        for (int i = 0; i < input.length(); i += Character.charCount(codePoint)) {
            int width;
            codePoint = input.codePointAt(i);
            int n = width = skipNext || codePoint == 167 ? 0 : FontUtil.getWidth(codePoint);
            if (skipNext) {
                skipNext = false;
            } else if (codePoint == 167) {
                skipNext = true;
            }
            if (Character.isSpaceChar(codePoint)) {
                int spaceWidth = FontUtil.getWidth(" ");
                if (lineWidth + wordWidth + spaceWidth > maxWidth) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                    lineWidth = 0;
                } else if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                    lineWidth += spaceWidth;
                }
                currentLine.append((CharSequence)currentWord);
                lineWidth += wordWidth;
                currentWord = new StringBuilder();
                wordWidth = 0;
                continue;
            }
            currentWord.appendCodePoint(codePoint);
            wordWidth += width;
        }
        if (!currentWord.isEmpty()) {
            int whitespaceWidth = FontUtil.getWidth(" ");
            if (lineWidth + wordWidth + whitespaceWidth > maxWidth) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
            } else if (!currentLine.isEmpty()) {
                currentLine.append(" ");
            }
            currentLine.append((CharSequence)currentWord);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static String[] split(int maxWidth, int maxLines, String[] original) {
        if (original.length >= maxLines || original.length == 0) {
            return original;
        }
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : original) {
            List<String> splitLines = FontUtil.splitLine(maxWidth, line);
            newLines.addAll(splitLines);
        }
        return newLines.subList(0, Math.min(newLines.size(), maxLines)).toArray(new String[0]);
    }

    static {
        try (InputStream stream = Resources.getResource("java/default_font_width_codepoints.json").openStream();
             InputStreamReader inputStreamReader = new InputStreamReader(stream);){
            JsonArray nestedCodePoints = JsonParser.parseReader(inputStreamReader).getAsJsonArray();
            for (byte width = 0; width < nestedCodePoints.size(); width = (byte)((byte)(width + 1))) {
                JsonArray codePoints = nestedCodePoints.get(width).getAsJsonArray();
                for (JsonElement element : codePoints) {
                    CODE_POINT_TO_WIDTH.put(element.getAsInt(), width);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

