/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_16.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaWorldWriter;
import com.hivemc.chunker.conversion.encoding.java.v1_16.writer.WorldWriter;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelPlayer;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class LevelWriter
extends com.hivemc.chunker.conversion.encoding.java.v1_15.writer.LevelWriter {
    public LevelWriter(File outputFolder, Version version, Converter converter) {
        super(outputFolder, version, converter);
    }

    @Override
    public JavaWorldWriter createWorldWriter() {
        return new WorldWriter(this.outputFolder, this.converter, this.resolvers);
    }

    @Override
    protected CompoundTag prepareMap(ChunkerMap chunkerMap) throws Exception {
        CompoundTag map = super.prepareMap(chunkerMap);
        map.put("dimension", chunkerMap.getDimension().getIdentifier());
        return map;
    }

    @Override
    protected void writePlayer(ChunkerLevel chunkerLevel, CompoundTag level, @Nullable ChunkerLevelPlayer player) throws Exception {
        super.writePlayer(chunkerLevel, level, player);
        if (player != null) {
            CompoundTag playerTag = level.getOrCreateCompound("Player");
            playerTag.put("Dimension", player.getDimension().getIdentifier());
        }
    }

    @Override
    public void writeCustomLevelSetting(ChunkerLevelSettings chunkerLevelSettings, CompoundTag output, String targetName, Object value) {
        if (targetName.equals("RandomSeed")) {
            return;
        }
        if (value instanceof ChunkerGeneratorType) {
            ChunkerGeneratorType generatorType = (ChunkerGeneratorType)((Object)value);
            if (!this.converter.shouldAllowNBTCopying() && generatorType == ChunkerGeneratorType.CUSTOM) {
                generatorType = ChunkerGeneratorType.VOID;
            }
            switch (generatorType) {
                case NORMAL: 
                case FLAT: 
                case VOID: {
                    long seed = Long.parseLong(chunkerLevelSettings.RandomSeed);
                    CompoundTag dimensions = new CompoundTag(3);
                    dimensions.put("minecraft:overworld", this.createDimension("minecraft:overworld", generatorType, seed));
                    dimensions.put("minecraft:the_end", this.createDimension("minecraft:the_end", ChunkerGeneratorType.NORMAL, seed));
                    dimensions.put("minecraft:the_nether", this.createDimension("minecraft:the_nether", ChunkerGeneratorType.NORMAL, seed));
                    CompoundTag worldGenSettings = new CompoundTag(4);
                    worldGenSettings.put("bonus_chest", (byte)(chunkerLevelSettings.bonusChestEnabled ? 1 : 0));
                    worldGenSettings.put("generate_features", (byte)(chunkerLevelSettings.MapFeatures ? 1 : 0));
                    worldGenSettings.put("seed", seed);
                    worldGenSettings.put("dimensions", dimensions);
                    output.put("WorldGenSettings", worldGenSettings);
                    return;
                }
                case CUSTOM: {
                    return;
                }
            }
        }
        super.writeCustomLevelSetting(chunkerLevelSettings, output, targetName, value);
    }

    protected CompoundTag createDimension(String dimension, ChunkerGeneratorType type, long seed) {
        CompoundTag tag = new CompoundTag(2);
        CompoundTag generator = new CompoundTag(4);
        generator.put("type", type == ChunkerGeneratorType.NORMAL ? "minecraft:noise" : "minecraft:flat");
        if (type == ChunkerGeneratorType.NORMAL) {
            generator.put("settings", dimension.replace("the_", ""));
            generator.put("seed", seed);
            generator.put("biome_source", this.createDimensionBiomeSource(dimension, seed));
        } else {
            CompoundTag settings = new CompoundTag(3);
            CompoundTag structures = new CompoundTag(1);
            structures.put("structures", new CompoundTag());
            settings.put("structures", structures);
            settings.put("biome", this.resolvers.writeBiome(ChunkerBiome.ChunkerVanillaBiome.PLAINS, Dimension.OVERWORLD));
            ListTag layers = new ListTag(TagType.COMPOUND, 3);
            if (type == ChunkerGeneratorType.FLAT) {
                CompoundTag bedrockLayer = new CompoundTag(2);
                bedrockLayer.put("block", "minecraft:bedrock");
                bedrockLayer.put("height", 1);
                layers.add(bedrockLayer);
                CompoundTag dirtLayer = new CompoundTag(2);
                dirtLayer.put("block", "minecraft:dirt");
                dirtLayer.put("height", 2);
                layers.add(dirtLayer);
                CompoundTag grassLayer = new CompoundTag(2);
                grassLayer.put("block", "minecraft:grass_block");
                grassLayer.put("height", 1);
                layers.add(grassLayer);
            } else if (type == ChunkerGeneratorType.VOID) {
                CompoundTag airLayer = new CompoundTag(2);
                airLayer.put("block", "minecraft:air");
                airLayer.put("height", 1);
                layers.add(airLayer);
            }
            settings.put("layers", layers);
            generator.put("settings", settings);
        }
        tag.put("generator", generator);
        tag.put("type", dimension);
        return tag;
    }

    protected CompoundTag createDimensionBiomeSource(String dimension, long seed) {
        CompoundTag biomes = new CompoundTag(3);
        biomes.put("seed", seed);
        if (dimension.equals("minecraft:overworld")) {
            biomes.put("type", "minecraft:vanilla_layered");
            biomes.put("large_biomes", (byte)0);
        }
        if (dimension.equals("minecraft:the_end")) {
            biomes.put("type", "minecraft:the_end");
        }
        if (dimension.equals("minecraft:the_nether")) {
            biomes.put("preset", "minecraft:nether");
            biomes.put("type", "minecraft:multi_noise");
        }
        return biomes;
    }
}

