/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_21_11.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaWorldReader;
import com.hivemc.chunker.conversion.encoding.java.v1_21_11.reader.WorldReader;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import java.io.File;

public class LevelReader
extends com.hivemc.chunker.conversion.encoding.java.v1_21_9.reader.LevelReader {
    public LevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        super(inputDirectory, inputVersion, converter);
    }

    @Override
    protected CompoundTag prepareNBTForLevelSettings(CompoundTag level) throws Exception {
        level = super.prepareNBTForLevelSettings(level);
        if ((level = level.clone()).contains("game_rules")) {
            CompoundTag gameRules = (CompoundTag)level.remove("game_rules");
            level.put("GameRules", gameRules);
            this.convertBooleanGameRule(gameRules, "announceAdvancements", "minecraft:show_advancement_messages");
            this.convertBooleanGameRule(gameRules, "commandBlockOutput", "minecraft:command_block_output");
            this.convertBooleanGameRule(gameRules, "doDaylightCycle", "minecraft:advance_time");
            this.convertBooleanGameRule(gameRules, "doEntityDrops", "minecraft:entity_drops");
            this.convertBooleanGameRule(gameRules, "doLimitedCrafting", "minecraft:limited_crafting");
            this.convertBooleanGameRule(gameRules, "doMobLoot", "minecraft:mob_drops");
            this.convertBooleanGameRule(gameRules, "doMobSpawning", "minecraft:spawn_mobs");
            this.convertBooleanGameRule(gameRules, "doTileDrops", "minecraft:block_drops");
            this.convertBooleanGameRule(gameRules, "doWeatherCycle", "minecraft:advance_weather");
            this.convertBooleanGameRule(gameRules, "keepInventory", "minecraft:keep_inventory");
            this.convertBooleanGameRule(gameRules, "logAdminCommands", "minecraft:log_admin_commands");
            this.convertBooleanGameRule(gameRules, "mobGriefing", "minecraft:mob_griefing");
            this.convertBooleanGameRule(gameRules, "naturalRegeneration", "minecraft:natural_health_regeneration");
            this.convertBooleanGameRule(gameRules, "reducedDebugInfo", "minecraft:reduced_debug_info");
            this.convertBooleanGameRule(gameRules, "sendCommandFeedback", "minecraft:send_command_feedback");
            this.convertBooleanGameRule(gameRules, "showDeathMessages", "minecraft:show_death_messages");
            this.convertBooleanGameRule(gameRules, "spectatorsGenerateChunks", "minecraft:spectators_generate_chunks");
            this.convertInvertedBooleanGameRule(gameRules, "disableElytraMovementCheck", "minecraft:elytra_movement_check");
            if (gameRules.contains("minecraft:fire_spread_radius_around_player")) {
                IntTag tag = (IntTag)gameRules.remove("minecraft:fire_spread_radius_around_player");
                gameRules.put("doFireTick", tag.getValue() == 0 ? "false" : "true");
            } else {
                gameRules.put("doFireTick", "true");
            }
            this.convertIntegerGameRule(gameRules, "maxEntityCramming", "minecraft:max_entity_cramming");
            this.convertIntegerGameRule(gameRules, "maxCommandChainLength", "minecraft:max_command_sequence_length");
            this.convertIntegerGameRule(gameRules, "randomTickSpeed", "minecraft:random_tick_speed");
            this.convertIntegerGameRule(gameRules, "spawnRadius", "minecraft:respawn_radius");
        }
        return level;
    }

    protected void convertBooleanGameRule(CompoundTag gameRules, String oldName, String newName) {
        Tag<?> oldTag = gameRules.remove(newName);
        if (oldTag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)oldTag;
            gameRules.put(oldName, byteTag.getValue() == 1 ? "true" : "false");
        }
    }

    protected void convertInvertedBooleanGameRule(CompoundTag gameRules, String oldName, String newName) {
        Tag<?> oldTag = gameRules.remove(newName);
        if (oldTag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)oldTag;
            gameRules.put(oldName, byteTag.getValue() == 1 ? "false" : "true");
        }
    }

    protected void convertIntegerGameRule(CompoundTag gameRules, String oldName, String newName) {
        Tag<?> oldTag = gameRules.remove(newName);
        if (oldTag instanceof IntTag) {
            IntTag intTag = (IntTag)oldTag;
            gameRules.put(oldName, String.valueOf(intTag.getValue()));
        }
    }

    @Override
    public JavaWorldReader createWorldReader(File dimensionFolder, Dimension dimension) {
        return new WorldReader(this.converter, this.resolvers, dimensionFolder, dimension);
    }
}

