/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.preview;

import com.google.common.collect.Sets;
import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.preview.PreviewWorldWriter;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import it.unimi.dsi.fastutil.Pair;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;

public class PreviewColumnWriter
implements ColumnWriter {
    private final File outputFolder;
    private final ConcurrentMap<RegionCoordPair, ConcurrentMap<ChunkCoordPair, int[]>> chunkRGBA = new ConcurrentHashMap<RegionCoordPair, ConcurrentMap<ChunkCoordPair, int[]>>();
    private final PreviewWorldWriter.WorldData worldData;

    public PreviewColumnWriter(File outputFolder, PreviewWorldWriter.WorldData worldData) {
        this.outputFolder = outputFolder;
        this.worldData = worldData;
    }

    @Override
    public void writeColumn(ChunkerColumn chunkerColumn) {
        int[] argb = new int[256];
        boolean present = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Pair<Integer, ChunkerBlockIdentifier> block = chunkerColumn.getHighestBlock(x, z, ChunkerBlockIdentifier::hasRGBColor);
                if (block == null) continue;
                present = true;
                int rgb = block.value().getRGBColor();
                argb[z << 4 | x] = rgb == 0 ? 0 : 0xFF000000 | rgb;
            }
        }
        RegionCoordPair regionCoordPair = chunkerColumn.getPosition().getRegion();
        ConcurrentMap regionRGBA = this.chunkRGBA.computeIfAbsent(regionCoordPair, ignored -> new ConcurrentHashMap());
        if (present) {
            regionRGBA.put(chunkerColumn.getPosition(), argb);
            Set chunks = this.worldData.regionToPresentChunks.computeIfAbsent(regionCoordPair, ignored -> Sets.newConcurrentHashSet());
            chunks.add(chunkerColumn.getPosition());
        }
    }

    @Override
    public void flushColumns() {
        for (Set<ChunkCoordPair> set : this.worldData.regionToPresentChunks.values()) {
            for (ChunkCoordPair chunk : set) {
                if (chunk.chunkX() < this.worldData.minX) {
                    this.worldData.minX = chunk.chunkX();
                }
                if (chunk.chunkX() > this.worldData.maxX) {
                    this.worldData.maxX = chunk.chunkX();
                }
                if (chunk.chunkZ() < this.worldData.minZ) {
                    this.worldData.minZ = chunk.chunkZ();
                }
                if (chunk.chunkZ() <= this.worldData.maxZ) continue;
                this.worldData.maxZ = chunk.chunkZ();
            }
        }
        this.outputFolder.mkdirs();
        for (Map.Entry entry : this.chunkRGBA.entrySet()) {
            RegionCoordPair region = (RegionCoordPair)entry.getKey();
            BufferedImage image = new BufferedImage(512, 512, 2);
            for (Map.Entry chunk : ((ConcurrentMap)entry.getValue()).entrySet()) {
                if (((int[])chunk.getValue()).length == 0) continue;
                image.setRGB((((ChunkCoordPair)chunk.getKey()).chunkX() & 0x1F) << 4, (((ChunkCoordPair)chunk.getKey()).chunkZ() & 0x1F) << 4, 16, 16, (int[])chunk.getValue(), 0, 16);
            }
            File outputFile = new File(this.outputFolder, this.worldData.dimension.name() + "." + region.regionX() + "." + region.regionZ() + ".png");
            try {
                ImageIO.write((RenderedImage)image, "png", outputFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

