/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.settings;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.hivemc.chunker.conversion.encoding.EncodingType;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.encoding.settings.SettingsWorldWriter;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;

public class SettingsLevelWriter
implements LevelWriter {
    private final File outputFolder;
    private final List<SettingsWorldWriter.WorldData> worlds = Collections.synchronizedList(new ArrayList(4));
    private List<ChunkerMap> maps;
    private JsonObject settings;

    public SettingsLevelWriter(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    @Override
    public WorldWriter writeLevel(ChunkerLevel chunkerLevel) throws Exception {
        this.outputFolder.mkdirs();
        Task.asyncConsumeForEach("Saving Map", TaskWeight.LOW, this::writeMap, chunkerLevel.getMaps());
        this.settings = chunkerLevel.getSettings().toDescriptiveJSON();
        this.maps = chunkerLevel.getMaps();
        return new SettingsWorldWriter(this);
    }

    @Override
    public void flushLevel() throws Exception {
        JsonObject dimensions = new JsonObject();
        this.worlds.sort(Comparator.comparing(a -> a.dimension.ordinal()));
        for (SettingsWorldWriter.WorldData worldData : this.worlds) {
            JsonArray regions = new JsonArray(worldData.regions.size());
            for (RegionCoordPair regionCoordPair : worldData.regions) {
                JsonArray coords = new JsonArray(2);
                coords.add(regionCoordPair.regionX());
                coords.add(regionCoordPair.regionZ());
                regions.add(coords);
            }
            dimensions.add(worldData.dimension.name(), regions);
        }
        Object2ObjectOpenHashMap<String, Object> data = new Object2ObjectOpenHashMap<String, Object>();
        data.put("maps", this.maps);
        data.put("dimensions", dimensions);
        data.put("settings", this.settings);
        Files.writeString(new File(this.outputFolder, "data.json").toPath(), (CharSequence)new Gson().toJson(data), new OpenOption[0]);
    }

    @Override
    public EncodingType getEncodingType() {
        return EncodingType.SETTINGS;
    }

    @Override
    public Version getVersion() {
        return new Version(1, 0, 0);
    }

    public void add(SettingsWorldWriter.WorldData worldData) {
        this.worlds.add(worldData);
    }

    protected void writeMap(ChunkerMap map) throws Exception {
        BufferedImage image = new BufferedImage(map.getWidth(), map.getHeight(), 2);
        byte[] bytes = map.getBytes();
        if (bytes == null) {
            return;
        }
        int index = 0;
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                image.setRGB(x, y, (bytes[index + 3] & 0xFF) << 24 | (bytes[index] & 0xFF) << 16 | (bytes[index + 1] & 0xFF) << 8 | bytes[index + 2] & 0xFF);
                index += 4;
            }
        }
        ImageIO.write((RenderedImage)image, "png", new File(this.outputFolder, map.getId() + ".png"));
    }
}

