/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pretransform;

import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import org.jetbrains.annotations.Nullable;

public enum Edge {
    POSITIVE_X(1, 0),
    NEGATIVE_X(-1, 0),
    POSITIVE_Z(0, 1),
    NEGATIVE_Z(0, -1);

    public static final Edge[] ALL_EDGES;
    private final int x;
    private final int z;

    private Edge(int x, int z) {
        this.x = x;
        this.z = z;
    }

    @Nullable
    public static Edge fromOffset(int x, int z) {
        for (Edge edge : ALL_EDGES) {
            if (x != edge.getX() || z != edge.getZ()) continue;
            return edge;
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public ChunkCoordPair getRelative(ChunkCoordPair pair) {
        return new ChunkCoordPair(pair.chunkX() + this.x, pair.chunkZ() + this.z);
    }

    public Edge getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case POSITIVE_X -> NEGATIVE_X;
            case POSITIVE_Z -> NEGATIVE_Z;
            case NEGATIVE_X -> POSITIVE_X;
            case NEGATIVE_Z -> POSITIVE_Z;
        };
    }

    static {
        ALL_EDGES = new Edge[]{POSITIVE_X, NEGATIVE_X, POSITIVE_Z, NEGATIVE_Z};
    }
}

