/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block;

import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirection;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public interface BlockPreTransformHandler {
    public Set<Edge> getRequiredEdges(ChunkerColumn var1, int var2, int var3, int var4, ChunkerBlockIdentifier var5);

    public ChunkerBlockIdentifier handle(ChunkerColumn var1, Map<Edge, ChunkerColumn> var2, int var3, int var4, int var5, ChunkerBlockIdentifier var6);

    default public ChunkerBlockIdentifier getRelative(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, Direction direction) {
        ChunkerColumn target;
        if (direction.getEdge() != null) {
            int newChunkX = x + direction.getEdge().getX() >> 4;
            int newChunkZ = z + direction.getEdge().getZ() >> 4;
            if (newChunkX != column.getPosition().chunkX() || newChunkZ != column.getPosition().chunkZ()) {
                target = neighbours.get((Object)direction.getEdge());
                if (target == null) {
                    return ChunkerBlockIdentifier.AIR;
                }
                if (newChunkX != target.getPosition().chunkX() || newChunkZ != target.getPosition().chunkZ()) {
                    throw new IllegalArgumentException("Relative request is outside of adjacent chunks!");
                }
            } else {
                target = column;
            }
        } else {
            target = column;
        }
        return target.getBlock(x + direction.getX(), y + direction.getY(), z + direction.getZ());
    }

    @Nullable
    default public BlockEntity getRelativeBlockEntity(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, Direction direction) {
        ChunkerColumn target;
        if (direction.getEdge() != null) {
            int newChunkX = x + direction.getEdge().getX() >> 4;
            int newChunkZ = z + direction.getEdge().getZ() >> 4;
            if (newChunkX != column.getPosition().chunkX() || newChunkZ != column.getPosition().chunkZ()) {
                target = neighbours.get((Object)direction.getEdge());
                if (target == null) {
                    return null;
                }
                if (newChunkX != target.getPosition().chunkX() || newChunkZ != target.getPosition().chunkZ()) {
                    throw new IllegalArgumentException("Relative request is outside of adjacent chunks!");
                }
            } else {
                target = column;
            }
        } else {
            target = column;
        }
        return target.getBlockEntity(x + direction.getX(), y + direction.getY(), z + direction.getZ());
    }

    default public Set<Edge> calculateEdges(int x, int y, int z, Direction ... directions) {
        EnumSet<Edge> set = EnumSet.noneOf(Edge.class);
        int originalChunkX = x >> 4;
        int originalChunkZ = z >> 4;
        for (Direction direction : directions) {
            if (direction.getEdge() == null) continue;
            int newChunkX = x + direction.getEdge().getX() >> 4;
            int newChunkZ = z + direction.getEdge().getZ() >> 4;
            if (newChunkX == originalChunkX && newChunkZ == originalChunkZ) continue;
            set.add(direction.getEdge());
        }
        return set;
    }

    public static enum Direction {
        NORTH(Edge.NEGATIVE_Z),
        EAST(Edge.POSITIVE_X),
        SOUTH(Edge.POSITIVE_Z),
        WEST(Edge.NEGATIVE_X),
        UP(1),
        DOWN(-1);

        public static final Direction[] ALL;
        public static final Direction[] ALL_HORIZONTAL;
        public static final Direction[] DIRECTION_EAST_WEST;
        public static final Direction[] DIRECTION_NORTH_SOUTH;
        private final int x;
        private final int y;
        private final int z;
        private final Edge edge;

        private Direction(Edge edge) {
            this.x = edge.getX();
            this.y = 0;
            this.z = edge.getZ();
            this.edge = edge;
        }

        private Direction(int y) {
            this.x = 0;
            this.y = y;
            this.z = 0;
            this.edge = null;
        }

        public static Direction[] getAdjacentFaces(FacingDirectionHorizontal direction) {
            if (direction == FacingDirectionHorizontal.NORTH || direction == FacingDirectionHorizontal.SOUTH) {
                return DIRECTION_EAST_WEST;
            }
            return DIRECTION_NORTH_SOUTH;
        }

        @Nullable
        public Edge getEdge() {
            return this.edge;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public FacingDirectionHorizontal asFacingDirectionHorizontal() {
            return switch (this) {
                case NORTH -> FacingDirectionHorizontal.NORTH;
                case EAST -> FacingDirectionHorizontal.EAST;
                case SOUTH -> FacingDirectionHorizontal.SOUTH;
                case WEST -> FacingDirectionHorizontal.WEST;
                default -> throw new IllegalArgumentException("Unable to get facing direction horizontal");
            };
        }

        public FacingDirection asFacingDirection() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORTH -> FacingDirection.NORTH;
                case EAST -> FacingDirection.EAST;
                case SOUTH -> FacingDirection.SOUTH;
                case WEST -> FacingDirection.WEST;
                case UP -> FacingDirection.UP;
                case DOWN -> FacingDirection.DOWN;
            };
        }

        public Direction getOpposite() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORTH -> SOUTH;
                case EAST -> WEST;
                case SOUTH -> NORTH;
                case WEST -> EAST;
                case UP -> DOWN;
                case DOWN -> UP;
            };
        }

        static {
            ALL = new Direction[]{NORTH, EAST, SOUTH, WEST, UP, DOWN};
            ALL_HORIZONTAL = new Direction[]{NORTH, EAST, SOUTH, WEST};
            DIRECTION_EAST_WEST = new Direction[]{EAST, WEST};
            DIRECTION_NORTH_SOUTH = new Direction[]{NORTH, SOUTH};
        }
    }
}

