/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.writer;

import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.handlers.writer.ColumnWriterConversionHandler;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import org.jetbrains.annotations.Nullable;

public class WorldWriterConversionHandler
implements WorldConversionHandler {
    protected final WorldWriter writer;

    public WorldWriterConversionHandler(WorldWriter writer) {
        this.writer = writer;
    }

    @Override
    public Task<ColumnConversionHandler> convertWorld(ChunkerWorld world) {
        return Task.async("Writing World", TaskWeight.NORMAL, this.writer::writeWorld, world).then("Wrapping Conversion Handler", TaskWeight.NONE, this::wrapColumnWriter);
    }

    @Override
    public void flushWorld(ChunkerWorld world) {
        Task.asyncConsume("Flushing Writer World", TaskWeight.NORMAL, this.writer::flushWorld, world);
    }

    @Override
    public void flushWorlds() {
        Task.async("Flushing Writer Worlds", TaskWeight.NORMAL, this.writer::flushWorlds);
    }

    @Nullable
    protected ColumnConversionHandler wrapColumnWriter(@Nullable ColumnWriter writer) {
        return writer == null ? null : new ColumnWriterConversionHandler(writer);
    }
}

