/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.biome.layout;

import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerBiomes;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ChunkerClusterPaletteBasedBiomes
implements ChunkerBiomes {
    private final List<Palette<ChunkerBiome>> chunks;

    public ChunkerClusterPaletteBasedBiomes(List<Palette<ChunkerBiome>> chunks) {
        this.chunks = chunks;
    }

    @Override
    public ChunkerBiome[] asColumn(ChunkerBiome fallbackBiome) {
        Object[] output = new ChunkerBiome[256];
        if (!this.chunks.isEmpty()) {
            Palette<ChunkerBiome> palette = this.chunks.get(0);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int x = j << 2;
                    int z = i << 2;
                    int newIndex = z << 4 | x;
                    ChunkerBiome biome = palette.get(j, 0, i, fallbackBiome);
                    for (int k = 0; k < 4; ++k) {
                        int offX = newIndex + (k << 4);
                        Arrays.fill(output, offX, offX + 4, biome);
                    }
                }
            }
        } else {
            Arrays.fill(output, fallbackBiome);
        }
        return output;
    }

    @Override
    public ChunkerBiome[] as4X4(ChunkerBiome fallbackBiome) {
        Object[] output = new ChunkerBiome[1024];
        if (!this.chunks.isEmpty()) {
            for (int chunkY = 0; chunkY < 16; ++chunkY) {
                Palette<ChunkerBiome> palette = this.chunks.size() <= chunkY ? this.chunks.get(this.chunks.size() - 1) : this.chunks.get(chunkY);
                for (int localX = 0; localX < 4; ++localX) {
                    for (int localY = 0; localY < 4; ++localY) {
                        for (int localZ = 0; localZ < 4; ++localZ) {
                            output[chunkY << 6 | localY << 4 | localZ << 2 | localX] = palette.get(localX, localY, localZ, fallbackBiome);
                        }
                    }
                }
            }
        } else {
            Arrays.fill(output, fallbackBiome);
        }
        return output;
    }

    @Override
    public List<Palette<ChunkerBiome>> asPalette() {
        ArrayList<Palette<ChunkerBiome>> chunkPalettes = new ArrayList<Palette<ChunkerBiome>>(this.chunks.size());
        for (Palette<ChunkerBiome> oldPalette : this.chunks) {
            if (oldPalette.isEmpty()) {
                chunkPalettes.add(EmptyPalette.instance(16));
                continue;
            }
            if (oldPalette.getKeyCount() == 1) {
                chunkPalettes.add(new SingleValuePalette<ChunkerBiome>(16, oldPalette.getKey(0)));
                continue;
            }
            ShortBasedPalette<ChunkerBiome> palette = new ShortBasedPalette<ChunkerBiome>(oldPalette.getKeyCount(), 16);
            for (int clusterX = 0; clusterX < 4; ++clusterX) {
                for (int clusterY = 0; clusterY < 4; ++clusterY) {
                    for (int clusterZ = 0; clusterZ < 4; ++clusterZ) {
                        int x = clusterX << 2;
                        int y = clusterY << 2;
                        int z = clusterZ << 2;
                        ChunkerBiome biome = oldPalette.get(clusterX, clusterY, clusterZ);
                        short paletteIndex = palette.getOrCreateKey(biome);
                        for (int localX = 0; localX < 4; ++localX) {
                            for (int localY = 0; localY < 4; ++localY) {
                                for (int localZ = 0; localZ < 4; ++localZ) {
                                    palette.setPaletteIndex(x + localX, y + localY, z + localZ, paletteIndex);
                                }
                            }
                        }
                    }
                }
            }
            chunkPalettes.add(palette);
        }
        return chunkPalettes;
    }

    @Override
    public Palette<ChunkerBiome> as4X4Palette(int chunkY) {
        if (this.chunks.isEmpty()) {
            return EmptyPalette.instance(4);
        }
        return chunkY < 0 || chunkY >= this.chunks.size() ? this.chunks.get(this.chunks.size() - 1) : this.chunks.get(chunkY);
    }

    @Override
    public void remap(Function<ChunkerBiome, ChunkerBiome> mapping) {
        this.chunks.replaceAll(chunk -> chunk.map(mapping));
    }
}

