/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.biome.layout;

import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerBiomes;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ChunkerColumnBasedBiomes
implements ChunkerBiomes {
    private final ChunkerBiome[] columns;

    public ChunkerColumnBasedBiomes(ChunkerBiome[] columns) {
        this.columns = columns;
    }

    @Override
    public ChunkerBiome[] asColumn(ChunkerBiome fallbackBiome) {
        return this.columns;
    }

    @Override
    public ChunkerBiome[] as4X4(ChunkerBiome fallbackBiome) {
        int i;
        ChunkerBiome[] output = new ChunkerBiome[1024];
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int x = (j << 2) + 2;
                int z = (i << 2) + 2;
                int oldIndex = z << 4 | x;
                output[i << 2 | j] = this.columns[oldIndex];
            }
        }
        for (i = 1; i < 64; ++i) {
            System.arraycopy(output, 0, output, i << 4, 16);
        }
        return output;
    }

    @Override
    public List<Palette<ChunkerBiome>> asPalette() {
        ShortBasedPalette<ChunkerBiome> palette = new ShortBasedPalette<ChunkerBiome>(4, 16);
        for (int i = 0; i < this.columns.length; ++i) {
            int x = i & 0xF;
            int z = i >> 4 & 0xF;
            ChunkerBiome entry = this.columns[i];
            short paletteIndex = palette.getOrCreateKey(entry);
            for (int y = 0; y < 16; ++y) {
                palette.setPaletteIndex(x, y, z, paletteIndex);
            }
        }
        return new ArrayList<Palette<ChunkerBiome>>(List.of(palette));
    }

    @Override
    public Palette<ChunkerBiome> as4X4Palette(int chunkY) {
        ShortBasedPalette<ChunkerBiome> palette = new ShortBasedPalette<ChunkerBiome>(4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int x = (j << 2) + 2;
                int z = (i << 2) + 2;
                int oldIndex = z << 4 | x;
                ChunkerBiome entry = this.columns[oldIndex];
                short paletteIndex = palette.getOrCreateKey(entry);
                for (int k = 0; k < 4; ++k) {
                    palette.setPaletteIndex(j, k, i, paletteIndex);
                }
            }
        }
        return palette;
    }

    @Override
    public void remap(Function<ChunkerBiome, ChunkerBiome> mapping) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = mapping.apply(this.columns[i]);
        }
    }
}

