/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Map;
import java.util.Optional;

public enum ChunkerDyeColor {
    WHITE("white", 0xF0F0F0, 0xF0F0F0),
    ORANGE("orange", 16351261, 15435844),
    MAGENTA("magenta", 13061821, 12801229),
    LIGHT_BLUE("light_blue", 3847130, 6719955),
    YELLOW("yellow", 16701501, 14602026),
    LIME("lime", 8439583, 4312372),
    PINK("pink", 15961002, 14188952),
    GRAY("gray", 4673362, 0x434343),
    LIGHT_GRAY("light_gray", 0x9D9D97, 0xABABAB),
    CYAN("cyan", 1481884, 2651799),
    PURPLE("purple", 8991416, 8073150),
    BLUE("blue", 3949738, 2437522),
    BROWN("brown", 8606770, 5320730),
    GREEN("green", 6192150, 3887386),
    RED("red", 11546150, 11743532),
    BLACK("black", 0x1D1D21, 0x1E1B1B);

    private static final ChunkerDyeColor[] VALUES;
    private static final Map<String, ChunkerDyeColor> BY_NAME;
    private final String name;
    private final int bedrockRGB;
    private final int javaRGB;

    private ChunkerDyeColor(String name, int bedrockRGB, int javaRGB) {
        this.name = name;
        this.bedrockRGB = bedrockRGB;
        this.javaRGB = javaRGB;
    }

    public static Optional<ChunkerDyeColor> getColorByReversedID(int id) {
        return ChunkerDyeColor.getColorByID(15 - id);
    }

    public static Optional<ChunkerDyeColor> getColorByID(int id) {
        if (id < 0 || id >= VALUES.length) {
            return Optional.empty();
        }
        return Optional.of(VALUES[id]);
    }

    public static Optional<ChunkerDyeColor> getColorByName(String name) {
        return Optional.ofNullable(BY_NAME.get(name));
    }

    public int getID() {
        return this.ordinal();
    }

    public int getReversedID() {
        return 15 - this.ordinal();
    }

    public String getName() {
        return this.name;
    }

    public int getBedrockRGB() {
        return this.bedrockRGB;
    }

    public int getJavaRGB() {
        return this.javaRGB;
    }

    public static ChunkerDyeColor findClosestDyeColor(Color color) {
        double min = Double.MAX_VALUE;
        int minIndex = 0;
        for (int i = 0; i < VALUES.length; ++i) {
            ChunkerDyeColor entry = VALUES[i];
            int rgb = entry.getJavaRGB();
            int entryR = rgb >> 16 & 0xFF;
            int entryG = rgb >> 8 & 0xFF;
            int entryB = rgb & 0xFF;
            double score = (entryR - color.getRed()) * (entryR - color.getRed()) + (entryG - color.getGreen()) * (entryG - color.getGreen()) + (entryB - color.getBlue()) * (entryB - color.getBlue());
            if (score < min) {
                min = score;
                minIndex = i;
            }
            rgb = entry.getBedrockRGB();
            entryR = rgb >> 16 & 0xFF;
            entryG = rgb >> 8 & 0xFF;
            entryB = rgb & 0xFF;
            score = (entryR - color.getRed()) * (entryR - color.getRed()) + (entryG - color.getGreen()) * (entryG - color.getGreen()) + (entryB - color.getBlue()) * (entryB - color.getBlue());
            if (!(score < min)) continue;
            min = score;
            minIndex = i;
        }
        return VALUES[minIndex];
    }

    static {
        VALUES = ChunkerDyeColor.values();
        BY_NAME = new Object2ObjectOpenHashMap<String, ChunkerDyeColor>();
        for (ChunkerDyeColor value : VALUES) {
            BY_NAME.put(value.getName(), value);
        }
    }
}

