/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.world;

import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class Dimension
extends Enum<Dimension> {
    public static final /* enum */ Dimension OVERWORLD;
    public static final /* enum */ Dimension NETHER;
    public static final /* enum */ Dimension THE_END;
    private static final Byte2ObjectMap<Dimension> dimensionByJavaId;
    private static final Byte2ObjectMap<Dimension> dimensionByBedrockId;
    private static final Object2ObjectMap<String, Dimension> dimensionByIdentifier;
    private final byte javaID;
    private final byte bedrockID;
    private final String identifier;
    private static final /* synthetic */ Dimension[] $VALUES;

    public static Dimension[] values() {
        return (Dimension[])$VALUES.clone();
    }

    public static Dimension valueOf(String name) {
        return Enum.valueOf(Dimension.class, name);
    }

    private Dimension(byte javaID, byte bedrockID, String identifier) {
        this.javaID = javaID;
        this.bedrockID = bedrockID;
        this.identifier = identifier;
    }

    public static Dimension fromJavaNBT(@Nullable Tag<?> tag, Dimension fallback) {
        if (tag == null) {
            return fallback;
        }
        try {
            if (tag instanceof StringTag) {
                StringTag stringTag = (StringTag)tag;
                return dimensionByIdentifier.getOrDefault(Objects.requireNonNull(stringTag.getValue()).toLowerCase(Locale.ROOT), fallback);
            }
            if (tag instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)tag;
                byte value = byteTag.getValue();
                return Dimension.fromJava(value, fallback);
            }
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                byte value = (byte)intTag.getValue();
                return Dimension.fromJava(value, fallback);
            }
            return fallback;
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Dimension fromBedrockNBT(@Nullable Tag<?> tag, Dimension fallback) {
        if (tag == null) {
            return fallback;
        }
        try {
            if (tag instanceof StringTag) {
                StringTag stringTag = (StringTag)tag;
                return dimensionByIdentifier.getOrDefault(Objects.requireNonNull(stringTag.getValue()).toLowerCase(Locale.ROOT), fallback);
            }
            if (tag instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)tag;
                byte value = byteTag.getValue();
                return dimensionByBedrockId.getOrDefault(value, fallback);
            }
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                byte value = (byte)intTag.getValue();
                return dimensionByBedrockId.getOrDefault(value, fallback);
            }
            return fallback;
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Dimension fromBedrock(byte id, Dimension fallback) {
        return dimensionByBedrockId.getOrDefault(id, fallback);
    }

    public static Dimension fromJava(byte id, Dimension fallback) {
        return dimensionByJavaId.getOrDefault(id, fallback);
    }

    public byte getJavaID() {
        return this.javaID;
    }

    public byte getBedrockID() {
        return this.bedrockID;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private static /* synthetic */ Dimension[] $values() {
        return new Dimension[]{OVERWORLD, NETHER, THE_END};
    }

    static {
        Dimension[] dimensions;
        OVERWORLD = new Dimension(0, 0, "minecraft:overworld");
        NETHER = new Dimension(-1, 1, "minecraft:nether");
        THE_END = new Dimension(1, 2, "minecraft:the_end");
        $VALUES = Dimension.$values();
        dimensionByJavaId = new Byte2ObjectOpenHashMap<Dimension>();
        dimensionByBedrockId = new Byte2ObjectOpenHashMap<Dimension>();
        dimensionByIdentifier = new Object2ObjectOpenHashMap<String, Dimension>();
        for (Dimension dimension : dimensions = Dimension.values()) {
            dimensionByJavaId.put(dimension.getJavaID(), dimension);
            dimensionByBedrockId.put(dimension.getBedrockID(), dimension);
            dimensionByIdentifier.put(dimension.getIdentifier(), dimension);
        }
    }
}

