/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.mappings.IdentifierMapping;
import com.hivemc.chunker.mapping.mappings.IdentifierMappings;
import com.hivemc.chunker.mapping.mappings.StateMappings;
import com.hivemc.chunker.mapping.mappings.TypeMappings;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class MappingsFile {
    public static final String CUSTOM_BLOCK_HANDLER = "$custom_block";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)MappingsFile.class), new Adapter()).registerTypeHierarchyAdapter(StateValue.class, new StateValue.Adapter()).setPrettyPrinting().create();
    private final Map<String, TypeMappings> typeMappings;
    private final Map<String, StateMappings> stateMappings;
    private final Map<String, IdentifierMappings> blockIdentifierLookup;
    private final Map<String, IdentifierMappings> itemIdentifierLookup;

    private MappingsFile(Map<String, TypeMappings> typeMappings, Map<String, StateMappings> stateMappings, Map<String, IdentifierMappings> blockIdentifierLookup, Map<String, IdentifierMappings> itemIdentifierLookup) {
        this.typeMappings = typeMappings;
        this.stateMappings = stateMappings;
        this.blockIdentifierLookup = blockIdentifierLookup;
        this.itemIdentifierLookup = itemIdentifierLookup;
    }

    public static MappingsFile load(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            MappingsFile mappingsFile = GSON.fromJson((Reader)fileReader, MappingsFile.class);
            return mappingsFile;
        }
    }

    public static MappingsFile load(String json) {
        return GSON.fromJson(json, MappingsFile.class);
    }

    public static MappingsFile load(JsonElement jsonElement) {
        return GSON.fromJson(jsonElement, MappingsFile.class);
    }

    public static boolean isSpecialState(String stateName) {
        return stateName.startsWith("meta:") || stateName.startsWith("virtual:");
    }

    public Map<String, TypeMappings> getTypeMappings() {
        return this.typeMappings;
    }

    public Map<String, StateMappings> getStateMappings() {
        return this.stateMappings;
    }

    public Map<String, IdentifierMappings> getBlockIdentifierLookup() {
        return this.blockIdentifierLookup;
    }

    public Map<String, IdentifierMappings> getItemIdentifierLookup() {
        return this.itemIdentifierLookup;
    }

    public Optional<Identifier> convertBlock(Identifier inputBlock) {
        return this.convert(this.blockIdentifierLookup, inputBlock);
    }

    public Optional<Identifier> convertItem(Identifier inputItem, boolean fallback) {
        Optional<Identifier> itemResult = this.convert(this.itemIdentifierLookup, inputItem);
        if (!fallback || itemResult.isPresent()) {
            return itemResult;
        }
        return this.convertBlock(inputItem);
    }

    public Optional<Identifier> convertItem(Identifier inputItem) {
        return this.convertItem(inputItem, true);
    }

    protected Optional<Identifier> convert(Map<String, IdentifierMappings> identifierLookup, Identifier input) {
        Object2ObjectOpenHashMap outputStates = new Object2ObjectOpenHashMap();
        IdentifierMappings identifierMappings = identifierLookup.get(input.getIdentifier());
        if (identifierMappings == null) {
            if (!input.isVanilla()) {
                identifierMappings = identifierLookup.get(CUSTOM_BLOCK_HANDLER);
                if (identifierMappings == null) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
        }
        IdentifierMapping identifierMapping = null;
        for (Map.Entry<Set<String>, Map<List<StateValue<?>>, IdentifierMapping>> entry : identifierMappings.getLookup().entrySet()) {
            if (!input.getStates().keySet().containsAll((Collection)entry.getKey())) continue;
            ArrayList inputValues = new ArrayList(entry.getKey().size());
            for (String name : entry.getKey()) {
                inputValues.add(input.getStates().get(name));
            }
            identifierMapping = entry.getValue().get(inputValues);
            if (identifierMapping == null) continue;
            break;
        }
        if (identifierMapping == null) {
            return Optional.empty();
        }
        String outputIdentifier = identifierMapping.getNewIdentifier() == null || identifierMapping.getNewIdentifier().equals(CUSTOM_BLOCK_HANDLER) ? input.getIdentifier() : identifierMapping.getNewIdentifier();
        if (identifierMapping.getStateMapping() != null) {
            identifierMapping.getStateMapping().apply(input.getStates(), outputStates);
        } else {
            outputStates.putAll(input.getStates());
        }
        outputStates.putAll(identifierMapping.getNewStateValues());
        for (Map.Entry<String, StateValue<?>> entry : input.getStates().entrySet()) {
            if (!MappingsFile.isSpecialState(entry.getKey()) || outputStates.containsKey(entry.getKey())) continue;
            outputStates.put(entry.getKey(), entry.getValue());
        }
        return Optional.of(new Identifier(outputIdentifier, outputStates));
    }

    public MappingsFile inverse() {
        Object2ObjectOpenHashMap<String, TypeMappings> inverseTypeMappings = new Object2ObjectOpenHashMap<String, TypeMappings>(this.typeMappings.size());
        for (Map.Entry<String, TypeMappings> typeMapping : this.typeMappings.entrySet()) {
            inverseTypeMappings.put(typeMapping.getKey(), typeMapping.getValue().inverse());
        }
        Function<TypeMappings, TypeMappings> inverseTypeMappingLookup = type -> (TypeMappings)inverseTypeMappings.get(type.getName());
        Object2ObjectOpenHashMap<String, StateMappings> inverseStateMappings = new Object2ObjectOpenHashMap<String, StateMappings>(this.stateMappings.size());
        for (Map.Entry<String, StateMappings> stateMapping : this.stateMappings.entrySet()) {
            inverseStateMappings.put(stateMapping.getKey(), stateMapping.getValue().inverse(inverseTypeMappingLookup));
        }
        Function<StateMappings, StateMappings> inverseStateMappingLookup = type -> (StateMappings)inverseStateMappings.get(type.getName());
        return new MappingsFile(inverseTypeMappings, inverseStateMappings, this.inverseIdentifiers(this.blockIdentifierLookup, inverseStateMappingLookup), this.inverseIdentifiers(this.itemIdentifierLookup, inverseStateMappingLookup));
    }

    protected Map<String, IdentifierMappings> inverseIdentifiers(Map<String, IdentifierMappings> identifierLookup, Function<StateMappings, StateMappings> inverseStateMappingLookup) {
        Object2ObjectOpenHashMap<String, IdentifierMappings> inverseIdentifierLookup = new Object2ObjectOpenHashMap<String, IdentifierMappings>(identifierLookup.size());
        for (Map.Entry<String, IdentifierMappings> identifierMappings : identifierLookup.entrySet()) {
            for (Map.Entry<Set<String>, Map<List<StateValue<?>>, IdentifierMapping>> entry : identifierMappings.getValue().getLookup().entrySet()) {
                for (Map.Entry<List<StateValue<?>>, IdentifierMapping> mapping : entry.getValue().entrySet()) {
                    this.inverseIdentifier(inverseIdentifierLookup, mapping.getValue(), inverseStateMappingLookup);
                }
            }
            for (IdentifierMapping identifierMapping : identifierMappings.getValue().getRedundant()) {
                this.inverseIdentifier(inverseIdentifierLookup, identifierMapping, inverseStateMappingLookup);
            }
        }
        return inverseIdentifierLookup;
    }

    protected void inverseIdentifier(Map<String, IdentifierMappings> outputIdentifierLookup, IdentifierMapping oldIdentifierMapping, Function<StateMappings, StateMappings> inverseStateMappingLookup) {
        StateMappings stateMapping = oldIdentifierMapping.getStateMapping() == null || oldIdentifierMapping.getStateMapping().getMappings().isEmpty() ? oldIdentifierMapping.getStateMapping() : inverseStateMappingLookup.apply(oldIdentifierMapping.getStateMapping());
        IdentifierMapping identifierMapping = new IdentifierMapping(oldIdentifierMapping.getIndex(), oldIdentifierMapping.getNewIdentifier(), oldIdentifierMapping.getOldIdentifier(), oldIdentifierMapping.getNewStateValues(), oldIdentifierMapping.getOldStateValues(), stateMapping);
        IdentifierMappings identifierMappings = outputIdentifierLookup.computeIfAbsent(identifierMapping.getOldIdentifier(), ignored -> new IdentifierMappings(identifierMapping.getOldIdentifier()));
        identifierMappings.addMapping(identifierMapping);
    }

    public JsonElement toJson() {
        return GSON.toJsonTree(this);
    }

    public String toJsonString() {
        return GSON.toJson(this);
    }

    public String toString() {
        return "BlockStateMappings{typeMappings=" + String.valueOf(this.typeMappings) + ", stateMappings=" + String.valueOf(this.stateMappings) + ", blockIdentifierLookup=" + String.valueOf(this.blockIdentifierLookup) + ", itemIdentifierLookup=" + String.valueOf(this.itemIdentifierLookup) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingsFile that = (MappingsFile)o;
        return Objects.equals(this.typeMappings, that.typeMappings) && Objects.equals(this.stateMappings, that.stateMappings) && Objects.equals(this.blockIdentifierLookup, that.blockIdentifierLookup) && Objects.equals(this.itemIdentifierLookup, that.itemIdentifierLookup);
    }

    public int hashCode() {
        return Objects.hash(this.typeMappings, this.stateMappings, this.blockIdentifierLookup, this.itemIdentifierLookup);
    }

    static class Adapter
    implements JsonSerializer<MappingsFile>,
    JsonDeserializer<MappingsFile> {
        Adapter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MappingsFile deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            void var8_13;
            Map<String, StateMappings> stateMappingsLookup;
            Map<String, TypeMappings> types;
            JsonObject object = jsonElement.getAsJsonObject();
            if (object.has("types")) {
                JsonObject typesObject = object.get("types").getAsJsonObject();
                types = new Object2ObjectOpenHashMap(typesObject.size());
                for (Map.Entry<String, JsonElement> entry : typesObject.entrySet()) {
                    TypeMappings typeMappings = TypeMappings.deserialize(entry.getKey(), entry.getValue(), context);
                    types.put(entry.getKey(), typeMappings);
                }
            } else {
                types = Collections.emptyMap();
            }
            if (object.has("state_lists")) {
                JsonObject stateLists = object.get("state_lists").getAsJsonObject();
                stateMappingsLookup = new Object2ObjectOpenHashMap(stateLists.size());
                for (Map.Entry<String, JsonElement> entry : stateLists.entrySet()) {
                    StateMappings stateMappings = StateMappings.deserialize(entry.getKey(), types, entry.getValue(), context);
                    stateMappingsLookup.put(entry.getKey(), stateMappings);
                }
            } else {
                stateMappingsLookup = Collections.emptyMap();
            }
            Map<String, IdentifierMappings> blockIdentifierMappings = object.has("identifiers") ? this.deserializeIdentifiers(stateMappingsLookup, object.get("identifiers"), context) : Collections.emptyMap();
            if (object.has("items")) {
                Map<String, IdentifierMappings> map = this.deserializeIdentifiers(stateMappingsLookup, object.get("items"), context);
            } else {
                Map map = Collections.emptyMap();
            }
            return new MappingsFile(types, stateMappingsLookup, blockIdentifierMappings, (Map<String, IdentifierMappings>)var8_13);
        }

        protected Map<String, IdentifierMappings> deserializeIdentifiers(Map<String, StateMappings> stateMappings, JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
            Object2ObjectOpenHashMap<String, IdentifierMappings> identifierLookup = new Object2ObjectOpenHashMap<String, IdentifierMappings>();
            int index = 0;
            for (JsonElement entry : jsonElement.getAsJsonArray()) {
                IdentifierMapping identifierMapping = IdentifierMapping.deserialize(stateMappings, index++, entry, context);
                IdentifierMappings identifierMappings = identifierLookup.computeIfAbsent(identifierMapping.getOldIdentifier(), ignored -> new IdentifierMappings(identifierMapping.getOldIdentifier()));
                identifierMappings.addMapping(identifierMapping);
            }
            return identifierLookup;
        }

        @Override
        public JsonElement serialize(MappingsFile mappingsFile, Type type, JsonSerializationContext context) {
            JsonObject stateLists;
            JsonObject object = new JsonObject();
            if (!mappingsFile.getBlockIdentifierLookup().isEmpty()) {
                object.add("identifiers", this.serializeIdentifiers(mappingsFile.getBlockIdentifierLookup(), context));
            }
            if (!mappingsFile.getItemIdentifierLookup().isEmpty()) {
                object.add("items", this.serializeIdentifiers(mappingsFile.getItemIdentifierLookup(), context));
            }
            if (!mappingsFile.getStateMappings().isEmpty()) {
                stateLists = new JsonObject();
                for (Map.Entry<String, StateMappings> entry : mappingsFile.getStateMappings().entrySet()) {
                    stateLists.add(entry.getKey(), entry.getValue().serialize(context));
                }
                object.add("state_lists", stateLists);
            }
            if (!mappingsFile.getTypeMappings().isEmpty()) {
                stateLists = new JsonObject();
                for (Map.Entry<String, Object> entry : mappingsFile.getTypeMappings().entrySet()) {
                    stateLists.add(entry.getKey(), ((TypeMappings)entry.getValue()).serialize(context));
                }
                object.add("types", stateLists);
            }
            return object;
        }

        protected JsonElement serializeIdentifiers(Map<String, IdentifierMappings> identifierLookup, JsonSerializationContext context) {
            ArrayList<IdentifierMapping> fullIdentifierMappings = new ArrayList<IdentifierMapping>();
            for (IdentifierMappings identifierMappings : identifierLookup.values()) {
                for (Map<List<StateValue<?>>, IdentifierMapping> lookup : identifierMappings.getLookup().values()) {
                    fullIdentifierMappings.addAll(lookup.values());
                }
                fullIdentifierMappings.addAll(identifierMappings.getRedundant());
            }
            fullIdentifierMappings.sort(Comparator.comparing(IdentifierMapping::getIndex));
            JsonArray jsonArray = new JsonArray(fullIdentifierMappings.size());
            for (IdentifierMapping identifierMapping : fullIdentifierMappings) {
                jsonArray.add(identifierMapping.serialize(context));
            }
            return jsonArray;
        }
    }
}

