/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.identifier;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.identifier.states.StateValueInt;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;

public class Identifier {
    private final String identifier;
    private final Map<String, StateValue<?>> states;

    public Identifier(String identifier, Map<String, StateValue<?>> states) {
        this.identifier = identifier;
        this.states = states;
    }

    public Identifier(String identifier) {
        this(identifier, Collections.emptyMap());
    }

    public static Identifier fromBoxed(String identifier, Map<String, Object> boxedMap) {
        Object2ObjectOpenHashMap newMap = new Object2ObjectOpenHashMap(boxedMap.size());
        for (Map.Entry<String, Object> entry : boxedMap.entrySet()) {
            newMap.put(entry.getKey(), StateValue.fromBoxed(entry.getValue()));
        }
        return new Identifier(identifier, newMap);
    }

    public static Identifier fromData(String identifier, OptionalInt optionalData) {
        if (optionalData.isEmpty()) {
            return new Identifier(identifier);
        }
        return new Identifier(identifier, Map.of("data", new StateValueInt(optionalData.getAsInt())));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Map<String, StateValue<?>> getStates() {
        return this.states;
    }

    public Map<String, Object> getBoxedStates() {
        return Maps.transformValues(this.states, StateValue::getBoxed);
    }

    public OptionalInt getDataValue() {
        StateValue<?> data = this.states.get("data");
        if (!(data instanceof StateValueInt)) {
            return OptionalInt.empty();
        }
        StateValueInt stateValueInt = (StateValueInt)data;
        return OptionalInt.of(stateValueInt.getValue());
    }

    public boolean isVanilla() {
        return !this.identifier.contains(":") || this.identifier.startsWith("minecraft:");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.states, that.states);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.states);
    }

    public String toString() {
        return this.identifier + (this.states.isEmpty() ? "" : this.toStateString());
    }

    public String toStateString() {
        return this.states.isEmpty() ? "[]" : "[" + Joiner.on(",").withKeyValueSeparator("=").join(this.states) + "]";
    }
}

