/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.mappings;

import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.mappings.IdentifierMapping;
import com.hivemc.chunker.util.CollectionComparator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class IdentifierMappings {
    public static final Comparator<Set<String>> SET_COMPARATOR = new CollectionComparator().reversed();
    private final String identifier;
    private final SortedMap<Set<String>, Map<List<StateValue<?>>, IdentifierMapping>> lookup;
    private final List<IdentifierMapping> redundant;

    public IdentifierMappings(String identifier, SortedMap<Set<String>, Map<List<StateValue<?>>, IdentifierMapping>> lookup, List<IdentifierMapping> redundant) {
        this.identifier = identifier;
        this.lookup = lookup;
        this.redundant = redundant;
    }

    public IdentifierMappings(String identifier) {
        this(identifier, new TreeMap(SET_COMPARATOR), new ArrayList<IdentifierMapping>(0));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Map<Set<String>, Map<List<StateValue<?>>, IdentifierMapping>> getLookup() {
        return this.lookup;
    }

    public List<IdentifierMapping> getRedundant() {
        return this.redundant;
    }

    public void addMapping(IdentifierMapping identifierMapping) {
        Set<String> sortedKeys = identifierMapping.getOldStateValues().keySet();
        ArrayList sortedValues = new ArrayList(identifierMapping.getOldStateValues().values());
        Map stateValuesLookup = this.getLookup().computeIfAbsent(sortedKeys, ignored -> new Object2ObjectOpenHashMap(1));
        IdentifierMapping existing = stateValuesLookup.putIfAbsent(sortedValues, identifierMapping);
        if (existing != null) {
            if (existing.getIndex() <= identifierMapping.getIndex()) {
                this.getRedundant().add(identifierMapping);
            } else {
                stateValuesLookup.replace(sortedValues, existing, identifierMapping);
                this.getRedundant().add(existing);
            }
        }
    }

    public String toString() {
        return "IdentifierMappings{lookup=" + String.valueOf(this.lookup) + ", redundant=" + String.valueOf(this.redundant) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierMappings that = (IdentifierMappings)o;
        return Objects.equals(this.lookup, that.lookup) && Objects.equals(this.redundant, that.redundant);
    }

    public int hashCode() {
        return Objects.hash(this.lookup, this.redundant);
    }
}

