/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.mappings;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.identifier.states.StateValueString;
import com.hivemc.chunker.mapping.mappings.TypeMapping;
import com.hivemc.chunker.mapping.mappings.TypeMappings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class StateMapping {
    private static final Type TYPE_STRING_LIST = new TypeToken<List<String>>(){}.getType();
    private final List<String> oldNames;
    private final List<String> newNames;
    private final TypeMappings typeMappings;

    public StateMapping(List<String> oldNames, List<String> newNames, TypeMappings typeMappings) {
        this.oldNames = oldNames;
        this.newNames = newNames;
        this.typeMappings = typeMappings;
    }

    private static JsonElement serializeStringList(List<String> input, JsonSerializationContext context) throws JsonParseException {
        if (input.size() == 1) {
            return new JsonPrimitive(input.iterator().next());
        }
        return context.serialize(input, TYPE_STRING_LIST);
    }

    public static StateMapping deserialize(Map<String, TypeMappings> types, JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
        TypeMappings typeMappings;
        String typeMappingName;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        List<String> oldNames = StateMapping.deserializeStringList(jsonObject.get("old_state"), context);
        List<String> newNames = StateMapping.deserializeStringList(jsonObject.get("new_state"), context);
        String string = typeMappingName = jsonObject.has("type") ? jsonObject.get("type").getAsString() : null;
        if (typeMappingName == null || typeMappingName.isEmpty()) {
            typeMappings = null;
        } else {
            typeMappings = types.get(typeMappingName);
            if (typeMappings == null) {
                throw new JsonParseException("Could not find type " + typeMappingName);
            }
        }
        return new StateMapping(oldNames, newNames, typeMappings);
    }

    private static List<String> deserializeStringList(JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
        if (jsonElement.isJsonArray()) {
            return (List)context.deserialize(jsonElement, TYPE_STRING_LIST);
        }
        return List.of(jsonElement.getAsString());
    }

    public List<String> getOldNames() {
        return this.oldNames;
    }

    public List<String> getNewNames() {
        return this.newNames;
    }

    public TypeMappings getTypeMapping() {
        return this.typeMappings;
    }

    public StateMapping inverse(Function<TypeMappings, TypeMappings> inverseTypeMappingLookup) {
        return new StateMapping(this.newNames, this.oldNames, this.typeMappings == null ? null : inverseTypeMappingLookup.apply(this.typeMappings));
    }

    public String toString() {
        return "StateMapping{oldNames=" + String.valueOf(this.oldNames) + ", newNames=" + String.valueOf(this.newNames) + ", typeMapping=" + String.valueOf(this.typeMappings) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMapping that = (StateMapping)o;
        return Objects.equals(this.oldNames, that.oldNames) && Objects.equals(this.newNames, that.newNames) && Objects.equals(this.typeMappings, that.typeMappings);
    }

    public int hashCode() {
        return Objects.hash(this.oldNames, this.newNames, this.typeMappings);
    }

    public void apply(Map<String, StateValue<?>> inputStates, Map<String, StateValue<?>> outputStates) {
        List<Object> outputValues;
        ArrayList<StateValueString> oldValues = new ArrayList<StateValueString>(this.oldNames.size());
        for (String name : this.oldNames) {
            StateValue<String> value;
            StateValue<String> stateValue = value = name.isEmpty() ? new StateValueString("") : inputStates.get(name);
            if (value == null) {
                return;
            }
            oldValues.add((StateValueString)value);
        }
        if (this.typeMappings != null) {
            TypeMapping typeMapping = this.typeMappings.getInputsToOutputsLookup().get(oldValues);
            if (typeMapping == null) {
                return;
            }
            outputValues = typeMapping.getOutput();
        } else {
            outputValues = oldValues;
        }
        for (int i = 0; i < this.newNames.size(); ++i) {
            String name = this.newNames.get(i);
            if (name.isEmpty()) continue;
            outputStates.putIfAbsent(name, (StateValue)outputValues.get(i));
        }
    }

    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("old_state", StateMapping.serializeStringList(this.getOldNames(), context));
        jsonObject.add("new_state", StateMapping.serializeStringList(this.getNewNames(), context));
        if (this.typeMappings != null) {
            jsonObject.addProperty("type", this.typeMappings.getName());
        }
        return jsonObject;
    }
}

