/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.mappings;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import java.util.List;
import java.util.Objects;

public class TypeMapping {
    private final int index;
    private final List<StateValue<?>> input;
    private final List<StateValue<?>> output;

    public TypeMapping(int index, List<StateValue<?>> input, List<StateValue<?>> output) {
        this.index = index;
        this.input = input;
        this.output = output;
    }

    public static TypeMapping deserialize(int index, JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        List<StateValue<?>> input = StateValue.Adapter.deserializeStateValues(object.get("input"), context);
        List<StateValue<?>> output = StateValue.Adapter.deserializeStateValues(object.get("output"), context);
        return new TypeMapping(index, input, output);
    }

    public int getIndex() {
        return this.index;
    }

    public List<StateValue<?>> getInput() {
        return this.input;
    }

    public List<StateValue<?>> getOutput() {
        return this.output;
    }

    public TypeMapping inverse() {
        return new TypeMapping(this.index, this.output, this.input);
    }

    public String toString() {
        return "TypeMapping{index=" + this.index + ", input=" + String.valueOf(this.input) + ", output=" + String.valueOf(this.output) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMapping that = (TypeMapping)o;
        return this.index == that.index && Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.input, this.output);
    }

    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("input", StateValue.Adapter.serializeStateValues(this.getInput(), context));
        jsonObject.add("output", StateValue.Adapter.serializeStateValues(this.getOutput(), context));
        return jsonObject;
    }
}

