/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.io;

import com.hivemc.chunker.nbt.io.Writer;
import java.io.DataOutput;
import java.io.IOException;

class DataOutputWriterLE
implements Writer {
    private final DataOutput dataOutput;

    protected DataOutputWriterLE(DataOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.dataOutput.writeByte(value);
        this.dataOutput.writeByte(value >> 8);
    }

    @Override
    public void writeBytes(byte[] value) throws IOException {
        this.dataOutput.write(value);
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.dataOutput.write(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.dataOutput.writeByte(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.dataOutput.writeByte(value);
        this.dataOutput.writeByte(value >> 8);
        this.dataOutput.writeByte(value >> 16);
        this.dataOutput.writeByte(value >> 24);
    }

    @Override
    public void writeUnsignedInt24(int value) throws IOException {
        this.dataOutput.writeByte(value);
        this.dataOutput.writeByte(value >> 8);
        this.dataOutput.writeByte(value >> 16);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.dataOutput.writeByte((int)value);
        this.dataOutput.writeByte((int)(value >> 8));
        this.dataOutput.writeByte((int)(value >> 16));
        this.dataOutput.writeByte((int)(value >> 24));
        this.dataOutput.writeByte((int)(value >> 32));
        this.dataOutput.writeByte((int)(value >> 40));
        this.dataOutput.writeByte((int)(value >> 48));
        this.dataOutput.writeByte((int)(value >> 56));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }
}

