/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.io;

import com.hivemc.chunker.nbt.io.DataOutputWriterBE;
import com.hivemc.chunker.nbt.io.DataOutputWriterLE;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public interface Writer {
    public static Writer toBigEndianWriter(DataOutput dataOutput) {
        return new DataOutputWriterBE(dataOutput);
    }

    public static Writer toJavaWriter(DataOutput dataOutput) {
        return Writer.toBigEndianWriter(dataOutput);
    }

    public static Writer toLittleEndianWriter(DataOutput dataOutput) {
        return new DataOutputWriterLE(dataOutput);
    }

    public static Writer toBedrockWriter(DataOutput dataOutput) {
        return Writer.toLittleEndianWriter(dataOutput);
    }

    default public void writeShortPrefixedBytes(byte[] value) throws IOException {
        this.writeShort((short)value.length);
        this.writeBytes(value);
    }

    default public void writeString(@NotNull String value) throws IOException {
        this.writeShortPrefixedBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    public void writeShort(short var1) throws IOException;

    public void writeBytes(byte[] var1) throws IOException;

    public void writeByte(byte var1) throws IOException;

    public void writeByte(int var1) throws IOException;

    public void writeInt(int var1) throws IOException;

    public void writeUnsignedInt24(int var1) throws IOException;

    public void writeLong(long var1) throws IOException;

    public void writeFloat(float var1) throws IOException;

    public void writeDouble(double var1) throws IOException;
}

