/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FloatTag
extends Tag<Float> {
    protected float value;

    public FloatTag(float value) {
        this.value = value;
    }

    public FloatTag() {
    }

    @Override
    @NotNull
    public TagType<FloatTag, Float> getType() {
        return TagType.FLOAT;
    }

    @Override
    public boolean valueEquals(Tag<Float> tag) {
        return Objects.equals(Float.valueOf(this.value), Float.valueOf(((FloatTag)tag).getValue()));
    }

    @Override
    public Float getBoxedValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public FloatTag clone() {
        return new FloatTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeFloat(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.value = reader.readFloat();
    }

    @Override
    public String toSNBT() {
        return this.value + "f";
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }
}

