/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class IntTag
extends Tag<Integer> {
    protected int value;

    public IntTag(int value) {
        this.value = value;
    }

    public IntTag() {
    }

    @Override
    @NotNull
    public TagType<IntTag, Integer> getType() {
        return TagType.INT;
    }

    @Override
    public boolean valueEquals(Tag<Integer> tag) {
        return Objects.equals(this.value, ((IntTag)tag).getValue());
    }

    @Override
    public Integer getBoxedValue() {
        return this.value;
    }

    @Override
    public IntTag clone() {
        return new IntTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeInt(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.value = reader.readInt();
    }

    @Override
    public String toSNBT() {
        return String.valueOf(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

