/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ShortTag
extends Tag<Short> {
    protected short value;

    public ShortTag(short value) {
        this.value = value;
    }

    public ShortTag() {
    }

    @Override
    @NotNull
    public TagType<ShortTag, Short> getType() {
        return TagType.SHORT;
    }

    @Override
    public boolean valueEquals(Tag<Short> tag) {
        return Objects.equals(this.value, ((ShortTag)tag).getValue());
    }

    @Override
    public Short getBoxedValue() {
        return this.value;
    }

    @Override
    public ShortTag clone() {
        return new ShortTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeShort(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.value = reader.readShort();
    }

    @Override
    public String toSNBT() {
        return this.value + "s";
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }
}

