/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.resolver.property;

import com.hivemc.chunker.resolver.property.PropertyHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public abstract class Property<H extends PropertyHolder<?>, V> {
    private static final Map<Class<? extends Property<?, ?>>, Map<String, Property<?, ?>>> ALL_PROPERTIES = new Object2ObjectOpenHashMap();
    private final String name;
    private final Type type;

    protected Property(String name, Type type) {
        this.name = name;
        this.type = type;
        Class<?> propertyType = this.getClass();
        Map list = ALL_PROPERTIES.computeIfAbsent(propertyType, ignored -> new Object2ObjectOpenHashMap());
        if (list.putIfAbsent(name, this) != null) {
            throw new IllegalArgumentException("Duplicate property named " + name);
        }
    }

    public static <P extends Property<?, ?>> Map<String, P> getProperties(Class<P> propertyClass) {
        return ALL_PROPERTIES.computeIfAbsent(propertyClass, ignored -> new Object2ObjectOpenHashMap());
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "'}";
    }
}

