/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling.task;

import com.hivemc.chunker.scheduling.LoggedException;
import com.hivemc.chunker.scheduling.function.Invokable;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.scheduling.task.TrackedTask;
import com.hivemc.chunker.scheduling.task.executor.TaskExecutor;
import com.hivemc.chunker.util.SneakyThrows;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.function.Supplier;

public class WrappedTask<I, O>
extends TrackedTask<O>
implements Function<I, O>,
Supplier<O> {
    protected Invokable<I, O> lambda;
    private CompletableFuture<O> future;

    public WrappedTask(String name, TaskWeight weight, Invokable<I, O> lambda) {
        super(name, weight);
        this.lambda = lambda;
    }

    protected void setupFuture(CompletableFuture<O> future) {
        this.future = ((CompletableFuture)future.thenCompose(this::waitForChildren)).handle((input, throwable) -> {
            this.free();
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (!(throwable instanceof LoggedException)) {
                    TaskExecutor.currentExecutor().handleException((Throwable)throwable);
                    throwable = new LoggedException((Throwable)throwable);
                }
                SneakyThrows.throwException(throwable);
            }
            return input;
        });
    }

    @Override
    public CompletableFuture<O> future() {
        return this.future;
    }

    @Override
    public O get() {
        return this.apply((I)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public O apply(I input) {
        this.start();
        try {
            O o = this.onSelfComplete(this.lambda.invoke(input));
            return o;
        }
        catch (Throwable t) {
            this.onSelfFail(t);
            O o = null;
            return o;
        }
        finally {
            this.lambda = null;
        }
    }

    @Override
    protected void free() {
        super.free();
        this.lambda = null;
    }

    public int getPriority() {
        return this.getDepth();
    }

    static class WrappedTaskConstant<T, O>
    extends WrappedTask<Object, O> {
        private T constant;

        public WrappedTaskConstant(String name, TaskWeight weight, T constant, Invokable<T, O> function) {
            super(name, weight, function);
            this.constant = constant;
        }

        @Override
        public O apply(Object ignored) {
            try {
                Object o = super.apply(this.constant);
                return o;
            }
            finally {
                this.constant = null;
            }
        }

        @Override
        protected void free() {
            super.free();
            this.constant = null;
        }
    }
}

