/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling.task.executor;

import com.hivemc.chunker.scheduling.task.executor.PriorityRunnable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

class TaskExecutorSupplier<T>
implements PriorityRunnable {
    private final int priority;
    private Supplier<? extends T> supplier;
    private CompletableFuture<T> future;

    TaskExecutorSupplier(int priority, Supplier<? extends T> supplier, CompletableFuture<T> future) {
        this.priority = priority;
        this.supplier = supplier;
        this.future = future;
    }

    @Override
    public void run() {
        Supplier<T> localSupplier = this.supplier;
        CompletableFuture<T> localFuture = this.future;
        if (localSupplier != null && localFuture != null) {
            this.supplier = null;
            this.future = null;
            if (!localFuture.isDone()) {
                try {
                    localFuture.complete(localSupplier.get());
                }
                catch (Throwable t) {
                    localFuture.completeExceptionally(t);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

