/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.iq80.leveldb.fileenv.FileUtils;

public class JavaFile
implements org.iq80.leveldb.env.File {
    private final File file;

    private JavaFile(File file) {
        this.file = file;
    }

    public static JavaFile fromFile(File path) {
        return new JavaFile(path);
    }

    static File toFile(org.iq80.leveldb.env.File file) {
        return ((JavaFile)file).file;
    }

    @Override
    public org.iq80.leveldb.env.File child(String name) {
        return new JavaFile(new File(this.file, name));
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public org.iq80.leveldb.env.File getParentFile() {
        return new JavaFile(this.file.getParentFile());
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public List<org.iq80.leveldb.env.File> listFiles() {
        File[] values = this.file.listFiles();
        return values == null ? Collections.emptyList() : Stream.of(values).map(JavaFile::new).collect(Collectors.toList());
    }

    @Override
    public boolean renameTo(org.iq80.leveldb.env.File dest) {
        return this.file.renameTo(((JavaFile)dest).file);
    }

    @Override
    public boolean deleteRecursively() {
        return FileUtils.deleteRecursively(this.file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaFile javaFile = (JavaFile)o;
        return Objects.equals(this.file, javaFile.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public String toString() {
        return String.valueOf(this.file);
    }
}

