/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.env.RandomInputFile;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.iterator.InternalTableIterator;
import org.iq80.leveldb.table.BlockHandleSliceWeigher;
import org.iq80.leveldb.table.CacheKey;
import org.iq80.leveldb.table.FilterPolicy;
import org.iq80.leveldb.table.KeyValueFunction;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.ILRUCache;
import org.iq80.leveldb.util.LRUCache;
import org.iq80.leveldb.util.Slice;

public class TableCache {
    private final LoadingCache<Long, TableAndFile> cache;
    private final ILRUCache<CacheKey, Slice> blockCache;

    public TableCache(final File databaseDir, int tableCacheSize, final UserComparator userComparator, final Options options, final Env env) {
        Objects.requireNonNull(databaseDir, "databaseName is null");
        this.blockCache = options.cacheSize() == 0L ? null : LRUCache.createCache((int)options.cacheSize(), new BlockHandleSliceWeigher());
        this.cache = CacheBuilder.newBuilder().maximumSize(tableCacheSize).removalListener(notification -> {
            TableAndFile value = (TableAndFile)notification.getValue();
            if (value != null) {
                Table table = value.getTable();
                try {
                    table.close();
                }
                catch (IOException e) {
                    throw new DBException(e);
                }
            }
        }).build(new CacheLoader<Long, TableAndFile>(){

            @Override
            public TableAndFile load(Long fileNumber) throws IOException {
                return new TableAndFile(databaseDir, fileNumber, userComparator, options, TableCache.this.blockCache, env);
            }
        });
    }

    public InternalTableIterator newIterator(FileMetaData file, ReadOptions options) throws IOException {
        return this.newIterator(file.getNumber(), options);
    }

    public InternalTableIterator newIterator(long number, ReadOptions options) throws IOException {
        try (Table table = this.getTable(number);){
            InternalTableIterator internalTableIterator = new InternalTableIterator(table.iterator(options));
            return internalTableIterator;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(ReadOptions options, Slice key, FileMetaData fileMetaData, KeyValueFunction<T> resultBuilder) {
        try (Table table = this.getTable(fileMetaData.getNumber());){
            T t = table.internalGet(options, key, resultBuilder);
            return t;
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    public long getApproximateOffsetOf(FileMetaData file, Slice key) {
        long l;
        block8: {
            Table table = this.getTable(file.getNumber());
            try {
                l = table.getApproximateOffsetOf(key);
                if (table == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DBException(e);
                }
            }
            table.close();
        }
        return l;
    }

    private Table getTable(long number) {
        Table table;
        try {
            while (!(table = this.cache.get(number).getTable()).retain()) {
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new DBException("Could not open table " + number, cause);
        }
        return table;
    }

    public void close() {
        this.invalidateAll();
    }

    public void invalidateAll() {
        if (this.blockCache != null) {
            this.blockCache.invalidateAll();
        }
        this.cache.invalidateAll();
    }

    public void evict(long number) {
        this.cache.invalidate(number);
    }

    public long getApproximateMemoryUsage() {
        return this.blockCache.getApproximateMemoryUsage();
    }

    private static final class TableAndFile {
        private final Table table;

        private TableAndFile(File databaseDir, long fileNumber, UserComparator userComparator, Options options, ILRUCache<CacheKey, Slice> blockCache, Env env) throws IOException {
            File tableFile = this.tableFileName(databaseDir, fileNumber);
            RandomInputFile source = env.newRandomAccessFile(tableFile);
            this.table = Closeables.wrapResource(() -> {
                FilterPolicy filterPolicy = (FilterPolicy)options.filterPolicy();
                return new Table(source, userComparator, options.paranoidChecks(), blockCache, filterPolicy);
            }, source);
        }

        private File tableFileName(File databaseDir, long fileNumber) {
            String sstFileName;
            File sstPath;
            String tableFileName = Filename.tableFileName(fileNumber);
            File tableFile = databaseDir.child(tableFileName);
            if (!tableFile.canRead() && (sstPath = databaseDir.child(sstFileName = Filename.sstTableFileName(fileNumber))).canRead()) {
                tableFile = sstPath;
            }
            return tableFile;
        }

        public Table getTable() {
            return this.table;
        }
    }
}

