/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.memenv;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.iq80.leveldb.util.Slice;

class FileState {
    private static final int BLOCK_SIZE = 8192;
    private final Object lock = new Object();
    private boolean locked = false;
    private int size = 0;
    private byte[][] content;

    FileState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileState truncate() {
        Object object = this.lock;
        synchronized (object) {
            this.content = null;
            this.size = 0;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(long offset, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (offset > (long)this.size) {
                throw new IOException("Offset greater than file size.");
            }
            long available = (long)this.size - offset;
            if (n != 0 && available == 0L) {
                return null;
            }
            if ((long)n > available) {
                n = (int)available;
            }
            if (n == 0) {
                return new byte[0];
            }
            Preconditions.checkArgument(offset / 8192L <= Integer.MAX_VALUE, "Invalid offset");
            int block = (int)(offset / 8192L);
            int blockOffset = (int)(offset % 8192L);
            int bytesToCopy = n;
            int dst = 0;
            byte[] output = new byte[n];
            while (bytesToCopy > 0) {
                int avail = 8192 - blockOffset;
                if (avail > bytesToCopy) {
                    avail = bytesToCopy;
                }
                System.arraycopy(this.content[block], blockOffset, output, dst, avail);
                bytesToCopy -= avail;
                dst += avail;
                ++block;
                blockOffset = 0;
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Slice data) {
        int srcLen = data.length();
        byte[] src = data.getRawArray();
        int srcPos = data.getRawOffset();
        Object object = this.lock;
        synchronized (object) {
            while (srcLen > 0) {
                int avail;
                int offset = this.size % 8192;
                if (offset != 0) {
                    avail = 8192 - offset;
                } else {
                    this.addBlock(new byte[8192]);
                    avail = 8192;
                }
                if (avail > srcLen) {
                    avail = srcLen;
                }
                System.arraycopy(src, srcPos, this.content[this.content.length - 1], offset, avail);
                srcLen -= avail;
                srcPos += avail;
                this.size += avail;
            }
        }
    }

    private void addBlock(byte[] bytes) {
        this.content = this.content == null ? (Object)new byte[1][] : (byte[][])Arrays.copyOf(this.content, this.content.length + 1);
        this.content[this.content.length - 1] = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        Object object = this.lock;
        synchronized (object) {
            return this.locked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocked(boolean locked) {
        Object object = this.lock;
        synchronized (object) {
            this.locked = locked;
        }
    }
}

