/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

public final class Hash {
    private Hash() {
    }

    public static int hash(byte[] data, int seed) {
        return Hash.hash(data, 0, data.length, seed);
    }

    public static int hash(byte[] data, int offset, int len, int seed) {
        int endIdx = len + offset;
        int m = -962287725;
        int r = 24;
        int h = seed ^ len * m;
        int idx = offset;
        while (idx + 4 <= endIdx) {
            int w = Hash.byteToInt(data, idx);
            h += w;
            h *= m;
            h ^= h >>> 16;
            idx += 4;
        }
        int remaining = endIdx - idx;
        switch (remaining) {
            case 3: {
                h += (data[idx + 2] & 0xFF) << 16;
            }
            case 2: {
                h += (data[idx + 1] & 0xFF) << 8;
            }
            case 1: {
                h += data[idx] & 0xFF;
                h *= m;
                h ^= h >>> r;
            }
        }
        return h;
    }

    private static int byteToInt(byte[] data, int index) {
        return data[index] & 0xFF | (data[index + 1] & 0xFF) << 8 | (data[index + 2] & 0xFF) << 16 | (data[index + 3] & 0xFF) << 24;
    }
}

