## 1.16 图上的基本操作——图模式匹配

图模型将数据组织成一个个图，使得人和计算机能够表达信息，同样，我们还需要一种统一的计算方式来描述数据的存取功能。图模型上最常用的计算方式称为**图模式匹配**，我们使用图模式来定义要搜索的数据和要返回的数据。模式（pattern）和图模式匹配（Graph pattern matching），是图查询语言的核心功能。

请注意，图模式（Graph Schema）和图模式（Graph Pattern）在图数据库和图理论中是两个相关但不同的概念：
- 图模式（Graph Schema）：图模式（有时也称为图架构）描述了图数据的结构或模式。它定义了图中的节点和边的类型，以及这些类型之间的关系。图模式类似于关系数据库中的模式，它为图数据库中的数据提供了结构化的定义。图模式通常用于设计和验证图数据库的数据模型，确保数据的一致性和完整性。
- 图模式（Graph Pattern）：图模式是一种用于查询图数据库的模式，它描述了一种特定的子图结构，通常用于图查询语言中，如Cypher（用于Neo4j）。图模式指定了图中顶点和边的关系以及可能的属性匹配。例如，在Cypher查询中，图模式用于匹配图中的特定路径和节点。在本小节后续内容中，图模式均是指Graph Pattern。

图模式使用一种类似于我们在白板上绘制属性图的节点和关系的语法来描述数据。在白板上，我们通常使用圆形来表示节点，用箭头表示关系。而在图查询语言Cypher中，则使用一对圆括号表示圆形，用破折号和大于或小于符号表示箭头：
```SYNTAX
()-->()<--()
```

图模式匹配是一种在图数据库中查找特定结构或子图的过程。直观来看，图模式匹配就是找到图中与所定义的模式完全匹配的部分。这可以理解为子图与图中的某个部分完全重合。接下来，我们将通过关于属性图的具体示例来了解图模式是如何匹配的。

图模式匹配按照不同的维度可以分为节点匹配、关系匹配和路径匹配。

### 1.16.1 节点模式匹配

节点模式匹配（Node pattern matching）是指匹配符合特定条件的一组节点，通常关注节点的属性和类型。每个图模式至少包含一个节点模式。最简单的图模式是单个空节点模式，用Cypher表示为`()`，空节点模式会匹配属性图中的每个节点。

例如，对于图1-14-3的学生选课数据库的图模型，如果我们要查找所有计算机系的学生节点，直观来看，节点模式匹配可得到如图1-16-1所展示的结果，其中匹配到的节点用红色圆圈标注。

<center>
	<img src="fig/1.1.1_5.png" width="100%" alt="cluster" />
	<br>
	<div display: inline-block; padding : 2px>
		图 1-16-1 节点模式匹配示例 （匹配的节点以红色圆圈标注）
	</div>
</center>

### 1.16.2 关系模式匹配

关系模式匹配（Relationship pattern matching）是指匹配符合特定条件的关系，关注边的类型和属性。最简单的关系模式用Cypher表示是`--`，该模式匹配任何方向的关系，不过滤任何关系类型或属性。

例如，对于图1-14-3的学生选课数据库的图模型，如果我们要查找最终成绩在90及以上的所有选课关系，直观来看，关系模式匹配可得到如图1-16-2所展示的结果.

<center>
	<img src="fig/1.1.1_6.png" width="100%" alt="cluster" />
	<br>
	<div display: inline-block; padding : 2px>
		图 1-16-2 关系模式匹配示例（匹配的关系以红色线条标注）
	</div>
</center>

### 1.16.3 路径模式匹配

路径模式匹配（Path pattern matching）是指匹配符合特定条件的路径，涉及一个或多个节点和边，关注路径的结构和长度，可能是固定长度或可变长度的路径。任何有效路径都以节点为起点和终点，每个节点都有与之相连的关系（如果有多个节点）。

对于所有有效路径模式，以下条件都是正确的：
- 至少有一个节点模式。
- 以节点模式开始和结束。
- 交替使用节点和关系。

若用Cypher表示，以下路径模式都是正确的：
- `()`
- `()--()`
- `()--()<--()-->()`
这些用于节点和关系的简单模式构成了路径模式的基础模块。

错误的路径模式则如下所示：
- `-->`
- `()-->`
- `()-->-->()`

例如，对于图1-14-3的学生选课数据库的图模型，如果我们要查找沐辰选择的所有课程的路径，直观来看，路径模式匹配可得到如图1-16-3的结果：

<center>
	<img src="fig/1.1.1_7.png" width="100%" alt="cluster" />
	<br>
	<div display: inline-block; padding : 2px>
		图 1-16-3 路径模式匹配示例 （其中匹配的路径以红色标注）
	</div>
</center>

在本节中，我们学习了图中基本的操作——图模式识别，在下一节中，我们将学习图查询语言，了解如何使用图数据操作语言来实现图上的基本操作。

### 练习题

**1.** 在一个社交网络图中，如果需要查找所有年龄大于25岁的用户，应该使用哪种图模式匹配？

 <ol type="A">
 <li>关系模式匹配</li>
 <li>路径模式匹配</li>
 <li>节点模式匹配</li>
 <li>以上三种都可以</li>
 </ol>

**2.** 现在有一个科研合作网络包含以下节点类型：

- `Researcher` (研究者): 代表科研人员
- `Paper` (论文): 代表学术论文
- `Institution` (机构): 代表科研机构

以及以下关系类型：

- `AUTHORED` (撰写): 连接 `Researcher` 和 `Paper`，表示研究者撰写了论文
- `CITED` (引用): 连接 `Paper` 和 `Paper`，表示论文引用了另一篇论文
- `AFFILIATED_WITH` (隶属): 连接 `Researcher` 和 `Institution`，表示研究者隶属于某个机构

现在，你需要找到以下模式：一位研究者（A）撰写了一篇论文（P1），这篇论文（P1）引用了另一篇论文（P2），而另一位研究者（B）也撰写了这篇被引用的论文（P2）。请用类似 `()-->()` 的形式描述这个路径模式，并用节点类型和关系类型进行标注。


[**上一页<<**](chapter1.15-G.md) | [**>>下一页**](chapter1.17-G.md)