##  1.2 数据管理系统概述

###  1.2.1 关于数据

数据是一个宽泛而复杂的概念。人们常常将数据简单定义为“信息的记录”。这种简化的定义实际上只是一次概念的转移。如果我们继续追问：信息又是什么？人们仍然很难给出清晰的答案。在本书中，我们并不试图给数据一个严格而准确的定义。这难以做到。我们暂且选择实用主义的立场，讨论数据到底是用来干什么的。我们发现，在人类世界里，数据通常有两种明确的功用。

数据的第一大功用是作为**信息的载体**。也就是说，它被用于记载正在发生的或曾经发生的事实。比如：张三身高175厘米体重75公斤；李四于2020年3月18日花费15元在淘宝上购买了一只高露洁全效牙膏；2020年1月20日14点35分在北纬37度东经15度的区域发生了6.5级地震；等等。这样的事实被记录下来，形成数据，便于我们传递信息、互通有无。

另一方面，大量信息的汇聚可以帮助人类总结经验，发现新知，从而指导甚至代替人类作出更好的决策和行动。例如，当代的电商平台会刻意记录用户的购物行为数据，从中总结出不同用户的购物偏好，以实现全自动的个性化商品推广。如今，四通八达的IT基础设施帮助我们收集了大量数据，包括了各类认知数据（如语言、音视频等）以及行为数据（如决策行为）。再利用机器学习等技术，我们从这些数据中提取出人的认知和决策规律，构造出了强大的人工智能。

总之，数据作为信息载体，其重要性日益凸显，愈发普遍地被使用在各种生产、流通和生活场景中。数据的加速汇聚导致了“大数据”产业的形成。数据成为了价值连城的生产要素，需要得到有效管理。

数据的第二大功用是作为**事实的凭据**，为现代社会的有序运转提供了事实基础。举例说明一下，我们是如何认定“张三的银行账户中有500万”这件事的真实性的？细究之后，我们会发现，这个事实无法通过实物来判断。银行显然不会单独为张三准备一个保险箱，并且在里面装入500万现金。相反，我们只能依靠银行的账本或者张三的存折上记录的数据来判断。如今，账本和存折都已经数字化，数据被存放于计算机系统里的数据库中。又比如，我们如何判断“霞飞路909号的洋房是属于李四的”这件事是否属实？同理，所有权是抽象的概念，无法实物化，只能依靠数据来证实。这项数据记录在李四的房产证上，同时也记录在房产管理机构的数据库中。

除所有权之外，还有很多事实是依靠数据来确立的，比如一个人的国籍和职位、一个企业的资质、以及人类社会中各种形而上的事物。这些用来证明事实的数据是人类社会实现人、财、物管理的基础，需要被妥善保管。

或许你会认为，数据的第二种功用只是第一种功用的特殊情况。换言之，作为事实凭据的数据也只是记载了信息，只是维护该数据的机构具备某种权威性，以至于它记录的信息被信任为事实。在笔者看来，可以不在概念上做过多纠缠。在实际生活中，很多数据确实兼具这两种功用。但这两种功用是明确不同的。如果作为第一种功用的数据丢失或损坏了，并不会影响人类世界的既有事实。相反，如果作为第二种功用的数据丢失或者损坏了，我们对事实的认定就变化了（比如财产就变更了）。之所以区分这两种功用，是因为它们对数据管理的能力提出了不同需求，需要为它们针对性的构建数据管理系统的功能。

###  1.2.2 数据管理功能

无论作为信息的载体还是事实的凭据，数据都需要被好好管理起来。那么，如何才能做到数据的有效管理？我们可以将数据管理功能划分成以下几个方面。

**保护数据的持久性：** 首先，数据需要被妥善地存放起来。无论发生什么意外，都不应该让数据轻易丢失或损坏。事实上，没有任何一种存储介质或硬件设施能够做到万无一失，无论是纸张、硬盘、光盘。因此，我们常常需要对高价值的数据进行定期备份，减少数据因意外而丢失的概率。当数据有了多个备份，我们还需要让它们保持一致，避免发生错乱。

**让数据可用：** 其次，数据需要被有效地组织起来，便于我们快速查找信息。以图书为例，当我们家里的藏书越来越多时，就不能再将它们随意地堆砌在书架上，而需要对它们进行分类或者索引，否则以后查找起来将会很困难。对一座有百万藏书的图书馆而言，书籍的分类和索引就更加重要了，需要花费不菲的人力和财力进行维护。数据必须被组织起来才能供人使用。当数据越多、结构越复杂，人们对数据组织的要求就越高。

**保证数据的真实性：** 当数据被用作事实的凭据时，我们需要保证数据如实地反映现实世界的变化。比如，当张三往银行里存入一笔钱后，我们必须保证他账户上的余额增加。当李四卖掉自己的房屋后，我们必须保证房产管理系统里的户主变更。让现实世界的变化分毫不差地落实在数据上，这也是数据管理需要担负的重要职责。

**提供数据处理能力：** 数据的使用过程是一个计算过程，这个过程可以在应用程序里进行，也可以在数据管理系统里进行。后者通常适用于通用的数据处理任务，比如对数据进行排序、累加等操作。将通用的数据处理程序移到数据管理系统中，并通过简单接口提供给应用程序，将大大减轻程序开发的负担。

**保证信息安全：** 最后，有的数据中含有机密和敏感信息。数据的主人不仅需要防止信息被泄露给没有权限的人，还要防止数据被恶意损坏或篡改。保护数据的安全也是数据管理的重要环节。

以上的各种数据管理功能并非独立存在。它们常常交织在一起。比如，信息安全需要数据组织的协助，以便区分什么人可以访问什么数据。又比如，数据的真实性和持久性往往是关联的，数据失真和数据损坏可以通过同样的机制来预防。这里的功能划分是要给读者一个直观印象。至于其中的具体定义和细节，本书后面再作详细介绍。

###  1.2.3 数据管理系统的目的

顾名思义，数据管理系统的目的当然是提供上述数据管理功能。但这里涉及一个通用性的问题。可以想象，不同应用会使用不同的数据，对数据的组织方式和访问模式也都不同。如果要全方位满足应用对数据管理的需求，我们可能不得不为每一个应用单独构造一套数据管理系统。然而，如前文所述，数据管理系统是具备通用性的系统软件，不可能为某一个应用进行定制。相反，我们应该找到不同应用对数据管理功能的共同需求，将这些共同点抽象成为数据管理系统的功能，而将差异化的需求交给上层的应用程序去满足。也就是说，我们无法让数据管理系统包揽所有的数据管理功能，而需要在它和应用程序之间划一道界限。

事实证明，划出这道界限并不简单。如果我们将数据管理的功能尽可能推给数据管理系统去实现，我们可以减少应用程序开发的工作量。但这样做可能造成数据管理系统的臃肿，无法适应变化，也可能导致数据管理功能的接口过于复杂，以至于失去易用性。如果我们精简数据管理系统的功能，可以让系统变得更加通用、更加灵活，但也可能会让应用程序的开发负担过重。这里似乎没有完美的选择，更多是需要一种折衷。我们后面会陆续介绍不同的系统都选择了什么样的折衷点。

总之，数据管理实际上是由应用程序和数据管理系统共同完成的。从实用的角度考虑，数据管理系统的目的是以最好的方式协助应用程序实现数据管理功能，而并不是承包整个数据管理的功能。某种意义上，数据管理系统只是一个工具。就像在制造家具时，我们并不指望有一台全能的机器，只要告诉它我们需要什么家具，它就能自动造出来。我们通常使用的是锯子、尺子、凿子这样的简单制造工具，辅以灵活的双手，就可以构造出任何我们需要的东西。这些制造工具经历了时间的洗礼，被证明是最有效的方式。同理，在构建应用的数据管理功能时，软件工程师并不指望一套全能的数据管理系统，他们更在乎这个系统用起来是否顺手。对数据管理系统的这一看法可能是本书的一个独特视角。在本书后面的内容中，这个视角可以帮助我们更好地理解数据管理系统背后的设计思想。

### 练习题

**1**. 如本章提到，由于大部分应用程序都需要数据管理功能，因此人们将数据管理功能抽象出来，形成可独立运行的系统。然而并非所有的功能抽象都有必要成为独立的系统。比如“排序”这一功能，只需要构造成一个库函数，供各种程序调用即可。那么，为什么数据管理功能需要被构造成独立运行的系统？你认为以下那种说法不成立？
 <ol type="A">
 <li>数据管理功能很复杂，复杂的功能需要成为独立的系统。</li>
 <li>数据管理需要消耗大量资源（包括CPU、内存、硬盘），独立系统可实现独立的资源调配，有利于资源的高效利用。</li>
 <li>同一份数据有时候需要被多个应用程序共享，独立的系统有利于共享。</li>
 <li>作为独立系统的一个好处是：当应用程序出错时，不容易牵连数据管理系统，造成数据损坏。</li>
 </ol>

**2**. 关于如何让数据管理系统具备较高的隔离性，哪种说法不对？(这里的隔离性是软件模块化意义上的，即让数据管理系统成为独立的与软件其他部分耦合度低的模块。)
  <ol type="A">
 <li>让数据管理系统的职责明确</li>
 <li>让数据访问的方式尽可能简单</li>
 <li>尽可能将所有的数据都交给数据管理系统管理</li>
 <li>让数据管理系统运行在独立的机器上</li>
 </ol>

[**上一页<<**](chapter1.1.md) | [**>>下一页**](chapter1.3.md)
