## 5.9 博客网站的图结构设计
本节通过前面章节的博客网站来展示从数据库概念涉及到图数据库结构设计的过程。

### 5.9.1 图结构设计
根据图数据库的设计规则，图5-2-3博客网站的ERD概念模型可转换以下节点和边：
- 用户实体转换为用户节点User，包含用户ID（u\_id）、用户名（name）、性别（gender）、注册时间（reg\_date）四个属性，其中用户ID（u\_id）为主码；
- 文章实体转换为文章节点Doc，包含文章ID（d\_id）、文章标题（title）、文章内容（d\_content）、发表时间（pub\_date）、用户名（name）五个属性，其中文章ID（d\_id）为主码。用户与文章之间的一对多写作关系通过发表边PUBLISH表示。
- 评论实体转换为评论节点Comment，包含评论ID（c\_id）、评论内容（c\_content）、评论时间（com\_date）三个属性，其中文章ID（d\_id）为主码。用户与评论之间的一对多写作关系通过GIVE_COMMENT边表示，文章与评论之间的一对多关系通过评论边HAS\_COMMENT表示。
- 用户与用户之间的多对多关注关系转换为关注边FOLLOW表示。

```bson
节点模式：
用户节点 User(u_id, name, gender, reg_date)，u_id是主码；
文章节点 Doc(d_id, title, d_content, pub_date, name)，d_id是主码；
评论节点 Comment(c_id, c_content, com_date)，c_id是主码；

边模式：
发表边 (User)-[:PUBLISH]->(Doc)
评论边 (User)-[:GIVE_COMMENT]->(Doc)
关注边 (User)-[:FOLLOW]->(User)
文章的评论边 (Doc)-[:HAS_COMMENT]->(Comment)
```

根据上述图数据库设计，图5-2-1博客网站的功能可以很好地基于该图数据库模式实现：
- 博客首页通过遍历用户节点的FOLLOW边，获取所关注用户的PUBLISH边连接的文章节点，按pub_date排序，展示该用户关注的博主最新发表的文章简介。
- 个人主页通过访问用户节点的属性从而展示该用户的信息。同时，遍历该用户的PUBLISH边，按pub_date排序，展示其从新到旧发表的博客文章。点击文章跳转用户展示界面，则通过文章的d_id获取对应的文章节点进行实现。
- 博客展示界面访问文章节点，显示其标题、作者、发表日期和内容。通过HAS_COMMENT边获取评论，按com_date排序。用户可点击评论作者名字，通过u_id获取用户节点并进入其个人主页。页面底部提供评论编辑界面，允许用户添加新评论，创建GIVE_COMMENT边。
- 博客编辑界面界面提供博客文章的编辑功能，编写完成后将其构建为新的文章节点，并通过建立用户与该文章的PUBLISH边进行发布。

根据上述分析，我们可以通过数据冗余设计对图数据模式进行非规范化优化。比如，访问博客需要额外遍历PUBLISH边以获取其作者名称，由于作者名称通常不会修改，我们可以在文章节点中冗余存储用户名（name），从而提升博客展示界面的性能。此外，博客网站经常需要根据文章ID（d_id）获取对应文章节点和根据用户ID（u_id）进入用户主页。为了进一步提高查询性能，我们可以在文章节点（Doc）的d_id字段和用户节点（User）的u_id字段上创建索引，以加速节点的查找。

### 练习题

**1**. 请对5.2节第1题（电影网站）构建相应的图数据库模式，然后再根据应用访问数据库的方式对模式进行优化。

**2**. 请对5.2节第2题（床位分享平台）构建相应的图数据库模式，然后再根据应用访问数据库的方式对模式进行优化。

**2**. 请对5.5节第3题（校园学术活动网站）构建相应的图数据库模式，然后再根据应用访问数据库的方式对模式进行优化。

 [**>>上一页**](chapter5.8-G.md)