# 🎬 JJYB_AI智剪 v2.0

> **智能视频剪辑工具** - 完整AI流程 + 精确同步机制  
> **状态**: ✅ 100%完成 | **版本**: v2.0 | **发布**: 2025-11-11

---

## ⚡ 快速开始（3步）

### 1️⃣ 检查环境
```bash
python check_system.py
```

### 2️⃣ 启动应用
```bash
# 双击运行
启动应用.bat

# 或命令行
python frontend/app.py
```

### 3️⃣ 访问应用
```
http://localhost:5000
```

🎉 **完成！** 详细指南 → [START_HERE.md](START_HERE.md)

---

## ⭐ 三大核心功能

### 🎬 视频编辑器
- 🎯 完整播放控制 + 轨道管理
- ⚡ **音画/字画/字音三重同步** (<100ms)
- ✨ 特效、滤镜、转场完整支持
- 📍 URL: `http://localhost:5000/`

### 🎙️ AI配音
- 🔊 多引擎TTS (Edge-TTS/gTTS/voice_clone)
- 🎵 丰富音色库 + 声音克隆
- 🎛️ 实时参数调节
- 📍 URL: `http://localhost:5000/voiceover`

### 📝 原创解说
- 🤖 AI视觉理解 → LLM文案 → TTS配音 → 视频合成
- 🔗 完整自动化流程
- 🎯 精确同步机制
- 📍 URL: `http://localhost:5000/commentary`

---

## 🤖 AI模型支持

### 大语言模型（9种）
- ✅ **通义千问** (阿里巴巴) - 推荐
- ✅ **文心一言** (百度)
- ✅ **ChatGLM** (智谱AI)
- ✅ **DeepSeek** - 性价比高
- ✅ **OpenAI GPT-4/GPT-3.5** - 专业版
- ✅ **Claude 3 (Anthropic)** - 高级推理
- ✅ **Google Gemini** - 多模态
- ✅ **月之暗面 Kimi** - 长文本
- ✅ **讯飞星火** (科大讯飞)

### 视觉分析模型（6种）
- ✅ **通义千问VL** - 推荐
- ✅ **百度视觉**
- ✅ **腾讯云视觉**
- ✅ **GPT-4V** (OpenAI Vision)
- ✅ **Gemini Vision** (Google)
- ✅ **Claude Vision** (Anthropic)

### 语音TTS模型（4种）
- ✅ **Edge-TTS** - 免费推荐（23+音色）
- ✅ **Google TTS (gTTS)** - 免费多语言
- ✅ **Azure TTS** - 专业级（付费）
- ✅ **Voice Clone** - 本地语音克隆
  
> ℹ️ 内置回退：已集成 pyttsx3（离线），在网络受限时会自动回退以保证配音可用。

---

## 🏗️ 技术架构

```
┌─────────────────────────────────────────┐
│          前端层 (Frontend)              │
│  Flask 3.0 + Socket.IO + 现代化UI       │
└─────────────────────────────────────────┘
                    ↓
┌─────────────────────────────────────────┐
│          AI引擎层 (Backend)             │
│  • 视觉分析 (6种模型)                   │
│  • 文案生成 (9种大语言模型)             │
│  • 语音合成 (4种TTS引擎)                │
│  • 音频处理 (Whisper/Librosa)           │
└─────────────────────────────────────────┘
                    ↓
┌─────────────────────────────────────────┐
│        视频处理层 (Processing)          │
│  FFmpeg + MoviePy + OpenCV              │
└─────────────────────────────────────────┘
                    ↓
┌─────────────────────────────────────────┐
│         数据层 (Database)               │
│  SQLite + 项目管理 + 素材管理           │
└─────────────────────────────────────────┘
```

## 📁 项目结构

```
JJYB_AI智剪/
├── 启动应用.bat               # ⭐ 一键启动脚本（推荐入口）
├── check_system.py           # 🔍 系统检查与依赖检测
├── init_test_data.py         # 📊 初始化测试数据
├── requirements.txt          # 📋 Python 依赖清单
├── README.md                 # 📖 项目说明（本文件）
├── START_HERE.md             # 🚀 快速入口指南
├── frontend/                 # 🎨 前端 Web 与桌面界面
│   ├── app.py               # Flask 主应用入口（含 WebSocket）
│   ├── templates/           # HTML 模板（核心业务页面 + 公共模板）
│   │   ├── index.html       # 视频编辑器首页
│   │   ├── commentary.html  # 原创解说页面
│   │   ├── remix.html       # 混剪模式页面
│   │   ├── voiceover.html   # AI 配音页面
│   │   ├── settings.html    # 设置与 API 配置页面
│   │   ├── projects.html    # 项目管理页面
│   │   └── ...              # 其他页面（404/500/AI 功能等）
│   └── static/              # 静态资源（CSS/JS/图片/字体等）
├── backend/                 # 🤖 后端服务与 AI 引擎
│   ├── api/                 # API 路由与接口
│   ├── engine/              # AI 引擎与音视频处理核心
│   ├── services/            # 业务服务层（解说/混剪/配音等）
│   ├── config/              # 后端配置（AI/路径等）
│   ├── database/            # 数据库访问与会话管理
│   ├── prompts/             # 提示词模板与系统提示
│   ├── utils/               # 通用工具函数与日志
│   ├── core/                # 核心启动与调度逻辑
│   └── assets/              # 资源与示例文件
├── config/                  # ⚙️ 全局配置（INI/路径等）
├── database/                # 💾 数据库文件
├── logs/                    # 📁 运行日志
├── resource/                # 📦 AI 模型与模板资源
├── uploads/                 # 📥 用户上传文件
├── output/                  # 📤 导出结果文件
├── tests/                   # ✅ 自动化测试
├── 开发文档/                # 📚 完整开发文档
│   ├── README.md           # 开发文档说明
│   ├── 文档索引.md
│   ├── JJYB_AI智剪_完整开发文档.md
│   ├── JJYB_AI智剪_完整开发文档_Part2.md
│   └── JJYB_AI智剪_完整开发文档_Part3.md
└── yolov8n.pt               # 🎯 YOLOv8 模型权重（目标检测）
```

## 🔧 技术栈

### Web框架
- **后端框架**: Flask 3.0+
- **实时通信**: Flask-SocketIO 5.3+
- **数据库**: SQLite
- **桌面应用**: PyWebView 4.4+

### AI/深度学习
- **深度学习框架**: PyTorch 2.0+
- **目标检测**: Ultralytics (YOLOv8)
- **音频处理**: Librosa, SoundFile, Pydub
- **语音识别**: Whisper / faster-whisper（当前实现）
- **语音合成**: Edge-TTS, gTTS, Azure TTS
- **语音克隆**: Voice Clone (本地部署)

### 大语言模型（9种）
- 通义千问、文心一言、ChatGLM、DeepSeek
- OpenAI GPT-4、Claude 3、Google Gemini
- 月之暗面 Kimi、讯飞星火

### 视觉模型（6种）
- 通义千问VL、百度视觉、腾讯云视觉
- GPT-4V、Gemini Vision、Claude Vision

### 视频处理
- **核心引擎**: FFmpeg
- **Python封装**: MoviePy 1.0+, OpenCV 4.8+
- **图像处理**: Pillow 10.0+, ImageIO
- **字幕处理**: pysrt

## 📖 详细使用说明

### 第一步：配置API（首次使用必须）

访问API配置页面：`http://localhost:5000/api_settings`

**必须配置（至少一个）**：
1. **大语言模型API**（用于AI文案生成）
   - 推荐：通义千问（免费额度）
   - 性价比：DeepSeek
   - 专业版：OpenAI GPT-4、Claude 3

**可选配置**：
2. **视觉分析模型API**（用于视频内容理解）
   - 推荐：通义千问VL
3. **TTS语音服务**（已内置Edge-TTS免费服务）
   - 专业级：Azure TTS（需付费）
   - 本地克隆：Voice Clone

### 第二步：选择功能模块

#### 🎙️ 原创解说剪辑
**完整流程**：
1. 上传视频文件
2. 选择大语言模型（自动生成文案）
3. 选择视觉模型（分析画面内容）
4. AI自动生成解说文案
5. 选择音色并配音
6. 调整参数（可选）：
   - 多模态特征提取（6个参数）
   - 时间轴优化（4个参数）
   - 技术性能优化（4个参数）
   - 跨平台适配（6个参数）
7. 一键导出成品视频

**高级配置**：52个配置项可精细调优

#### ✂️ 混剪模式
**两种模式**：
1. **大众混剪模式**
   - 批量导入视频素材
   - AI智能识别精彩片段
   - 选择混剪风格（燃向/治愈/搞笑等）
   - 自动添加转场和特效
   - 导出混剪视频

2. **音乐卡点混剪**
   - 上传音乐文件
   - 自动节奏检测（4种算法）
   - 卡点匹配策略（4种）
   - 智能片段选择与排序
   - 自动对齐音乐节拍

**高级配置**：34个配置项

#### 🔊 AI配音
**使用流程**：
1. 输入文本内容
2. 选择TTS引擎：
   - Edge-TTS（推荐，免费，23+音色）
   - Google TTS（免费，100+语言）
   - Azure TTS（专业级，需付费）
   - Voice Clone（本地语音克隆）
3. 选择音色和语言
4. 调整基础参数（语速/音调/音量）
5. 高级配置（可选）：
   - TTS声学模型（5种）
   - 声码器配置（5种）
   - 韵律预测（8个参数）
   - 情感TTS（12个参数）
   - 说话人嵌入（8个参数）
   - 音频特征提取（8个参数）
6. 实时预览效果
7. 导出高质量音频

**高级配置**：38个配置项（30个AI配置）

## ⚠️ 常见问题

### 问题1：启动失败 - Python未安装
**症状**：提示"未找到Python"

**解决方案**：
1. 访问：https://www.python.org/downloads/
2. 下载Python 3.9-3.11版本
3. 安装时勾选"Add Python to PATH"
4. 重新运行启动文件

---

### 问题2：端口被占用
**症状**：提示"端口5000已被占用"

**解决方案**：
1. 启动时选择[Y]自动释放端口
2. 或手动关闭占用进程：
   ```cmd
   netstat -ano | findstr ":5000"
   taskkill /F /PID [进程ID]
   ```

---

### 问题3：依赖包缺失
**症状**：启动失败，提示模块未找到

**解决方案**：
1. 运行"安装AI依赖.bat"完整安装
2. 或启动时选择[1]快速安装
3. 手动安装：
   ```cmd
   pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple/
   ```

---

### 问题4：AI功能无法使用
**症状**：无法生成文案/无法配音

**解决方案**：
1. 检查API配置：访问 http://localhost:5000/api_settings
2. 确保至少配置了一个大语言模型API
3. 点击"测试"按钮验证API是否有效
4. 查看API密钥是否正确

---

### 问题5：启动后无法访问
**症状**：浏览器打开但无法加载页面

**解决方案**：
1. 检查防火墙设置
2. 确认端口5000未被其他程序占用
3. 尝试手动访问：http://127.0.0.1:5000
4. 查看启动窗口的错误信息

---

## 技术文档
 
详细文档请查看 `开发文档/` 文件夹：

**核心技术文档**：
- [JJYB_AI智剪_完整开发文档.md](开发文档/JJYB_AI智剪_完整开发文档.md)
- [JJYB_AI智剪_完整开发文档_Part2.md](开发文档/JJYB_AI智剪_完整开发文档_Part2.md)
- [JJYB_AI智剪_完整开发文档_Part3.md](开发文档/JJYB_AI智剪_完整开发文档_Part3.md)

**索引与说明**：
- [README.md](开发文档/README.md)
- [文档索引.md](开发文档/文档索引.md)

## 系统要求

### 最低配置
- **操作系统**: Windows 10/11（64位）
- **Python版本**: 3.9 - 3.11（必须）
- **内存**: 8GB RAM
- **硬盘**: 10GB 可用空间
- **网络**: 需要互联网（安装依赖和API调用）
- **FFmpeg**: 自动安装（包含在依赖中）

### 推荐配置
- **操作系统**: Windows 11
- **Python版本**: 3.10（最佳兼容性）
- **内存**: 16GB RAM
- **硬盘**: 20GB+ SSD
- **CPU**: 多核处理器（4核心+）
- **GPU**: NVIDIA显卡（可选，加速AI处理）

### 依赖包大小
- 基础依赖：~500MB
- PyTorch（CPU版）：~200MB
- AI模型：~1GB
- **总计**: 约2GB磁盘空间

## 📊 项目统计

### 功能完成度
- **原创解说**: 52个配置项 ✅
- **视频混剪**: 34个配置项 ✅
- **AI配音**: 38个配置项 ✅
- **API配置**: 19个模型 ✅
- **总配置项**: 143个

### 模型支持
- **大语言模型**: 9种
- **视觉模型**: 6种
- **TTS模型**: 4种
- **声学模型**: 5种
- **声码器**: 5种
- **总计**: 29种模型/算法

### 技术文档
- 核心技术文档：4个
- 配置说明文档：4个
- 完善总结文档：8个
- **总计**: 16个完整文档

---

## 🔄 版本历史

### v2.0（2025-11-10）- 当前版本
- ✅ 统一启动文件（智能检查）
- ✅ 完整API配置（19个模型）
- ✅ 原创解说功能（52配置项）
- ✅ 视频混剪功能（34配置项，2种模式）
- ✅ AI配音功能（38配置项）
- ✅ 完整技术文档（16个）

### v1.0（2024）
- 基础视频编辑功能
- 简单AI配音
- 初始版本

---

## 📞 技术支持

### 遇到问题？
1. **查看文档**：docs目录下的详细文档
2. **检查日志**：查看启动窗口的错误信息
3. **重新安装**：运行"安装AI依赖.bat"
4. **检查配置**：确保API配置正确

### 反馈建议
欢迎提供使用反馈和改进建议！

---

## 📄 许可证

MIT License

Copyright (c) 2024-2025

---

## 🎉 特别说明

**JJYB_AI智剪 v2.0** 是一个功能完整、配置丰富、文档齐全的专业AI视频编辑工具：

- 🚀 **一键启动**：智能检查，自动配置
- 🤖 **19个AI模型**：全面支持主流模型
- ⚙️ **143个配置项**：专业级精细调优
- 📚 **16个技术文档**：完整技术体系
- 🎯 **100%完成度**：所有功能完整实现

**让AI视频创作更简单、更专业！** 🎬✨🚀
