/**************************************************
 *
 * This file declares the ICCARM builtin functions.
 *
 * Copyright 1999-2019 IAR Systems. All rights reserved.
 *
 * $Revision$
 *
 **************************************************/

#ifndef __BUILTINS_A64_INCLUDED
#define __BUILTINS_A64_INCLUDED

#include <yvals.h>

#ifndef _SYSTEM_BUILD
  #pragma system_include
#endif

/*
 * Check that the correct C/C++ compiler is used.
 */

#ifndef __ICCARM__
#error "File iccarm_builtin.h can only be used together with iccarm."
#endif

/* Define function effects for intrinsics */
#define __IEFF_NE _Pragma("function_effects = no_state, always_returns")

#ifdef __cplusplus
extern "C" {
#endif

#pragma language=save
#pragma language=extended

__ATTRIBUTES void __iar_builtin_no_operation(void);
__ATTRIBUTES void __iar_builtin_disable_interrupt(void);
__ATTRIBUTES void __iar_builtin_enable_interrupt(void);

typedef unsigned long long __istate_t;  // Interrupt state for AArch64: DAIF.

__ATTRIBUTES __istate_t __iar_builtin_get_interrupt_state(void);
__ATTRIBUTES void __iar_builtin_set_interrupt_state(__istate_t);

#define __sys_reg  __spec_string const char *

/* Read a system register. NOTE: source for __arm_rsrp is always a 64-bit system register. */
__ATTRIBUTES unsigned int __iar_builtin_rsr(__sys_reg special_register);
__ATTRIBUTES unsigned long long __iar_builtin_rsr64(__sys_reg special_register);
__ATTRIBUTES void* __iar_builtin_rsrp(__sys_reg special_register);

/* Write a system register. NOTE: destination for __arm_wsrp is always a 64-bit system register. */
__ATTRIBUTES void __iar_builtin_wsr(__sys_reg special_register, unsigned int value);
__ATTRIBUTES void __iar_builtin_wsr64(__sys_reg special_register, unsigned long long value);
__ATTRIBUTES void __iar_builtin_wsrp(__sys_reg special_register, const void *value);

__ATTRIBUTES unsigned long long __get_LR(void);
__ATTRIBUTES void __set_LR(unsigned long long);

// Barrier instructions
__ATTRIBUTES void __iar_builtin_DMBx(unsigned int __constrange(1, 15));
__ATTRIBUTES void __iar_builtin_DSBx(unsigned int __constrange(1, 15));
__ATTRIBUTES void __iar_builtin_ISBx(unsigned int __constrange(1, 15));

// CRC32 instructions
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32B(unsigned int, unsigned char);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32H(unsigned int, unsigned short);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32W(unsigned int, unsigned int);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32X(unsigned int, unsigned long long);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32CB(unsigned int, unsigned char);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32CH(unsigned int, unsigned short);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32CW(unsigned int, unsigned int);
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CRC32CX(unsigned int, unsigned long long);

// Bit handling instructions
__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_CLZ(unsigned int);

__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_REV( unsigned int );

__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_REV16( unsigned int );

__IEFF_NE __ATTRIBUTES signed int __iar_builtin_REVSH( short );

__IEFF_NE __ATTRIBUTES unsigned int __iar_builtin_RBIT( unsigned int );

__IEFF_NE __ATTRIBUTES int __builtin_clz(unsigned int);

// __builtin_clzl not defined here since it has different signatures
// depending on mode (ilp32 vs lp64).

__IEFF_NE __ATTRIBUTES int __builtin_clzll(unsigned long long);

__IEFF_NE __ATTRIBUTES int __builtin_ctz(unsigned int);

__IEFF_NE __ATTRIBUTES int __builtin_ctzll(unsigned long long);

// Floating point intrinsics
__IEFF_NE __ATTRIBUTES float __iar_builtin_VSQRT_F32(float);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VSQRT_F64(double);

__IEFF_NE __ATTRIBUTES float __iar_builtin_VFMA_F32(float, float, float);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VFMA_F64(double, double, double);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VFMS_F32(float, float, float);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VFMS_F64(double, double, double);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VFNMA_F32(float, float, float);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VFNMA_F64(double, double, double);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VFNMS_F32(float, float, float);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VFNMS_F64(double, double, double);

// Rounding
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTA_F32(float);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTM_F32(float);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTN_F32(float);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTP_F32(float);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTX_F32(float);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTR_F32(float);
__IEFF_NE __ATTRIBUTES float __iar_builtin_VRINTZ_F32(float);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTA_F64(double);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTM_F64(double);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTN_F64(double);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTP_F64(double);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTX_F64(double);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTR_F64(double);
__IEFF_NE __ATTRIBUTES double __iar_builtin_VRINTZ_F64(double);

#pragma language=restore

#ifdef __cplusplus
}
#endif

#undef __IEFF_NE

#endif  /* __BUILTINS_A64_INCLUDED */
