//
// THIS FILE IS GENERATED FROM 'src/Generate/Neon/arm_neon_templ.h.templ' Fri Jul 12 14:30:33 2024
// DO NOT EDIT !!
//

#ifndef __ARM_NEON_H__
#define __ARM_NEON_H__

#ifndef __ICCARM__
#error "Not used with ICCARM"
#endif

#include <stdint.h>
#include <iccarm_builtin.h>

#pragma language=save
#pragma language=extended

typedef uint8_t poly8_t;
typedef uint16_t poly16_t;
typedef __fp16 float16_t;
typedef float float32_t;

#define vrndns_f32  __iar_builtin_VRINTN_F32

#define __VECNAME(t,l) t##x##l##_t
#define __STRUCTNAME(s,t,l) __simd##s##_##t##x##l
#define __STRUCT64(t,l) struct __STRUCTNAME(64,t,l) { double __p1; }
#define __STRUCT128(t,l) struct __STRUCTNAME(128,t,l) { double __p1, __p2; }

#define __VECTOR64(T,L) typedef __STRUCT64(T,L) __VECNAME(T,L)
#define __VECTOR128(T,L) typedef __STRUCT128(T,L) __VECNAME(T,L)

__VECTOR64(int8,     8);
__VECTOR64(int16,    4);
__VECTOR64(int32,    2);
__VECTOR64(int64,    1);
__VECTOR64(uint8,    8);
__VECTOR64(uint16,   4);
__VECTOR64(uint32,   2);
__VECTOR64(uint64,   1);
__VECTOR64(float16,  4);
__VECTOR64(float32,  2);
__VECTOR64(poly8,    8);
__VECTOR64(poly16,   4);
__VECTOR128(int8,   16);
__VECTOR128(int16,   8);
__VECTOR128(int32,   4);
__VECTOR128(int64,   2);
__VECTOR128(uint8,  16);
__VECTOR128(uint16,  8);
__VECTOR128(uint32,  4);
__VECTOR128(uint64,  2);
__VECTOR128(float16, 8);
__VECTOR128(float32, 4);
__VECTOR128(poly8,  16);
__VECTOR128(poly16,  8);

#define __ARRAYNAME(N, V, T, L) T##x##L##x##N##_t
#define __ARRAYSTRUCT(N, V, T, L) struct __simd_array##N##_##T##x##L##_t { __VECNAME( T, L ) val[N]; }

// #define __ARRAYSTRUCT(N, V, T, L) struct __simd_array##N##_##T##x##L##_t

#define __ARRAY(N, V, T, L) typedef __ARRAYSTRUCT(N,V,T,L) __ARRAYNAME(N,V,T,L)
#define __ALLARRAYS(V,T,L) \
    __ARRAY(2,V,T,L); \
    __ARRAY(3,V,T,L); \
    __ARRAY(4,V,T,L);

__ALLARRAYS(64,  poly8,   8)
__ALLARRAYS(128, poly8,  16)
__ALLARRAYS(64,  poly16,  4)
__ALLARRAYS(128, poly16,  8)
__ALLARRAYS(64,  float16, 4)
__ALLARRAYS(128, float16, 8)
__ALLARRAYS(64,  float32, 2)
__ALLARRAYS(128, float32, 4)
__ALLARRAYS(64,  int8,    8)
__ALLARRAYS(128, int8,   16)
__ALLARRAYS(64,  int16,   4)
__ALLARRAYS(128, int16,   8)
__ALLARRAYS(64,  int32,   2)
__ALLARRAYS(128, int32,   4)
__ALLARRAYS(64,  int64,   1)
__ALLARRAYS(128, int64,   2)
__ALLARRAYS(64,  uint8,   8)
__ALLARRAYS(128, uint8,  16)
__ALLARRAYS(64,  uint16 , 4)
__ALLARRAYS(128, uint16,  8)
__ALLARRAYS(64,  uint32,  2)
__ALLARRAYS(128, uint32,  4)
__ALLARRAYS(64,  uint64,  1)
__ALLARRAYS(128, uint64,  2)

#define __IEFF_HS _Pragma("function_effects = hidden_state, always_returns")
#define __IEFF_NE _Pragma("function_effects = no_state, always_returns")
#define __IEFF_NENR1 _Pragma("function_effects = no_state, no_read(1), always_returns")
#define __IEFF_NENW1 _Pragma("function_effects = no_state, no_write(1), always_returns")

// SECTION:acc_binop:64:rt(p,p,p)
__IEFF_NE __ATTRIBUTES int16x4_t vaba_s16(int16x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vaba_s32(int32x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vaba_s8(int8x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vaba_u16(uint16x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vaba_u32(uint32x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vaba_u8(uint8x8_t, uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vfma_f32(float32x2_t, float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vfms_f32(float32x2_t, float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmla_f32(float32x2_t, float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmla_s16(int16x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmla_s32(int32x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmla_s8(int8x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmla_u16(uint16x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmla_u32(uint32x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmla_u8(uint8x8_t, uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmls_f32(float32x2_t, float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmls_s16(int16x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmls_s32(int32x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmls_s8(int8x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmls_u16(uint16x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmls_u32(uint32x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmls_u8(uint8x8_t, uint8x8_t, uint8x8_t);

// SECTION:acc_binop_const:64:rt(p,p,cw0)
__IEFF_NE __ATTRIBUTES poly16x4_t vsli_n_p16(poly16x4_t, poly16x4_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES poly8x8_t vsli_n_p8(poly8x8_t, poly8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x4_t vsli_n_s16(int16x4_t, int16x4_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int32x2_t vsli_n_s32(int32x2_t, int32x2_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES int64x1_t vsli_n_s64(int64x1_t, int64x1_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES int8x8_t vsli_n_s8(int8x8_t, int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x4_t vsli_n_u16(uint16x4_t, uint16x4_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint32x2_t vsli_n_u32(uint32x2_t, uint32x2_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES uint64x1_t vsli_n_u64(uint64x1_t, uint64x1_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES uint8x8_t vsli_n_u8(uint8x8_t, uint8x8_t, int __constrange(0,7));

// SECTION:acc_binop_const:64:rt(p,p,cw1)
__IEFF_NE __ATTRIBUTES int16x4_t vrsra_n_s16(int16x4_t, int16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vrsra_n_s32(int32x2_t, int32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x1_t vrsra_n_s64(int64x1_t, int64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x8_t vrsra_n_s8(int8x8_t, int8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vrsra_n_u16(uint16x4_t, uint16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vrsra_n_u32(uint32x2_t, uint32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x1_t vrsra_n_u64(uint64x1_t, uint64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x8_t vrsra_n_u8(uint8x8_t, uint8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x4_t vsra_n_s16(int16x4_t, int16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vsra_n_s32(int32x2_t, int32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x1_t vsra_n_s64(int64x1_t, int64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x8_t vsra_n_s8(int8x8_t, int8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vsra_n_u16(uint16x4_t, uint16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vsra_n_u32(uint32x2_t, uint32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x1_t vsra_n_u64(uint64x1_t, uint64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x8_t vsra_n_u8(uint8x8_t, uint8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES poly16x4_t vsri_n_p16(poly16x4_t, poly16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES poly8x8_t vsri_n_p8(poly8x8_t, poly8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x4_t vsri_n_s16(int16x4_t, int16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vsri_n_s32(int32x2_t, int32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x1_t vsri_n_s64(int64x1_t, int64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x8_t vsri_n_s8(int8x8_t, int8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vsri_n_u16(uint16x4_t, uint16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vsri_n_u32(uint32x2_t, uint32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x1_t vsri_n_u64(uint64x1_t, uint64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x8_t vsri_n_u8(uint8x8_t, uint8x8_t, int __constrange(1,8));

// SECTION:acc_binop_const_q:128:rt(p,p,cw0)
__IEFF_NE __ATTRIBUTES poly16x8_t vsliq_n_p16(poly16x8_t, poly16x8_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES poly8x16_t vsliq_n_p8(poly8x16_t, poly8x16_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x8_t vsliq_n_s16(int16x8_t, int16x8_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int32x4_t vsliq_n_s32(int32x4_t, int32x4_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES int64x2_t vsliq_n_s64(int64x2_t, int64x2_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES int8x16_t vsliq_n_s8(int8x16_t, int8x16_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x8_t vsliq_n_u16(uint16x8_t, uint16x8_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint32x4_t vsliq_n_u32(uint32x4_t, uint32x4_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES uint64x2_t vsliq_n_u64(uint64x2_t, uint64x2_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES uint8x16_t vsliq_n_u8(uint8x16_t, uint8x16_t, int __constrange(0,7));

// SECTION:acc_binop_const_q:128:rt(p,p,cw1)
__IEFF_NE __ATTRIBUTES int16x8_t vrsraq_n_s16(int16x8_t, int16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x4_t vrsraq_n_s32(int32x4_t, int32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x2_t vrsraq_n_s64(int64x2_t, int64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x16_t vrsraq_n_s8(int8x16_t, int8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x8_t vrsraq_n_u16(uint16x8_t, uint16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x4_t vrsraq_n_u32(uint32x4_t, uint32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x2_t vrsraq_n_u64(uint64x2_t, uint64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x16_t vrsraq_n_u8(uint8x16_t, uint8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x8_t vsraq_n_s16(int16x8_t, int16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x4_t vsraq_n_s32(int32x4_t, int32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x2_t vsraq_n_s64(int64x2_t, int64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x16_t vsraq_n_s8(int8x16_t, int8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x8_t vsraq_n_u16(uint16x8_t, uint16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x4_t vsraq_n_u32(uint32x4_t, uint32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x2_t vsraq_n_u64(uint64x2_t, uint64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x16_t vsraq_n_u8(uint8x16_t, uint8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES poly16x8_t vsriq_n_p16(poly16x8_t, poly16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES poly8x16_t vsriq_n_p8(poly8x16_t, poly8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x8_t vsriq_n_s16(int16x8_t, int16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x4_t vsriq_n_s32(int32x4_t, int32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x2_t vsriq_n_s64(int64x2_t, int64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x16_t vsriq_n_s8(int8x16_t, int8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x8_t vsriq_n_u16(uint16x8_t, uint16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x4_t vsriq_n_u32(uint32x4_t, uint32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x2_t vsriq_n_u64(uint64x2_t, uint64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x16_t vsriq_n_u8(uint8x16_t, uint8x16_t, int __constrange(1,8));

// SECTION:acc_binop_l:64:rt+1(p+1,p,p)
__IEFF_NE __ATTRIBUTES int32x4_t vabal_s16(int32x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vabal_s32(int64x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vabal_s8(int16x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vabal_u16(uint32x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vabal_u32(uint64x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vabal_u8(uint16x8_t, uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlal_s16(int32x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmlal_s32(int64x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmlal_s8(int16x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlal_u16(uint32x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmlal_u32(uint64x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmlal_u8(uint16x8_t, uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlsl_s16(int32x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmlsl_s32(int64x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmlsl_s8(int16x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlsl_u16(uint32x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmlsl_u32(uint64x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmlsl_u8(uint16x8_t, uint8x8_t, uint8x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmlal_s16(int32x4_t, int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqdmlal_s32(int64x2_t, int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmlsl_s16(int32x4_t, int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqdmlsl_s32(int64x2_t, int32x2_t, int32x2_t);

// SECTION:acc_binop_l_lane:64:rt+1(p+1,p,p,ca)
__IEFF_NE __ATTRIBUTES int32x4_t vmlal_lane_s16(int32x4_t, int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int64x2_t vmlal_lane_s32(int64x2_t, int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint32x4_t vmlal_lane_u16(uint32x4_t, uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint64x2_t vmlal_lane_u32(uint64x2_t, uint32x2_t, uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int32x4_t vmlsl_lane_s16(int32x4_t, int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int64x2_t vmlsl_lane_s32(int64x2_t, int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint32x4_t vmlsl_lane_u16(uint32x4_t, uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint64x2_t vmlsl_lane_u32(uint64x2_t, uint32x2_t, uint32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int32x4_t vqdmlal_lane_s16(int32x4_t, int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int64x2_t vqdmlal_lane_s32(int64x2_t, int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int32x4_t vqdmlsl_lane_s16(int32x4_t, int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int64x2_t vqdmlsl_lane_s32(int64x2_t, int32x2_t, int32x2_t, int __constrange(0,1));

// SECTION:acc_binop_l_part:64:rt+1(p+1,p,ps)
__IEFF_NE __ATTRIBUTES int32x4_t vmlal_n_s16(int32x4_t, int16x4_t, int16_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmlal_n_s32(int64x2_t, int32x2_t, int32_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlal_n_u16(uint32x4_t, uint16x4_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmlal_n_u32(uint64x2_t, uint32x2_t, uint32_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlsl_n_s16(int32x4_t, int16x4_t, int16_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmlsl_n_s32(int64x2_t, int32x2_t, int32_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlsl_n_u16(uint32x4_t, uint16x4_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmlsl_n_u32(uint64x2_t, uint32x2_t, uint32_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmlal_n_s16(int32x4_t, int16x4_t, int16_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqdmlal_n_s32(int64x2_t, int32x2_t, int32_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmlsl_n_s16(int32x4_t, int16x4_t, int16_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqdmlsl_n_s32(int64x2_t, int32x2_t, int32_t);

// SECTION:acc_binop_lane:64:rt(p,p,p,ca)
__IEFF_NE __ATTRIBUTES float32x2_t vmla_lane_f32(float32x2_t, float32x2_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int16x4_t vmla_lane_s16(int16x4_t, int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x2_t vmla_lane_s32(int32x2_t, int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint16x4_t vmla_lane_u16(uint16x4_t, uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x2_t vmla_lane_u32(uint32x2_t, uint32x2_t, uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES float32x2_t vmls_lane_f32(float32x2_t, float32x2_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int16x4_t vmls_lane_s16(int16x4_t, int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x2_t vmls_lane_s32(int32x2_t, int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint16x4_t vmls_lane_u16(uint16x4_t, uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x2_t vmls_lane_u32(uint32x2_t, uint32x2_t, uint32x2_t, int __constrange(0,1));

// SECTION:acc_binop_part:64:rt(p,p,ps)
__IEFF_NE __ATTRIBUTES float32x2_t vmla_n_f32(float32x2_t, float32x2_t, float32_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmla_n_s16(int16x4_t, int16x4_t, int16_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmla_n_s32(int32x2_t, int32x2_t, int32_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmla_n_u16(uint16x4_t, uint16x4_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmla_n_u32(uint32x2_t, uint32x2_t, uint32_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmls_n_f32(float32x2_t, float32x2_t, float32_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmls_n_s16(int16x4_t, int16x4_t, int16_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmls_n_s32(int32x2_t, int32x2_t, int32_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmls_n_u16(uint16x4_t, uint16x4_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmls_n_u32(uint32x2_t, uint32x2_t, uint32_t);

// SECTION:acc_binop_q:128:rt(p,p,p)
__IEFF_NE __ATTRIBUTES int16x8_t vabaq_s16(int16x8_t, int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vabaq_s32(int32x4_t, int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vabaq_s8(int8x16_t, int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vabaq_u16(uint16x8_t, uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vabaq_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vabaq_u8(uint8x16_t, uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vfmaq_f32(float32x4_t, float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vfmsq_f32(float32x4_t, float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmlaq_f32(float32x4_t, float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmlaq_s16(int16x8_t, int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlaq_s32(int32x4_t, int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vmlaq_s8(int8x16_t, int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmlaq_u16(uint16x8_t, uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlaq_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vmlaq_u8(uint8x16_t, uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmlsq_f32(float32x4_t, float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmlsq_s16(int16x8_t, int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlsq_s32(int32x4_t, int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vmlsq_s8(int8x16_t, int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmlsq_u16(uint16x8_t, uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlsq_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vmlsq_u8(uint8x16_t, uint8x16_t, uint8x16_t);

// SECTION:acc_binop_q_lane:128:rt(p,p,ph,cah)
__IEFF_NE __ATTRIBUTES float32x4_t vmlaq_lane_f32(float32x4_t, float32x4_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int16x8_t vmlaq_lane_s16(int16x8_t, int16x8_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x4_t vmlaq_lane_s32(int32x4_t, int32x4_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint16x8_t vmlaq_lane_u16(uint16x8_t, uint16x8_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x4_t vmlaq_lane_u32(uint32x4_t, uint32x4_t, uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES float32x4_t vmlsq_lane_f32(float32x4_t, float32x4_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int16x8_t vmlsq_lane_s16(int16x8_t, int16x8_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x4_t vmlsq_lane_s32(int32x4_t, int32x4_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint16x8_t vmlsq_lane_u16(uint16x8_t, uint16x8_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x4_t vmlsq_lane_u32(uint32x4_t, uint32x4_t, uint32x2_t, int __constrange(0,1));

// SECTION:acc_binop_q_part:128:rt(p,p,ps)
__IEFF_NE __ATTRIBUTES float32x4_t vmlaq_n_f32(float32x4_t, float32x4_t, float32_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmlaq_n_s16(int16x8_t, int16x8_t, int16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlaq_n_s32(int32x4_t, int32x4_t, int32_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmlaq_n_u16(uint16x8_t, uint16x8_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlaq_n_u32(uint32x4_t, uint32x4_t, uint32_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmlsq_n_f32(float32x4_t, float32x4_t, float32_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmlsq_n_s16(int16x8_t, int16x8_t, int16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmlsq_n_s32(int32x4_t, int32x4_t, int32_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmlsq_n_u16(uint16x8_t, uint16x8_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmlsq_n_u32(uint32x4_t, uint32x4_t, uint32_t);

// SECTION:acc_unaop:128:rt(p,p)
__IEFF_NE __ATTRIBUTES uint8x16_t vaesdq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vaeseq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha1su1q_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha256su0q_u32(uint32x4_t, uint32x4_t);

// SECTION:acc_unaop:128:rtp1(pp1,p)
__IEFF_NE __ATTRIBUTES int32x4_t vpadalq_s16(int32x4_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int64x2_t vpadalq_s32(int64x2_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vpadalq_s8(int16x8_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vpadalq_u16(uint32x4_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vpadalq_u32(uint64x2_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vpadalq_u8(uint16x8_t, uint8x16_t);

// SECTION:acc_unaop:64:rtp1(pp1,p)
__IEFF_NE __ATTRIBUTES int32x2_t vpadal_s16(int32x2_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vpadal_s32(int64x1_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vpadal_s8(int16x4_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vpadal_u16(uint32x2_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vpadal_u32(uint64x1_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vpadal_u8(uint16x4_t, uint8x8_t);

// SECTION:binop:64:rt(p,p)
__IEFF_NE __ATTRIBUTES float32x2_t vabd_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vabd_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vabd_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vabd_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vabd_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vabd_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vabd_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vadd_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vadd_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vadd_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vadd_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vadd_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vadd_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vadd_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vadd_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vadd_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vand_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vand_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vand_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vand_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vand_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vand_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vand_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vand_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t veor_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t veor_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t veor_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t veor_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t veor_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t veor_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t veor_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t veor_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vhadd_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vhadd_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vhadd_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vhadd_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vhadd_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vhadd_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vhsub_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vhsub_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vhsub_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vhsub_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vhsub_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vhsub_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmax_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmax_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmax_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmax_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmax_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmax_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmax_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmaxnm_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmin_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmin_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmin_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmin_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmin_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmin_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmin_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vminnm_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmul_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vmul_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmul_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmul_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmul_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmul_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmul_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmul_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vorn_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vorn_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vorn_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vorn_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vorn_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vorn_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vorn_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vorn_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vorr_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vorr_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vorr_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vorr_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vorr_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vorr_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vorr_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vorr_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vpadd_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vpadd_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vpadd_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vpadd_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vpadd_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vpadd_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vpadd_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vpmax_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vpmax_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vpmax_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vpmax_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vpmax_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vpmax_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vpmax_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vpmin_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vpmin_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vpmin_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vpmin_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vpmin_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vpmin_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vpmin_u8(uint8x8_t, uint8x8_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqadd_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqadd_s32(int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int64x1_t vqadd_s64(int64x1_t, int64x1_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqadd_s8(int8x8_t, int8x8_t);
__IEFF_HS __ATTRIBUTES uint16x4_t vqadd_u16(uint16x4_t, uint16x4_t);
__IEFF_HS __ATTRIBUTES uint32x2_t vqadd_u32(uint32x2_t, uint32x2_t);
__IEFF_HS __ATTRIBUTES uint64x1_t vqadd_u64(uint64x1_t, uint64x1_t);
__IEFF_HS __ATTRIBUTES uint8x8_t vqadd_u8(uint8x8_t, uint8x8_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqdmulh_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqdmulh_s32(int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqrdmulh_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqrdmulh_s32(int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqsub_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqsub_s32(int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int64x1_t vqsub_s64(int64x1_t, int64x1_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqsub_s8(int8x8_t, int8x8_t);
__IEFF_HS __ATTRIBUTES uint16x4_t vqsub_u16(uint16x4_t, uint16x4_t);
__IEFF_HS __ATTRIBUTES uint32x2_t vqsub_u32(uint32x2_t, uint32x2_t);
__IEFF_HS __ATTRIBUTES uint64x1_t vqsub_u64(uint64x1_t, uint64x1_t);
__IEFF_HS __ATTRIBUTES uint8x8_t vqsub_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrecps_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vrhadd_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vrhadd_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vrhadd_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vrhadd_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vrhadd_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vrhadd_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrsqrts_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vsub_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vsub_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vsub_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vsub_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vsub_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vsub_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vsub_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vsub_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vsub_u8(uint8x8_t, uint8x8_t);

// SECTION:binop:64:rt(p,pbic)
__IEFF_NE __ATTRIBUTES int16x4_t vbic_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vbic_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vbic_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vbic_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vbic_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vbic_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vbic_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vbic_u8(uint8x8_t, uint8x8_t);

// SECTION:binop:64:rt(p,psi)
__IEFF_HS __ATTRIBUTES int16x4_t vqrshl_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqrshl_s32(int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int64x1_t vqrshl_s64(int64x1_t, int64x1_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqrshl_s8(int8x8_t, int8x8_t);
__IEFF_HS __ATTRIBUTES uint16x4_t vqrshl_u16(uint16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES uint32x2_t vqrshl_u32(uint32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES uint64x1_t vqrshl_u64(uint64x1_t, int64x1_t);
__IEFF_HS __ATTRIBUTES uint8x8_t vqrshl_u8(uint8x8_t, int8x8_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqshl_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqshl_s32(int32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES int64x1_t vqshl_s64(int64x1_t, int64x1_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqshl_s8(int8x8_t, int8x8_t);
__IEFF_HS __ATTRIBUTES uint16x4_t vqshl_u16(uint16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES uint32x2_t vqshl_u32(uint32x2_t, int32x2_t);
__IEFF_HS __ATTRIBUTES uint64x1_t vqshl_u64(uint64x1_t, int64x1_t);
__IEFF_HS __ATTRIBUTES uint8x8_t vqshl_u8(uint8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vrshl_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vrshl_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vrshl_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vrshl_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vrshl_u16(uint16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vrshl_u32(uint32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vrshl_u64(uint64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vrshl_u8(uint8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vshl_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vshl_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vshl_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vshl_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vshl_u16(uint16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vshl_u32(uint32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vshl_u64(uint64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vshl_u8(uint8x8_t, int8x8_t);

// SECTION:binop:64:rtui(p,p)
__IEFF_NE __ATTRIBUTES uint32x2_t vcage_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcagt_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcale_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcalt_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vceq_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vceq_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vceq_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vceq_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vceq_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vceq_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vceq_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vceq_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcge_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcge_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcge_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcge_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcge_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcge_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcge_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcgt_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcgt_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcgt_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcgt_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcgt_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcgt_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcgt_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcle_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcle_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcle_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcle_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcle_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcle_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcle_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vclt_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vclt_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vclt_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vclt_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vclt_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vclt_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vclt_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtst_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vtst_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vtst_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtst_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vtst_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vtst_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtst_u8(uint8x8_t, uint8x8_t);

// SECTION:binop_const:64:rt(p,cw0)
__IEFF_HS __ATTRIBUTES int16x4_t vqshl_n_s16(int16x4_t, int __constrange(0,15));
__IEFF_HS __ATTRIBUTES int32x2_t vqshl_n_s32(int32x2_t, int __constrange(0,31));
__IEFF_HS __ATTRIBUTES int64x1_t vqshl_n_s64(int64x1_t, int __constrange(0,63));
__IEFF_HS __ATTRIBUTES int8x8_t vqshl_n_s8(int8x8_t, int __constrange(0,7));
__IEFF_HS __ATTRIBUTES uint16x4_t vqshl_n_u16(uint16x4_t, int __constrange(0,15));
__IEFF_HS __ATTRIBUTES uint32x2_t vqshl_n_u32(uint32x2_t, int __constrange(0,31));
__IEFF_HS __ATTRIBUTES uint64x1_t vqshl_n_u64(uint64x1_t, int __constrange(0,63));
__IEFF_HS __ATTRIBUTES uint8x8_t vqshl_n_u8(uint8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x4_t vshl_n_s16(int16x4_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int32x2_t vshl_n_s32(int32x2_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES int64x1_t vshl_n_s64(int64x1_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES int8x8_t vshl_n_s8(int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x4_t vshl_n_u16(uint16x4_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint32x2_t vshl_n_u32(uint32x2_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES uint64x1_t vshl_n_u64(uint64x1_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES uint8x8_t vshl_n_u8(uint8x8_t, int __constrange(0,7));

// SECTION:binop_const:64:rt(p,cw1)
__IEFF_NE __ATTRIBUTES int16x4_t vrshr_n_s16(int16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vrshr_n_s32(int32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x1_t vrshr_n_s64(int64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x8_t vrshr_n_s8(int8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vrshr_n_u16(uint16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vrshr_n_u32(uint32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x1_t vrshr_n_u64(uint64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x8_t vrshr_n_u8(uint8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x4_t vshr_n_s16(int16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vshr_n_s32(int32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x1_t vshr_n_s64(int64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x8_t vshr_n_s8(int8x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vshr_n_u16(uint16x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vshr_n_u32(uint32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x1_t vshr_n_u64(uint64x1_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x8_t vshr_n_u8(uint8x8_t, int __constrange(1,8));

// SECTION:binop_const:64:rtui(p,cw0)
__IEFF_HS __ATTRIBUTES uint16x4_t vqshlu_n_s16(int16x4_t, int __constrange(0,15));
__IEFF_HS __ATTRIBUTES uint32x2_t vqshlu_n_s32(int32x2_t, int __constrange(0,31));
__IEFF_HS __ATTRIBUTES uint64x1_t vqshlu_n_s64(int64x1_t, int __constrange(0,63));
__IEFF_HS __ATTRIBUTES uint8x8_t vqshlu_n_s8(int8x8_t, int __constrange(0,7));

// SECTION:binop_const:64:rzf32(p,cw1)
__IEFF_NE __ATTRIBUTES float32x2_t vcvt_n_f32_s32(int32x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES float32x2_t vcvt_n_f32_u32(uint32x2_t, int __constrange(1,32));

// SECTION:binop_const:64:rzs32(p,cw1)
__IEFF_NE __ATTRIBUTES int32x2_t vcvt_n_s32_f32(float32x2_t, int __constrange(1,32));

// SECTION:binop_const:64:rzu32(p,cw1)
__IEFF_NE __ATTRIBUTES uint32x2_t vcvt_n_u32_f32(float32x2_t, int __constrange(1,32));

// SECTION:binop_const_l:64:rt+1(p,cw0x)
__IEFF_NE __ATTRIBUTES int32x4_t vshll_n_s16(int16x4_t, int __constrange(0,16));
__IEFF_NE __ATTRIBUTES int64x2_t vshll_n_s32(int32x2_t, int __constrange(0,32));
__IEFF_NE __ATTRIBUTES int16x8_t vshll_n_s8(int8x8_t, int __constrange(0,8));
__IEFF_NE __ATTRIBUTES uint32x4_t vshll_n_u16(uint16x4_t, int __constrange(0,16));
__IEFF_NE __ATTRIBUTES uint64x2_t vshll_n_u32(uint32x2_t, int __constrange(0,32));
__IEFF_NE __ATTRIBUTES uint16x8_t vshll_n_u8(uint8x8_t, int __constrange(0,8));

// SECTION:binop_const_n:128:rt-1(p,cwh1)
__IEFF_HS __ATTRIBUTES int8x8_t vqrshrn_n_s16(int16x8_t, int __constrange(1,8));
__IEFF_HS __ATTRIBUTES int16x4_t vqrshrn_n_s32(int32x4_t, int __constrange(1,16));
__IEFF_HS __ATTRIBUTES int32x2_t vqrshrn_n_s64(int64x2_t, int __constrange(1,32));
__IEFF_HS __ATTRIBUTES uint8x8_t vqrshrn_n_u16(uint16x8_t, int __constrange(1,8));
__IEFF_HS __ATTRIBUTES uint16x4_t vqrshrn_n_u32(uint32x4_t, int __constrange(1,16));
__IEFF_HS __ATTRIBUTES uint32x2_t vqrshrn_n_u64(uint64x2_t, int __constrange(1,32));
__IEFF_HS __ATTRIBUTES int8x8_t vqshrn_n_s16(int16x8_t, int __constrange(1,8));
__IEFF_HS __ATTRIBUTES int16x4_t vqshrn_n_s32(int32x4_t, int __constrange(1,16));
__IEFF_HS __ATTRIBUTES int32x2_t vqshrn_n_s64(int64x2_t, int __constrange(1,32));
__IEFF_HS __ATTRIBUTES uint8x8_t vqshrn_n_u16(uint16x8_t, int __constrange(1,8));
__IEFF_HS __ATTRIBUTES uint16x4_t vqshrn_n_u32(uint32x4_t, int __constrange(1,16));
__IEFF_HS __ATTRIBUTES uint32x2_t vqshrn_n_u64(uint64x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int8x8_t vrshrn_n_s16(int16x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x4_t vrshrn_n_s32(int32x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vrshrn_n_s64(int64x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint8x8_t vrshrn_n_u16(uint16x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vrshrn_n_u32(uint32x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vrshrn_n_u64(uint64x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int8x8_t vshrn_n_s16(int16x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x4_t vshrn_n_s32(int32x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x2_t vshrn_n_s64(int64x2_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint8x8_t vshrn_n_u16(uint16x8_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x4_t vshrn_n_u32(uint32x4_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x2_t vshrn_n_u64(uint64x2_t, int __constrange(1,32));

// SECTION:binop_const_n:128:rtui-1(p,cwh1)
__IEFF_HS __ATTRIBUTES uint8x8_t vqrshrun_n_s16(int16x8_t, int __constrange(1,8));
__IEFF_HS __ATTRIBUTES uint16x4_t vqrshrun_n_s32(int32x4_t, int __constrange(1,16));
__IEFF_HS __ATTRIBUTES uint32x2_t vqrshrun_n_s64(int64x2_t, int __constrange(1,32));
__IEFF_HS __ATTRIBUTES uint8x8_t vqshrun_n_s16(int16x8_t, int __constrange(1,8));
__IEFF_HS __ATTRIBUTES uint16x4_t vqshrun_n_s32(int32x4_t, int __constrange(1,16));
__IEFF_HS __ATTRIBUTES uint32x2_t vqshrun_n_s64(int64x2_t, int __constrange(1,32));

// SECTION:binop_const_q:128:rt(p,cw0)
__IEFF_HS __ATTRIBUTES int16x8_t vqshlq_n_s16(int16x8_t, int __constrange(0,15));
__IEFF_HS __ATTRIBUTES int32x4_t vqshlq_n_s32(int32x4_t, int __constrange(0,31));
__IEFF_HS __ATTRIBUTES int64x2_t vqshlq_n_s64(int64x2_t, int __constrange(0,63));
__IEFF_HS __ATTRIBUTES int8x16_t vqshlq_n_s8(int8x16_t, int __constrange(0,7));
__IEFF_HS __ATTRIBUTES uint16x8_t vqshlq_n_u16(uint16x8_t, int __constrange(0,15));
__IEFF_HS __ATTRIBUTES uint32x4_t vqshlq_n_u32(uint32x4_t, int __constrange(0,31));
__IEFF_HS __ATTRIBUTES uint64x2_t vqshlq_n_u64(uint64x2_t, int __constrange(0,63));
__IEFF_HS __ATTRIBUTES uint8x16_t vqshlq_n_u8(uint8x16_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x8_t vshlq_n_s16(int16x8_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int32x4_t vshlq_n_s32(int32x4_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES int64x2_t vshlq_n_s64(int64x2_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES int8x16_t vshlq_n_s8(int8x16_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x8_t vshlq_n_u16(uint16x8_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint32x4_t vshlq_n_u32(uint32x4_t, int __constrange(0,31));
__IEFF_NE __ATTRIBUTES uint64x2_t vshlq_n_u64(uint64x2_t, int __constrange(0,63));
__IEFF_NE __ATTRIBUTES uint8x16_t vshlq_n_u8(uint8x16_t, int __constrange(0,7));

// SECTION:binop_const_q:128:rt(p,cw1)
__IEFF_NE __ATTRIBUTES int16x8_t vrshrq_n_s16(int16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x4_t vrshrq_n_s32(int32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x2_t vrshrq_n_s64(int64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x16_t vrshrq_n_s8(int8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x8_t vrshrq_n_u16(uint16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x4_t vrshrq_n_u32(uint32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x2_t vrshrq_n_u64(uint64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x16_t vrshrq_n_u8(uint8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES int16x8_t vshrq_n_s16(int16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES int32x4_t vshrq_n_s32(int32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES int64x2_t vshrq_n_s64(int64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES int8x16_t vshrq_n_s8(int8x16_t, int __constrange(1,8));
__IEFF_NE __ATTRIBUTES uint16x8_t vshrq_n_u16(uint16x8_t, int __constrange(1,16));
__IEFF_NE __ATTRIBUTES uint32x4_t vshrq_n_u32(uint32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES uint64x2_t vshrq_n_u64(uint64x2_t, int __constrange(1,64));
__IEFF_NE __ATTRIBUTES uint8x16_t vshrq_n_u8(uint8x16_t, int __constrange(1,8));

// SECTION:binop_const_q:128:rtui(p,cw0)
__IEFF_HS __ATTRIBUTES uint16x8_t vqshluq_n_s16(int16x8_t, int __constrange(0,15));
__IEFF_HS __ATTRIBUTES uint32x4_t vqshluq_n_s32(int32x4_t, int __constrange(0,31));
__IEFF_HS __ATTRIBUTES uint64x2_t vqshluq_n_s64(int64x2_t, int __constrange(0,63));
__IEFF_HS __ATTRIBUTES uint8x16_t vqshluq_n_s8(int8x16_t, int __constrange(0,7));

// SECTION:binop_const_q:128:rzf32(p,cw1)
__IEFF_NE __ATTRIBUTES float32x4_t vcvtq_n_f32_s32(int32x4_t, int __constrange(1,32));
__IEFF_NE __ATTRIBUTES float32x4_t vcvtq_n_f32_u32(uint32x4_t, int __constrange(1,32));

// SECTION:binop_const_q:128:rzs32(p,cw1)
__IEFF_NE __ATTRIBUTES int32x4_t vcvtq_n_s32_f32(float32x4_t, int __constrange(1,32));

// SECTION:binop_const_q:128:rzu32(p,cw1)
__IEFF_NE __ATTRIBUTES uint32x4_t vcvtq_n_u32_f32(float32x4_t, int __constrange(1,32));

// SECTION:binop_l:64:rt+1(p,p)
__IEFF_NE __ATTRIBUTES int32x4_t vabdl_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vabdl_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vabdl_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vabdl_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vabdl_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vabdl_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vaddl_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vaddl_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vaddl_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vaddl_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vaddl_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vaddl_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vmull_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmull_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmull_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmull_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmull_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmull_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmull_u8(uint8x8_t, uint8x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmull_s16(int16x4_t, int16x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqdmull_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int32x4_t vsubl_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vsubl_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vsubl_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsubl_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vsubl_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vsubl_u8(uint8x8_t, uint8x8_t);

// SECTION:binop_l_lane:64:rt+1(p,p,ca)
__IEFF_NE __ATTRIBUTES int32x4_t vmull_lane_s16(int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int64x2_t vmull_lane_s32(int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint32x4_t vmull_lane_u16(uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint64x2_t vmull_lane_u32(uint32x2_t, uint32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int32x4_t vqdmull_lane_s16(int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int64x2_t vqdmull_lane_s32(int32x2_t, int32x2_t, int __constrange(0,1));

// SECTION:binop_l_part:64:rt+1(p,ps)
__IEFF_NE __ATTRIBUTES int32x4_t vmull_n_s16(int16x4_t, int16_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmull_n_s32(int32x2_t, int32_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmull_n_u16(uint16x4_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmull_n_u32(uint32x2_t, uint32_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmull_n_s16(int16x4_t, int16_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqdmull_n_s32(int32x2_t, int32_t);

// SECTION:binop_lane:64:rt(p,p,ca)
__IEFF_NE __ATTRIBUTES float32x2_t vmul_lane_f32(float32x2_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int16x4_t vmul_lane_s16(int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x2_t vmul_lane_s32(int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint16x4_t vmul_lane_u16(uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x2_t vmul_lane_u32(uint32x2_t, uint32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int16x4_t vqdmulh_lane_s16(int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int32x2_t vqdmulh_lane_s32(int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int16x4_t vqrdmulh_lane_s16(int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int32x2_t vqrdmulh_lane_s32(int32x2_t, int32x2_t, int __constrange(0,1));

// SECTION:binop_n:128:rt-1(p,p)
__IEFF_NE __ATTRIBUTES int8x8_t vaddhn_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vaddhn_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vaddhn_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vaddhn_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vaddhn_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vaddhn_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vraddhn_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vraddhn_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vraddhn_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vraddhn_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vraddhn_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vraddhn_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vrsubhn_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vrsubhn_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vrsubhn_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vrsubhn_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vrsubhn_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vrsubhn_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vsubhn_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vsubhn_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vsubhn_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vsubhn_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vsubhn_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vsubhn_u64(uint64x2_t, uint64x2_t);

// SECTION:binop_part:64:rt(p,ps)
__IEFF_NE __ATTRIBUTES float32x2_t vmul_n_f32(float32x2_t, float32_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmul_n_s16(int16x4_t, int16_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmul_n_s32(int32x2_t, int32_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmul_n_u16(uint16x4_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmul_n_u32(uint32x2_t, uint32_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqdmulh_n_s16(int16x4_t, int16_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqdmulh_n_s32(int32x2_t, int32_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqrdmulh_n_s16(int16x4_t, int16_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqrdmulh_n_s32(int32x2_t, int32_t);

// SECTION:binop_q:128:rt(p,p)
__IEFF_NE __ATTRIBUTES float32x4_t vabdq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vabdq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vabdq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vabdq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vabdq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vabdq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vabdq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vaddq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vaddq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vaddq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vaddq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vaddq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vaddq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vaddq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vaddq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vaddq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vandq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vandq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vandq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vandq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vandq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vandq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vandq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vandq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t veorq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t veorq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t veorq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t veorq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t veorq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t veorq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t veorq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t veorq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vhaddq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vhaddq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vhaddq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vhaddq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vhaddq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vhaddq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vhsubq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vhsubq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vhsubq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vhsubq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vhsubq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vhsubq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmaxnmq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmaxq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmaxq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmaxq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vmaxq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmaxq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmaxq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vmaxq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vminnmq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vminq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vminq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vminq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vminq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vminq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vminq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vminq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmulq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vmulq_p8(poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmulq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmulq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vmulq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmulq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmulq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vmulq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vornq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vornq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vornq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vornq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vornq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vornq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vornq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vornq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vorrq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vorrq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vorrq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vorrq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vorrq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vorrq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vorrq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vorrq_u8(uint8x16_t, uint8x16_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqaddq_s16(int16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqaddq_s32(int32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqaddq_s64(int64x2_t, int64x2_t);
__IEFF_HS __ATTRIBUTES int8x16_t vqaddq_s8(int8x16_t, int8x16_t);
__IEFF_HS __ATTRIBUTES uint16x8_t vqaddq_u16(uint16x8_t, uint16x8_t);
__IEFF_HS __ATTRIBUTES uint32x4_t vqaddq_u32(uint32x4_t, uint32x4_t);
__IEFF_HS __ATTRIBUTES uint64x2_t vqaddq_u64(uint64x2_t, uint64x2_t);
__IEFF_HS __ATTRIBUTES uint8x16_t vqaddq_u8(uint8x16_t, uint8x16_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqdmulhq_s16(int16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmulhq_s32(int32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqrdmulhq_s16(int16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqrdmulhq_s32(int32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqsubq_s16(int16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqsubq_s32(int32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqsubq_s64(int64x2_t, int64x2_t);
__IEFF_HS __ATTRIBUTES int8x16_t vqsubq_s8(int8x16_t, int8x16_t);
__IEFF_HS __ATTRIBUTES uint16x8_t vqsubq_u16(uint16x8_t, uint16x8_t);
__IEFF_HS __ATTRIBUTES uint32x4_t vqsubq_u32(uint32x4_t, uint32x4_t);
__IEFF_HS __ATTRIBUTES uint64x2_t vqsubq_u64(uint64x2_t, uint64x2_t);
__IEFF_HS __ATTRIBUTES uint8x16_t vqsubq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrecpsq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vrhaddq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vrhaddq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vrhaddq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vrhaddq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vrhaddq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vrhaddq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrsqrtsq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vsubq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vsubq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vsubq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vsubq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vsubq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vsubq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsubq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vsubq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vsubq_u8(uint8x16_t, uint8x16_t);

// SECTION:binop_q:128:rt(p,pbic)
__IEFF_NE __ATTRIBUTES int16x8_t vbicq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vbicq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vbicq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vbicq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vbicq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vbicq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vbicq_u64(uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vbicq_u8(uint8x16_t, uint8x16_t);

// SECTION:binop_q:128:rt(p,psi)
__IEFF_HS __ATTRIBUTES int16x8_t vqrshlq_s16(int16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqrshlq_s32(int32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqrshlq_s64(int64x2_t, int64x2_t);
__IEFF_HS __ATTRIBUTES int8x16_t vqrshlq_s8(int8x16_t, int8x16_t);
__IEFF_HS __ATTRIBUTES uint16x8_t vqrshlq_u16(uint16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES uint32x4_t vqrshlq_u32(uint32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES uint64x2_t vqrshlq_u64(uint64x2_t, int64x2_t);
__IEFF_HS __ATTRIBUTES uint8x16_t vqrshlq_u8(uint8x16_t, int8x16_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqshlq_s16(int16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqshlq_s32(int32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES int64x2_t vqshlq_s64(int64x2_t, int64x2_t);
__IEFF_HS __ATTRIBUTES int8x16_t vqshlq_s8(int8x16_t, int8x16_t);
__IEFF_HS __ATTRIBUTES uint16x8_t vqshlq_u16(uint16x8_t, int16x8_t);
__IEFF_HS __ATTRIBUTES uint32x4_t vqshlq_u32(uint32x4_t, int32x4_t);
__IEFF_HS __ATTRIBUTES uint64x2_t vqshlq_u64(uint64x2_t, int64x2_t);
__IEFF_HS __ATTRIBUTES uint8x16_t vqshlq_u8(uint8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vrshlq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vrshlq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vrshlq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vrshlq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vrshlq_u16(uint16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vrshlq_u32(uint32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vrshlq_u64(uint64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vrshlq_u8(uint8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vshlq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vshlq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vshlq_s64(int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vshlq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vshlq_u16(uint16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vshlq_u32(uint32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vshlq_u64(uint64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vshlq_u8(uint8x16_t, int8x16_t);

// SECTION:binop_q:128:rtui(p,p)
__IEFF_NE __ATTRIBUTES uint32x4_t vcageq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcagtq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcaleq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcaltq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vceqq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vceqq_p8(poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vceqq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vceqq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vceqq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vceqq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vceqq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vceqq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcgeq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcgeq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcgeq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcgeq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcgeq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcgeq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcgeq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcgtq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcgtq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcgtq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcgtq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcgtq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcgtq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcgtq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcleq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcleq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcleq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcleq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcleq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcleq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcleq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcltq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcltq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcltq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcltq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcltq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcltq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcltq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vtstq_p8(poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vtstq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vtstq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vtstq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vtstq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vtstq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vtstq_u8(uint8x16_t, uint8x16_t);

// SECTION:binop_q_lane:128:rt(p,ph,cah)
__IEFF_NE __ATTRIBUTES float32x4_t vmulq_lane_f32(float32x4_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int16x8_t vmulq_lane_s16(int16x8_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x4_t vmulq_lane_s32(int32x4_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint16x8_t vmulq_lane_u16(uint16x8_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x4_t vmulq_lane_u32(uint32x4_t, uint32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int16x8_t vqdmulhq_lane_s16(int16x8_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int32x4_t vqdmulhq_lane_s32(int32x4_t, int32x2_t, int __constrange(0,1));
__IEFF_HS __ATTRIBUTES int16x8_t vqrdmulhq_lane_s16(int16x8_t, int16x4_t, int __constrange(0,3));
__IEFF_HS __ATTRIBUTES int32x4_t vqrdmulhq_lane_s32(int32x4_t, int32x2_t, int __constrange(0,1));

// SECTION:binop_q_part:128:rt(p,ps)
__IEFF_NE __ATTRIBUTES float32x4_t vmulq_n_f32(float32x4_t, float32_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmulq_n_s16(int16x8_t, int16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmulq_n_s32(int32x4_t, int32_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmulq_n_u16(uint16x8_t, uint16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmulq_n_u32(uint32x4_t, uint32_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqdmulhq_n_s16(int16x8_t, int16_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqdmulhq_n_s32(int32x4_t, int32_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqrdmulhq_n_s16(int16x8_t, int16_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqrdmulhq_n_s32(int32x4_t, int32_t);

// SECTION:binop_w:64:rt+1(p+1,p)
__IEFF_NE __ATTRIBUTES int32x4_t vaddw_s16(int32x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vaddw_s32(int64x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vaddw_s8(int16x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vaddw_u16(uint32x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vaddw_u32(uint64x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vaddw_u8(uint16x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vsubw_s16(int32x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vsubw_s32(int64x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vsubw_s8(int16x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsubw_u16(uint32x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vsubw_u32(uint64x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vsubw_u8(uint16x8_t, uint8x8_t);

// SECTION:combine:128:rt(ph,ph)
__IEFF_NE __ATTRIBUTES float16x8_t vcombine_f16(float16x4_t, float16x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vcombine_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vcombine_p16(poly16x4_t, poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vcombine_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x8_t vcombine_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vcombine_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x2_t vcombine_s64(int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x16_t vcombine_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vcombine_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcombine_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vcombine_u64(uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcombine_u8(uint8x8_t, uint8x8_t);

// SECTION:copy_lane:64:rt(p,ca)
__IEFF_NE __ATTRIBUTES float16x4_t vdup_lane_f16(float16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES float32x2_t vdup_lane_f32(float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES poly16x4_t vdup_lane_p16(poly16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly8x8_t vdup_lane_p8(poly8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x4_t vdup_lane_s16(int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x2_t vdup_lane_s32(int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int64x1_t vdup_lane_s64(int64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES int8x8_t vdup_lane_s8(int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x4_t vdup_lane_u16(uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x2_t vdup_lane_u32(uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint64x1_t vdup_lane_u64(uint64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES uint8x8_t vdup_lane_u8(uint8x8_t, int __constrange(0,7));

// SECTION:copy_q_lane:128:rt(ph,cah)
__IEFF_NE __ATTRIBUTES float16x8_t vdupq_lane_f16(float16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES float32x4_t vdupq_lane_f32(float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES poly16x8_t vdupq_lane_p16(poly16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly8x16_t vdupq_lane_p8(poly8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x8_t vdupq_lane_s16(int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x4_t vdupq_lane_s32(int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int64x2_t vdupq_lane_s64(int64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES int8x16_t vdupq_lane_s8(int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x8_t vdupq_lane_u16(uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x4_t vdupq_lane_u32(uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint64x2_t vdupq_lane_u64(uint64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES uint8x16_t vdupq_lane_u8(uint8x8_t, int __constrange(0,7));

// SECTION:create:64:rt(psmv)
__IEFF_NE __ATTRIBUTES float16x4_t vdup_n_f16(float16_t);
__IEFF_NE __ATTRIBUTES float32x2_t vdup_n_f32(float32_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vdup_n_p16(poly16_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vdup_n_p8(poly8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vdup_n_s16(int16_t);
__IEFF_NE __ATTRIBUTES int32x2_t vdup_n_s32(int32_t);
__IEFF_NE __ATTRIBUTES int8x8_t vdup_n_s8(int8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vdup_n_u16(uint16_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vdup_n_u32(uint32_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vdup_n_u8(uint8_t);
__IEFF_NE __ATTRIBUTES float16x4_t vmov_n_f16(float16_t);
__IEFF_NE __ATTRIBUTES float32x2_t vmov_n_f32(float32_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vmov_n_p16(poly16_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vmov_n_p8(poly8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmov_n_s16(int16_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmov_n_s32(int32_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmov_n_s8(int8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmov_n_u16(uint16_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmov_n_u32(uint32_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmov_n_u8(uint8_t);

// SECTION:create_64:64:rt(psmv)
__IEFF_NE __ATTRIBUTES int64x1_t vdup_n_s64(int64_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vdup_n_u64(uint64_t);
__IEFF_NE __ATTRIBUTES int64x1_t vmov_n_s64(int64_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vmov_n_u64(uint64_t);

// SECTION:create_64:64:rt(pu64)
__IEFF_NE __ATTRIBUTES float16x4_t vcreate_f16(uint64_t);
__IEFF_NE __ATTRIBUTES float32x2_t vcreate_f32(uint64_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vcreate_p16(uint64_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vcreate_p8(uint64_t);
__IEFF_NE __ATTRIBUTES int16x4_t vcreate_s16(uint64_t);
__IEFF_NE __ATTRIBUTES int32x2_t vcreate_s32(uint64_t);
__IEFF_NE __ATTRIBUTES int64x1_t vcreate_s64(uint64_t);
__IEFF_NE __ATTRIBUTES int8x8_t vcreate_s8(uint64_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vcreate_u16(uint64_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcreate_u32(uint64_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vcreate_u64(uint64_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcreate_u8(uint64_t);

// SECTION:create_q:128:rt(psmv)
__IEFF_NE __ATTRIBUTES float16x8_t vdupq_n_f16(float16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vdupq_n_f32(float32_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vdupq_n_p16(poly16_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vdupq_n_p8(poly8_t);
__IEFF_NE __ATTRIBUTES int16x8_t vdupq_n_s16(int16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vdupq_n_s32(int32_t);
__IEFF_NE __ATTRIBUTES int8x16_t vdupq_n_s8(int8_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vdupq_n_u16(uint16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vdupq_n_u32(uint32_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vdupq_n_u8(uint8_t);
__IEFF_NE __ATTRIBUTES float16x8_t vmovq_n_f16(float16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vmovq_n_f32(float32_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vmovq_n_p16(poly16_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vmovq_n_p8(poly8_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmovq_n_s16(int16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmovq_n_s32(int32_t);
__IEFF_NE __ATTRIBUTES int8x16_t vmovq_n_s8(int8_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmovq_n_u16(uint16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmovq_n_u32(uint32_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vmovq_n_u8(uint8_t);

// SECTION:create_q_64:128:rt(psmv)
__IEFF_NE __ATTRIBUTES int64x2_t vdupq_n_s64(int64_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vdupq_n_u64(uint64_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmovq_n_s64(int64_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmovq_n_u64(uint64_t);

// SECTION:extract:64:rt(p,p,ca)
__IEFF_NE __ATTRIBUTES float16x4_t vext_f16(float16x4_t, float16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES float32x2_t vext_f32(float32x2_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES poly16x4_t vext_p16(poly16x4_t, poly16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly8x8_t vext_p8(poly8x8_t, poly8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x4_t vext_s16(int16x4_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x2_t vext_s32(int32x2_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int64x1_t vext_s64(int64x1_t, int64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES int8x8_t vext_s8(int8x8_t, int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x4_t vext_u16(uint16x4_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x2_t vext_u32(uint32x2_t, uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint64x1_t vext_u64(uint64x1_t, uint64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES uint8x8_t vext_u8(uint8x8_t, uint8x8_t, int __constrange(0,7));

// SECTION:extract_q:128:rt(p,p,ca)
__IEFF_NE __ATTRIBUTES float16x8_t vextq_f16(float16x8_t, float16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES float32x4_t vextq_f32(float32x4_t, float32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly16x8_t vextq_p16(poly16x8_t, poly16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES poly8x16_t vextq_p8(poly8x16_t, poly8x16_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int16x8_t vextq_s16(int16x8_t, int16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int32x4_t vextq_s32(int32x4_t, int32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int64x2_t vextq_s64(int64x2_t, int64x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int8x16_t vextq_s8(int8x16_t, int8x16_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint16x8_t vextq_u16(uint16x8_t, uint16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint32x4_t vextq_u32(uint32x4_t, uint32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint64x2_t vextq_u64(uint64x2_t, uint64x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint8x16_t vextq_u8(uint8x16_t, uint8x16_t, int __constrange(0,15));

// SECTION:get_high:64:rt(pw)
__IEFF_NE __ATTRIBUTES float16x4_t vget_high_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vget_high_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vget_high_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vget_high_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x4_t vget_high_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x2_t vget_high_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vget_high_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vget_high_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vget_high_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vget_high_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vget_high_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vget_high_u8(uint8x16_t);

// SECTION:get_lane:64:rts(p,ca)
__IEFF_NE __ATTRIBUTES float16_t vget_lane_f16(float16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES float32_t vget_lane_f32(float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES poly16_t vget_lane_p16(poly16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly8_t vget_lane_p8(poly8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16_t vget_lane_s16(int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32_t vget_lane_s32(int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int8_t vget_lane_s8(int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16_t vget_lane_u16(uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32_t vget_lane_u32(uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint8_t vget_lane_u8(uint8x8_t, int __constrange(0,7));

// SECTION:get_lane_64:64:rts(p,ca)
__IEFF_NE __ATTRIBUTES int64_t vget_lane_s64(int64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES uint64_t vget_lane_u64(uint64x1_t, int __constrange(0,0));

// SECTION:get_low:64:rt(pw)
__IEFF_NE __ATTRIBUTES float16x4_t vget_low_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vget_low_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vget_low_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vget_low_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x4_t vget_low_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x2_t vget_low_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vget_low_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vget_low_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vget_low_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vget_low_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vget_low_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vget_low_u8(uint8x16_t);

// SECTION:get_q_lane:128:rts(p,ca)
__IEFF_NE __ATTRIBUTES float16_t vgetq_lane_f16(float16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES float32_t vgetq_lane_f32(float32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly16_t vgetq_lane_p16(poly16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES poly8_t vgetq_lane_p8(poly8x16_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int16_t vgetq_lane_s16(int16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int32_t vgetq_lane_s32(int32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int8_t vgetq_lane_s8(int8x16_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint16_t vgetq_lane_u16(uint16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint32_t vgetq_lane_u32(uint32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint8_t vgetq_lane_u8(uint8x16_t, int __constrange(0,15));

// SECTION:get_q_lane_64:128:rts(p,ca)
__IEFF_NE __ATTRIBUTES int64_t vgetq_lane_s64(int64x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint64_t vgetq_lane_u64(uint64x2_t, int __constrange(0,1));

// SECTION:reinterpret:64:rzf16(p)
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES float16x4_t vreinterpret_f16_u8(uint8x8_t);

// SECTION:reinterpret:64:rzf32(p)
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES float32x2_t vreinterpret_f32_u8(uint8x8_t);

// SECTION:reinterpret:64:rzp16(p)
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vreinterpret_p16_u8(uint8x8_t);

// SECTION:reinterpret:64:rzp8(p)
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vreinterpret_p8_u8(uint8x8_t);

// SECTION:reinterpret:64:rzs16(p)
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES int16x4_t vreinterpret_s16_u8(uint8x8_t);

// SECTION:reinterpret:64:rzs32(p)
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES int32x2_t vreinterpret_s32_u8(uint8x8_t);

// SECTION:reinterpret:64:rzs64(p)
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES int64x1_t vreinterpret_s64_u8(uint8x8_t);

// SECTION:reinterpret:64:rzs8(p)
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vreinterpret_s8_u8(uint8x8_t);

// SECTION:reinterpret:64:rzu16(p)
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vreinterpret_u16_u8(uint8x8_t);

// SECTION:reinterpret:64:rzu32(p)
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vreinterpret_u32_u8(uint8x8_t);

// SECTION:reinterpret:64:rzu64(p)
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vreinterpret_u64_u8(uint8x8_t);

// SECTION:reinterpret:64:rzu8(p)
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vreinterpret_u8_u64(uint64x1_t);

// SECTION:reinterpret_q:128:rzf16(p)
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES float16x8_t vreinterpretq_f16_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzf32(p)
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES float32x4_t vreinterpretq_f32_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzp16(p)
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vreinterpretq_p16_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzp8(p)
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vreinterpretq_p8_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzs16(p)
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vreinterpretq_s16_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzs32(p)
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES int32x4_t vreinterpretq_s32_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzs64(p)
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES int64x2_t vreinterpretq_s64_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzs8(p)
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vreinterpretq_s8_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzu16(p)
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vreinterpretq_u16_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzu32(p)
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vreinterpretq_u32_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzu64(p)
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vreinterpretq_u64_u8(uint8x16_t);

// SECTION:reinterpret_q:128:rzu8(p)
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vreinterpretq_u8_u64(uint64x2_t);

// SECTION:set_lane:64:rt(ps,p,ca)
__IEFF_NE __ATTRIBUTES float16x4_t vset_lane_f16(float16_t, float16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES float32x2_t vset_lane_f32(float32_t, float32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES poly16x4_t vset_lane_p16(poly16_t, poly16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly8x8_t vset_lane_p8(poly8_t, poly8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int16x4_t vset_lane_s16(int16_t, int16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int32x2_t vset_lane_s32(int32_t, int32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES int8x8_t vset_lane_s8(int8_t, int8x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint16x4_t vset_lane_u16(uint16_t, uint16x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint32x2_t vset_lane_u32(uint32_t, uint32x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint8x8_t vset_lane_u8(uint8_t, uint8x8_t, int __constrange(0,7));

// SECTION:set_lane_64:64:rt(ps,p,ca)
__IEFF_NE __ATTRIBUTES int64x1_t vset_lane_s64(int64_t, int64x1_t, int __constrange(0,0));
__IEFF_NE __ATTRIBUTES uint64x1_t vset_lane_u64(uint64_t, uint64x1_t, int __constrange(0,0));

// SECTION:set_q_lane:128:rt(ps,p,ca)
__IEFF_NE __ATTRIBUTES float16x8_t vsetq_lane_f16(float16_t, float16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES float32x4_t vsetq_lane_f32(float32_t, float32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES poly16x8_t vsetq_lane_p16(poly16_t, poly16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES poly8x16_t vsetq_lane_p8(poly8_t, poly8x16_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES int16x8_t vsetq_lane_s16(int16_t, int16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES int32x4_t vsetq_lane_s32(int32_t, int32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES int8x16_t vsetq_lane_s8(int8_t, int8x16_t, int __constrange(0,15));
__IEFF_NE __ATTRIBUTES uint16x8_t vsetq_lane_u16(uint16_t, uint16x8_t, int __constrange(0,7));
__IEFF_NE __ATTRIBUTES uint32x4_t vsetq_lane_u32(uint32_t, uint32x4_t, int __constrange(0,3));
__IEFF_NE __ATTRIBUTES uint8x16_t vsetq_lane_u8(uint8_t, uint8x16_t, int __constrange(0,15));

// SECTION:set_q_lane_64:128:rt(ps,p,ca)
__IEFF_NE __ATTRIBUTES int64x2_t vsetq_lane_s64(int64_t, int64x2_t, int __constrange(0,1));
__IEFF_NE __ATTRIBUTES uint64x2_t vsetq_lane_u64(uint64_t, uint64x2_t, int __constrange(0,1));

// SECTION:tbl1:64:rt(p,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbl1_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbl1_u8(uint8x8_t, uint8x8_t);

// SECTION:tbl1:64:rt(p,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbl1_p8(poly8x8_t, uint8x8_t);

// SECTION:tbl1x:64:rt(p,p,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbx1_s8(int8x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbx1_u8(uint8x8_t, uint8x8_t, uint8x8_t);

// SECTION:tbl1x:64:rt(p,p,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbx1_p8(poly8x8_t, poly8x8_t, uint8x8_t);

// SECTION:tbl2:64:rt(px2,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbl2_s8(int8x8x2_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbl2_u8(uint8x8x2_t, uint8x8_t);

// SECTION:tbl2:64:rt(px2,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbl2_p8(poly8x8x2_t, uint8x8_t);

// SECTION:tbl2x:64:rt(p,px2,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbx2_s8(int8x8_t, int8x8x2_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbx2_u8(uint8x8_t, uint8x8x2_t, uint8x8_t);

// SECTION:tbl2x:64:rt(p,px2,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbx2_p8(poly8x8_t, poly8x8x2_t, uint8x8_t);

// SECTION:tbl3:64:rt(px3,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbl3_s8(int8x8x3_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbl3_u8(uint8x8x3_t, uint8x8_t);

// SECTION:tbl3:64:rt(px3,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbl3_p8(poly8x8x3_t, uint8x8_t);

// SECTION:tbl3x:64:rt(p,px3,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbx3_s8(int8x8_t, int8x8x3_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbx3_u8(uint8x8_t, uint8x8x3_t, uint8x8_t);

// SECTION:tbl3x:64:rt(p,px3,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbx3_p8(poly8x8_t, poly8x8x3_t, uint8x8_t);

// SECTION:tbl4:64:rt(px4,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbl4_s8(int8x8x4_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbl4_u8(uint8x8x4_t, uint8x8_t);

// SECTION:tbl4:64:rt(px4,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbl4_p8(poly8x8x4_t, uint8x8_t);

// SECTION:tbl4x:64:rt(p,px4,p)
__IEFF_NE __ATTRIBUTES int8x8_t vtbx4_s8(int8x8_t, int8x8x4_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vtbx4_u8(uint8x8_t, uint8x8x4_t, uint8x8_t);

// SECTION:tbl4x:64:rt(p,px4,pui)
__IEFF_NE __ATTRIBUTES poly8x8_t vtbx4_p8(poly8x8_t, poly8x8x4_t, uint8x8_t);

// SECTION:transpose:64:rtx2(p,p)
__IEFF_NE __ATTRIBUTES float16x4x2_t vtrn_f16(float16x4_t, float16x4_t);
__IEFF_NE __ATTRIBUTES float32x2x2_t vtrn_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4x2_t vtrn_p16(poly16x4_t, poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8x2_t vtrn_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4x2_t vtrn_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2x2_t vtrn_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8x2_t vtrn_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4x2_t vtrn_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2x2_t vtrn_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8x2_t vtrn_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float16x4x2_t vuzp_f16(float16x4_t, float16x4_t);
__IEFF_NE __ATTRIBUTES float32x2x2_t vuzp_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4x2_t vuzp_p16(poly16x4_t, poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8x2_t vuzp_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4x2_t vuzp_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2x2_t vuzp_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8x2_t vuzp_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4x2_t vuzp_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2x2_t vuzp_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8x2_t vuzp_u8(uint8x8_t, uint8x8_t);
__IEFF_NE __ATTRIBUTES float16x4x2_t vzip_f16(float16x4_t, float16x4_t);
__IEFF_NE __ATTRIBUTES float32x2x2_t vzip_f32(float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4x2_t vzip_p16(poly16x4_t, poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8x2_t vzip_p8(poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4x2_t vzip_s16(int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2x2_t vzip_s32(int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8x2_t vzip_s8(int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4x2_t vzip_u16(uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2x2_t vzip_u32(uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8x2_t vzip_u8(uint8x8_t, uint8x8_t);

// SECTION:transpose_q:128:rtx2(p,p)
__IEFF_NE __ATTRIBUTES float16x8x2_t vtrnq_f16(float16x8_t, float16x8_t);
__IEFF_NE __ATTRIBUTES float32x4x2_t vtrnq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8x2_t vtrnq_p16(poly16x8_t, poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16x2_t vtrnq_p8(poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8x2_t vtrnq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4x2_t vtrnq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16x2_t vtrnq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8x2_t vtrnq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4x2_t vtrnq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16x2_t vtrnq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float16x8x2_t vuzpq_f16(float16x8_t, float16x8_t);
__IEFF_NE __ATTRIBUTES float32x4x2_t vuzpq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8x2_t vuzpq_p16(poly16x8_t, poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16x2_t vuzpq_p8(poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8x2_t vuzpq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4x2_t vuzpq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16x2_t vuzpq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8x2_t vuzpq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4x2_t vuzpq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16x2_t vuzpq_u8(uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES float16x8x2_t vzipq_f16(float16x8_t, float16x8_t);
__IEFF_NE __ATTRIBUTES float32x4x2_t vzipq_f32(float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8x2_t vzipq_p16(poly16x8_t, poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16x2_t vzipq_p8(poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8x2_t vzipq_s16(int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4x2_t vzipq_s32(int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16x2_t vzipq_s8(int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8x2_t vzipq_u16(uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4x2_t vzipq_u32(uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16x2_t vzipq_u8(uint8x16_t, uint8x16_t);

// SECTION:triop:64:rt(pui,p,p)
__IEFF_NE __ATTRIBUTES float16x4_t vbsl_f16(uint16x4_t, float16x4_t, float16x4_t);
__IEFF_NE __ATTRIBUTES float32x2_t vbsl_f32(uint32x2_t, float32x2_t, float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vbsl_p16(uint16x4_t, poly16x4_t, poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vbsl_p8(uint8x8_t, poly8x8_t, poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vbsl_s16(uint16x4_t, int16x4_t, int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vbsl_s32(uint32x2_t, int32x2_t, int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vbsl_s64(uint64x1_t, int64x1_t, int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vbsl_s8(uint8x8_t, int8x8_t, int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vbsl_u16(uint16x4_t, uint16x4_t, uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vbsl_u32(uint32x2_t, uint32x2_t, uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vbsl_u64(uint64x1_t, uint64x1_t, uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vbsl_u8(uint8x8_t, uint8x8_t, uint8x8_t);

// SECTION:triop_q:128:rt(pui,p,p)
__IEFF_NE __ATTRIBUTES float16x8_t vbslq_f16(uint16x8_t, float16x8_t, float16x8_t);
__IEFF_NE __ATTRIBUTES float32x4_t vbslq_f32(uint32x4_t, float32x4_t, float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vbslq_p16(uint16x8_t, poly16x8_t, poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vbslq_p8(uint8x16_t, poly8x16_t, poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vbslq_s16(uint16x8_t, int16x8_t, int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vbslq_s32(uint32x4_t, int32x4_t, int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vbslq_s64(uint64x2_t, int64x2_t, int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vbslq_s8(uint8x16_t, int8x16_t, int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vbslq_u16(uint16x8_t, uint16x8_t, uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vbslq_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vbslq_u64(uint64x2_t, uint64x2_t, uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vbslq_u8(uint8x16_t, uint8x16_t, uint8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha1su0q_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha256h2q_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha256hq_u32(uint32x4_t, uint32x4_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha256su1q_u32(uint32x4_t, uint32x4_t, uint32x4_t);

// SECTION:triop_q_sha1:128:rt(p,ps,p)
__IEFF_NE __ATTRIBUTES uint32x4_t vsha1cq_u32(uint32x4_t, uint32_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha1mq_u32(uint32x4_t, uint32_t, uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vsha1pq_u32(uint32x4_t, uint32_t, uint32x4_t);

// SECTION:unaop:64:rt(p)
__IEFF_NE __ATTRIBUTES float32x2_t vabs_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vabs_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vabs_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vabs_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vcls_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vcls_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vcls_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vclz_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vclz_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vclz_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vclz_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vclz_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vclz_u8(uint8x8_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vcnt_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int8x8_t vcnt_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vcnt_u8(uint8x8_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vmvn_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmvn_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmvn_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int64x1_t vmvn_s64(int64x1_t);
__IEFF_NE __ATTRIBUTES int8x8_t vmvn_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmvn_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmvn_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vmvn_u64(uint64x1_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmvn_u8(uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vneg_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vneg_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vneg_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vneg_s8(int8x8_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqabs_s16(int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqabs_s32(int32x2_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqabs_s8(int8x8_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqneg_s16(int16x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqneg_s32(int32x2_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqneg_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrecpe_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vrecpe_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vrev16_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int8x8_t vrev16_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vrev16_u8(uint8x8_t);
__IEFF_NE __ATTRIBUTES float16x4_t vrev32_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vrev32_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vrev32_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int8x8_t vrev32_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vrev32_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vrev32_u8(uint8x8_t);
__IEFF_NE __ATTRIBUTES float16x4_t vrev64_f16(float16x4_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrev64_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES poly16x4_t vrev64_p16(poly16x4_t);
__IEFF_NE __ATTRIBUTES poly8x8_t vrev64_p8(poly8x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vrev64_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vrev64_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int8x8_t vrev64_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vrev64_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vrev64_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vrev64_u8(uint8x8_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrnd_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrnda_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrndm_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrndn_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrndp_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrndx_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vrsqrte_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vrsqrte_u32(uint32x2_t);

// SECTION:unaop:64:rtp1(p)
__IEFF_NE __ATTRIBUTES int32x2_t vpaddl_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int64x1_t vpaddl_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int16x4_t vpaddl_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vpaddl_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x1_t vpaddl_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vpaddl_u8(uint8x8_t);

// SECTION:unaop:64:rzf32(p)
__IEFF_NE __ATTRIBUTES float32x2_t vcvt_f32_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES float32x2_t vcvt_f32_u32(uint32x2_t);

// SECTION:unaop:64:rzs32(p)
__IEFF_NE __ATTRIBUTES int32x2_t vcvt_s32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int32x2_t vcvta_s32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int32x2_t vcvtm_s32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int32x2_t vcvtn_s32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES int32x2_t vcvtp_s32_f32(float32x2_t);

// SECTION:unaop:64:rzu32(p)
__IEFF_NE __ATTRIBUTES uint32x2_t vcvt_u32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcvta_u32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcvtm_u32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcvtn_u32_f32(float32x2_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vcvtp_u32_f32(float32x2_t);

// SECTION:unaop_l:128:rzf32(ph)
__IEFF_NE __ATTRIBUTES float32x4_t vcvt_f32_f16(float16x4_t);

// SECTION:unaop_l:64:rt+1(p)
__IEFF_NE __ATTRIBUTES int32x4_t vmovl_s16(int16x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmovl_s32(int32x2_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmovl_s8(int8x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmovl_u16(uint16x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmovl_u32(uint32x2_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmovl_u8(uint8x8_t);

// SECTION:unaop_n:128:rt-1(p)
__IEFF_NE __ATTRIBUTES int8x8_t vmovn_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int16x4_t vmovn_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int32x2_t vmovn_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES uint8x8_t vmovn_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint16x4_t vmovn_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint32x2_t vmovn_u64(uint64x2_t);
__IEFF_HS __ATTRIBUTES int8x8_t vqmovn_s16(int16x8_t);
__IEFF_HS __ATTRIBUTES int16x4_t vqmovn_s32(int32x4_t);
__IEFF_HS __ATTRIBUTES int32x2_t vqmovn_s64(int64x2_t);
__IEFF_HS __ATTRIBUTES uint8x8_t vqmovn_u16(uint16x8_t);
__IEFF_HS __ATTRIBUTES uint16x4_t vqmovn_u32(uint32x4_t);
__IEFF_HS __ATTRIBUTES uint32x2_t vqmovn_u64(uint64x2_t);

// SECTION:unaop_n:128:rtui-1(p)
__IEFF_HS __ATTRIBUTES uint8x8_t vqmovun_s16(int16x8_t);
__IEFF_HS __ATTRIBUTES uint16x4_t vqmovun_s32(int32x4_t);
__IEFF_HS __ATTRIBUTES uint32x2_t vqmovun_s64(int64x2_t);

// SECTION:unaop_n:64:rzf16(pw)
__IEFF_NE __ATTRIBUTES float16x4_t vcvt_f16_f32(float32x4_t);

// SECTION:unaop_q:128:rt(p)
__IEFF_NE __ATTRIBUTES float32x4_t vabsq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vabsq_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vabsq_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vabsq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vaesimcq_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vaesmcq_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vclsq_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vclsq_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vclsq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vclzq_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vclzq_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vclzq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vclzq_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vclzq_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vclzq_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vcntq_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int8x16_t vcntq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vcntq_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vmvnq_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vmvnq_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vmvnq_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int64x2_t vmvnq_s64(int64x2_t);
__IEFF_NE __ATTRIBUTES int8x16_t vmvnq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vmvnq_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vmvnq_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vmvnq_u64(uint64x2_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vmvnq_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vnegq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vnegq_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vnegq_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vnegq_s8(int8x16_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqabsq_s16(int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqabsq_s32(int32x4_t);
__IEFF_HS __ATTRIBUTES int8x16_t vqabsq_s8(int8x16_t);
__IEFF_HS __ATTRIBUTES int16x8_t vqnegq_s16(int16x8_t);
__IEFF_HS __ATTRIBUTES int32x4_t vqnegq_s32(int32x4_t);
__IEFF_HS __ATTRIBUTES int8x16_t vqnegq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrecpeq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vrecpeq_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vrev16q_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int8x16_t vrev16q_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vrev16q_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES float16x8_t vrev32q_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vrev32q_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vrev32q_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int8x16_t vrev32q_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vrev32q_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vrev32q_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES float16x8_t vrev64q_f16(float16x8_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrev64q_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES poly16x8_t vrev64q_p16(poly16x8_t);
__IEFF_NE __ATTRIBUTES poly8x16_t vrev64q_p8(poly8x16_t);
__IEFF_NE __ATTRIBUTES int16x8_t vrev64q_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int32x4_t vrev64q_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int8x16_t vrev64q_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vrev64q_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vrev64q_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint8x16_t vrev64q_u8(uint8x16_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrndaq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrndmq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrndnq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrndpq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrndq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrndxq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vrsqrteq_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vrsqrteq_u32(uint32x4_t);

// SECTION:unaop_q:128:rtp1(p)
__IEFF_NE __ATTRIBUTES int32x4_t vpaddlq_s16(int16x8_t);
__IEFF_NE __ATTRIBUTES int64x2_t vpaddlq_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES int16x8_t vpaddlq_s8(int8x16_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vpaddlq_u16(uint16x8_t);
__IEFF_NE __ATTRIBUTES uint64x2_t vpaddlq_u32(uint32x4_t);
__IEFF_NE __ATTRIBUTES uint16x8_t vpaddlq_u8(uint8x16_t);

// SECTION:unaop_q:128:rzf32(p)
__IEFF_NE __ATTRIBUTES float32x4_t vcvtq_f32_s32(int32x4_t);
__IEFF_NE __ATTRIBUTES float32x4_t vcvtq_f32_u32(uint32x4_t);

// SECTION:unaop_q:128:rzs32(p)
__IEFF_NE __ATTRIBUTES int32x4_t vcvtaq_s32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vcvtmq_s32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vcvtnq_s32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vcvtpq_s32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES int32x4_t vcvtq_s32_f32(float32x4_t);

// SECTION:unaop_q:128:rzu32(p)
__IEFF_NE __ATTRIBUTES uint32x4_t vcvtaq_u32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcvtmq_u32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcvtnq_u32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcvtpq_u32_f32(float32x4_t);
__IEFF_NE __ATTRIBUTES uint32x4_t vcvtq_u32_f32(float32x4_t);

// SECTION:unaop_q_sha1:128:rts(ps)
__IEFF_NE __ATTRIBUTES uint32_t vsha1h_u32(uint32_t);

// SECTION:vld1:64:rt(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x4_t vld1_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2_t vld1_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4_t vld1_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8_t vld1_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4_t vld1_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2_t vld1_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1_t vld1_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8_t vld1_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4_t vld1_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2_t vld1_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1_t vld1_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8_t vld1_u8(uint8_t const *);
__IEFF_NENW1 __ATTRIBUTES float16x4_t vld1_dup_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2_t vld1_dup_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4_t vld1_dup_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8_t vld1_dup_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4_t vld1_dup_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2_t vld1_dup_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1_t vld1_dup_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8_t vld1_dup_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4_t vld1_dup_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2_t vld1_dup_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1_t vld1_dup_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8_t vld1_dup_u8(uint8_t const *);

// SECTION:vld1_lane:64:rt(ptrc,p,ca)
__IEFF_NENW1 __ATTRIBUTES float16x4_t vld1_lane_f16(float16_t const *, float16x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES float32x2_t vld1_lane_f32(float32_t const *, float32x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES poly16x4_t vld1_lane_p16(poly16_t const *, poly16x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly8x8_t vld1_lane_p8(poly8_t const *, poly8x8_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x4_t vld1_lane_s16(int16_t const *, int16x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES int32x2_t vld1_lane_s32(int32_t const *, int32x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES int64x1_t vld1_lane_s64(int64_t const *, int64x1_t, int __constrange(0,0));
__IEFF_NENW1 __ATTRIBUTES int8x8_t vld1_lane_s8(int8_t const *, int8x8_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint16x4_t vld1_lane_u16(uint16_t const *, uint16x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint32x2_t vld1_lane_u32(uint32_t const *, uint32x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES uint64x1_t vld1_lane_u64(uint64_t const *, uint64x1_t, int __constrange(0,0));
__IEFF_NENW1 __ATTRIBUTES uint8x8_t vld1_lane_u8(uint8_t const *, uint8x8_t, int __constrange(0,7));

// SECTION:vld1_q:128:rt(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x8_t vld1q_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x4_t vld1q_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x8_t vld1q_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x16_t vld1q_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x8_t vld1q_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x4_t vld1q_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x2_t vld1q_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x16_t vld1q_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x8_t vld1q_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x4_t vld1q_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x2_t vld1q_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x16_t vld1q_u8(uint8_t const *);
__IEFF_NENW1 __ATTRIBUTES float16x8_t vld1q_dup_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x4_t vld1q_dup_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x8_t vld1q_dup_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x16_t vld1q_dup_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x8_t vld1q_dup_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x4_t vld1q_dup_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x2_t vld1q_dup_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x16_t vld1q_dup_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x8_t vld1q_dup_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x4_t vld1q_dup_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x2_t vld1q_dup_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x16_t vld1q_dup_u8(uint8_t const *);

// SECTION:vld1_q_lane:128:rt(ptrc,p,ca)
__IEFF_NENW1 __ATTRIBUTES float16x8_t vld1q_lane_f16(float16_t const *, float16x8_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES float32x4_t vld1q_lane_f32(float32_t const *, float32x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly16x8_t vld1q_lane_p16(poly16_t const *, poly16x8_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES poly8x16_t vld1q_lane_p8(poly8_t const *, poly8x16_t, int __constrange(0,15));
__IEFF_NENW1 __ATTRIBUTES int16x8_t vld1q_lane_s16(int16_t const *, int16x8_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int32x4_t vld1q_lane_s32(int32_t const *, int32x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES int64x2_t vld1q_lane_s64(int64_t const *, int64x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES int8x16_t vld1q_lane_s8(int8_t const *, int8x16_t, int __constrange(0,15));
__IEFF_NENW1 __ATTRIBUTES uint16x8_t vld1q_lane_u16(uint16_t const *, uint16x8_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint32x4_t vld1q_lane_u32(uint32_t const *, uint32x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint64x2_t vld1q_lane_u64(uint64_t const *, uint64x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES uint8x16_t vld1q_lane_u8(uint8_t const *, uint8x16_t, int __constrange(0,15));

// SECTION:vld2:64:rtx2(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x4x2_t vld2_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2x2_t vld2_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4x2_t vld2_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8x2_t vld2_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4x2_t vld2_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2x2_t vld2_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1x2_t vld2_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8x2_t vld2_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4x2_t vld2_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2x2_t vld2_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1x2_t vld2_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8x2_t vld2_u8(uint8_t const *);
__IEFF_NENW1 __ATTRIBUTES float16x4x2_t vld2_dup_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2x2_t vld2_dup_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4x2_t vld2_dup_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8x2_t vld2_dup_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4x2_t vld2_dup_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2x2_t vld2_dup_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1x2_t vld2_dup_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8x2_t vld2_dup_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4x2_t vld2_dup_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2x2_t vld2_dup_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1x2_t vld2_dup_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8x2_t vld2_dup_u8(uint8_t const *);

// SECTION:vld2_lane:64:rtx2(ptrc,px2,ca)
__IEFF_NENW1 __ATTRIBUTES float16x4x2_t vld2_lane_f16(float16_t const *, float16x4x2_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES float32x2x2_t vld2_lane_f32(float32_t const *, float32x2x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES poly16x4x2_t vld2_lane_p16(poly16_t const *, poly16x4x2_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly8x8x2_t vld2_lane_p8(poly8_t const *, poly8x8x2_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x4x2_t vld2_lane_s16(int16_t const *, int16x4x2_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES int32x2x2_t vld2_lane_s32(int32_t const *, int32x2x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES int8x8x2_t vld2_lane_s8(int8_t const *, int8x8x2_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint16x4x2_t vld2_lane_u16(uint16_t const *, uint16x4x2_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint32x2x2_t vld2_lane_u32(uint32_t const *, uint32x2x2_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES uint8x8x2_t vld2_lane_u8(uint8_t const *, uint8x8x2_t, int __constrange(0,7));

// SECTION:vld2_q:128:rtx2(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x8x2_t vld2q_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x4x2_t vld2q_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x8x2_t vld2q_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x16x2_t vld2q_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x8x2_t vld2q_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x4x2_t vld2q_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x16x2_t vld2q_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x8x2_t vld2q_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x4x2_t vld2q_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x16x2_t vld2q_u8(uint8_t const *);

// SECTION:vld2_q_lane:128:rtx2(ptrc,px2,ca)
__IEFF_NENW1 __ATTRIBUTES float16x8x2_t vld2q_lane_f16(float16_t const *, float16x8x2_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES float32x4x2_t vld2q_lane_f32(float32_t const *, float32x4x2_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly16x8x2_t vld2q_lane_p16(poly16_t const *, poly16x8x2_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x8x2_t vld2q_lane_s16(int16_t const *, int16x8x2_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int32x4x2_t vld2q_lane_s32(int32_t const *, int32x4x2_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint16x8x2_t vld2q_lane_u16(uint16_t const *, uint16x8x2_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint32x4x2_t vld2q_lane_u32(uint32_t const *, uint32x4x2_t, int __constrange(0,3));

// SECTION:vld3:64:rtx3(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x4x3_t vld3_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2x3_t vld3_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4x3_t vld3_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8x3_t vld3_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4x3_t vld3_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2x3_t vld3_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1x3_t vld3_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8x3_t vld3_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4x3_t vld3_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2x3_t vld3_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1x3_t vld3_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8x3_t vld3_u8(uint8_t const *);
__IEFF_NENW1 __ATTRIBUTES float16x4x3_t vld3_dup_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2x3_t vld3_dup_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4x3_t vld3_dup_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8x3_t vld3_dup_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4x3_t vld3_dup_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2x3_t vld3_dup_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1x3_t vld3_dup_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8x3_t vld3_dup_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4x3_t vld3_dup_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2x3_t vld3_dup_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1x3_t vld3_dup_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8x3_t vld3_dup_u8(uint8_t const *);

// SECTION:vld3_lane:64:rtx3(ptrc,px3,ca)
__IEFF_NENW1 __ATTRIBUTES float16x4x3_t vld3_lane_f16(float16_t const *, float16x4x3_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES float32x2x3_t vld3_lane_f32(float32_t const *, float32x2x3_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES poly16x4x3_t vld3_lane_p16(poly16_t const *, poly16x4x3_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly8x8x3_t vld3_lane_p8(poly8_t const *, poly8x8x3_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x4x3_t vld3_lane_s16(int16_t const *, int16x4x3_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES int32x2x3_t vld3_lane_s32(int32_t const *, int32x2x3_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES int8x8x3_t vld3_lane_s8(int8_t const *, int8x8x3_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint16x4x3_t vld3_lane_u16(uint16_t const *, uint16x4x3_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint32x2x3_t vld3_lane_u32(uint32_t const *, uint32x2x3_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES uint8x8x3_t vld3_lane_u8(uint8_t const *, uint8x8x3_t, int __constrange(0,7));

// SECTION:vld3_q:128:rtx3(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x8x3_t vld3q_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x4x3_t vld3q_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x8x3_t vld3q_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x16x3_t vld3q_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x8x3_t vld3q_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x4x3_t vld3q_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x16x3_t vld3q_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x8x3_t vld3q_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x4x3_t vld3q_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x16x3_t vld3q_u8(uint8_t const *);

// SECTION:vld3_q_lane:128:rtx3(ptrc,px3,ca)
__IEFF_NENW1 __ATTRIBUTES float16x8x3_t vld3q_lane_f16(float16_t const *, float16x8x3_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES float32x4x3_t vld3q_lane_f32(float32_t const *, float32x4x3_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly16x8x3_t vld3q_lane_p16(poly16_t const *, poly16x8x3_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x8x3_t vld3q_lane_s16(int16_t const *, int16x8x3_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int32x4x3_t vld3q_lane_s32(int32_t const *, int32x4x3_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint16x8x3_t vld3q_lane_u16(uint16_t const *, uint16x8x3_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint32x4x3_t vld3q_lane_u32(uint32_t const *, uint32x4x3_t, int __constrange(0,3));

// SECTION:vld4:64:rtx4(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x4x4_t vld4_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2x4_t vld4_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4x4_t vld4_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8x4_t vld4_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4x4_t vld4_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2x4_t vld4_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1x4_t vld4_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8x4_t vld4_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4x4_t vld4_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2x4_t vld4_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1x4_t vld4_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8x4_t vld4_u8(uint8_t const *);
__IEFF_NENW1 __ATTRIBUTES float16x4x4_t vld4_dup_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x2x4_t vld4_dup_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x4x4_t vld4_dup_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x8x4_t vld4_dup_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x4x4_t vld4_dup_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x2x4_t vld4_dup_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int64x1x4_t vld4_dup_s64(int64_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x8x4_t vld4_dup_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x4x4_t vld4_dup_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x2x4_t vld4_dup_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint64x1x4_t vld4_dup_u64(uint64_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x8x4_t vld4_dup_u8(uint8_t const *);

// SECTION:vld4_lane:64:rtx4(ptrc,px4,ca)
__IEFF_NENW1 __ATTRIBUTES float16x4x4_t vld4_lane_f16(float16_t const *, float16x4x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES float32x2x4_t vld4_lane_f32(float32_t const *, float32x2x4_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES poly16x4x4_t vld4_lane_p16(poly16_t const *, poly16x4x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly8x8x4_t vld4_lane_p8(poly8_t const *, poly8x8x4_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x4x4_t vld4_lane_s16(int16_t const *, int16x4x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES int32x2x4_t vld4_lane_s32(int32_t const *, int32x2x4_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES int8x8x4_t vld4_lane_s8(int8_t const *, int8x8x4_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint16x4x4_t vld4_lane_u16(uint16_t const *, uint16x4x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint32x2x4_t vld4_lane_u32(uint32_t const *, uint32x2x4_t, int __constrange(0,1));
__IEFF_NENW1 __ATTRIBUTES uint8x8x4_t vld4_lane_u8(uint8_t const *, uint8x8x4_t, int __constrange(0,7));

// SECTION:vld4_q:128:rtx4(ptrc)
__IEFF_NENW1 __ATTRIBUTES float16x8x4_t vld4q_f16(float16_t const *);
__IEFF_NENW1 __ATTRIBUTES float32x4x4_t vld4q_f32(float32_t const *);
__IEFF_NENW1 __ATTRIBUTES poly16x8x4_t vld4q_p16(poly16_t const *);
__IEFF_NENW1 __ATTRIBUTES poly8x16x4_t vld4q_p8(poly8_t const *);
__IEFF_NENW1 __ATTRIBUTES int16x8x4_t vld4q_s16(int16_t const *);
__IEFF_NENW1 __ATTRIBUTES int32x4x4_t vld4q_s32(int32_t const *);
__IEFF_NENW1 __ATTRIBUTES int8x16x4_t vld4q_s8(int8_t const *);
__IEFF_NENW1 __ATTRIBUTES uint16x8x4_t vld4q_u16(uint16_t const *);
__IEFF_NENW1 __ATTRIBUTES uint32x4x4_t vld4q_u32(uint32_t const *);
__IEFF_NENW1 __ATTRIBUTES uint8x16x4_t vld4q_u8(uint8_t const *);

// SECTION:vld4_q_lane:128:rtx4(ptrc,px4,ca)
__IEFF_NENW1 __ATTRIBUTES float16x8x4_t vld4q_lane_f16(float16_t const *, float16x8x4_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES float32x4x4_t vld4q_lane_f32(float32_t const *, float32x4x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES poly16x8x4_t vld4q_lane_p16(poly16_t const *, poly16x8x4_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int16x8x4_t vld4q_lane_s16(int16_t const *, int16x8x4_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES int32x4x4_t vld4q_lane_s32(int32_t const *, int32x4x4_t, int __constrange(0,3));
__IEFF_NENW1 __ATTRIBUTES uint16x8x4_t vld4q_lane_u16(uint16_t const *, uint16x8x4_t, int __constrange(0,7));
__IEFF_NENW1 __ATTRIBUTES uint32x4x4_t vld4q_lane_u32(uint32_t const *, uint32x4x4_t, int __constrange(0,3));

// SECTION:vst1:64:rtv(ptr,p)
__IEFF_NENR1 __ATTRIBUTES void vst1_f16(float16_t *, float16x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_f32(float32_t *, float32x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_p16(poly16_t *, poly16x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_p8(poly8_t *, poly8x8_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_s16(int16_t *, int16x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_s32(int32_t *, int32x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_s64(int64_t *, int64x1_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_s8(int8_t *, int8x8_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_u16(uint16_t *, uint16x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_u32(uint32_t *, uint32x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_u64(uint64_t *, uint64x1_t);
__IEFF_NENR1 __ATTRIBUTES void vst1_u8(uint8_t *, uint8x8_t);

// SECTION:vst1_lane:64:rtv(ptr,p,ca)
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_f16(float16_t *, float16x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_f32(float32_t *, float32x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_p16(poly16_t *, poly16x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_p8(poly8_t *, poly8x8_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_s16(int16_t *, int16x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_s32(int32_t *, int32x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_s64(int64_t *, int64x1_t, int __constrange(0,0));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_s8(int8_t *, int8x8_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_u16(uint16_t *, uint16x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_u32(uint32_t *, uint32x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_u64(uint64_t *, uint64x1_t, int __constrange(0,0));
__IEFF_NENR1 __ATTRIBUTES void vst1_lane_u8(uint8_t *, uint8x8_t, int __constrange(0,7));

// SECTION:vst1_q:128:rtv(ptr,p)
__IEFF_NENR1 __ATTRIBUTES void vst1q_f16(float16_t *, float16x8_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_f32(float32_t *, float32x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_p16(poly16_t *, poly16x8_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_p8(poly8_t *, poly8x16_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_s16(int16_t *, int16x8_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_s32(int32_t *, int32x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_s64(int64_t *, int64x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_s8(int8_t *, int8x16_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_u16(uint16_t *, uint16x8_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_u32(uint32_t *, uint32x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_u64(uint64_t *, uint64x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst1q_u8(uint8_t *, uint8x16_t);

// SECTION:vst1_q_lane:128:rtv(ptr,p,ca)
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_f16(float16_t *, float16x8_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_f32(float32_t *, float32x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_p16(poly16_t *, poly16x8_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_p8(poly8_t *, poly8x16_t, int __constrange(0,15));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_s16(int16_t *, int16x8_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_s32(int32_t *, int32x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_s64(int64_t *, int64x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_s8(int8_t *, int8x16_t, int __constrange(0,15));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_u16(uint16_t *, uint16x8_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_u32(uint32_t *, uint32x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_u64(uint64_t *, uint64x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst1q_lane_u8(uint8_t *, uint8x16_t, int __constrange(0,15));

// SECTION:vst2:64:rtv(ptr,px2)
__IEFF_NENR1 __ATTRIBUTES void vst2_f16(float16_t *, float16x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_f32(float32_t *, float32x2x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_p16(poly16_t *, poly16x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_p8(poly8_t *, poly8x8x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_s16(int16_t *, int16x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_s32(int32_t *, int32x2x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_s64(int64_t *, int64x1x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_s8(int8_t *, int8x8x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_u16(uint16_t *, uint16x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_u32(uint32_t *, uint32x2x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_u64(uint64_t *, uint64x1x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2_u8(uint8_t *, uint8x8x2_t);

// SECTION:vst2_lane:64:rtv(ptr,px2,ca)
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_f16(float16_t *, float16x4x2_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_f32(float32_t *, float32x2x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_p16(poly16_t *, poly16x4x2_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_p8(poly8_t *, poly8x8x2_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_s16(int16_t *, int16x4x2_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_s32(int32_t *, int32x2x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_s8(int8_t *, int8x8x2_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_u16(uint16_t *, uint16x4x2_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_u32(uint32_t *, uint32x2x2_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst2_lane_u8(uint8_t *, uint8x8x2_t, int __constrange(0,7));

// SECTION:vst2_q:128:rtv(ptr,px2)
__IEFF_NENR1 __ATTRIBUTES void vst2q_f16(float16_t *, float16x8x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_f32(float32_t *, float32x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_p16(poly16_t *, poly16x8x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_p8(poly8_t *, poly8x16x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_s16(int16_t *, int16x8x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_s32(int32_t *, int32x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_s8(int8_t *, int8x16x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_u16(uint16_t *, uint16x8x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_u32(uint32_t *, uint32x4x2_t);
__IEFF_NENR1 __ATTRIBUTES void vst2q_u8(uint8_t *, uint8x16x2_t);

// SECTION:vst2_q_lane:128:rtv(ptr,px2,ca)
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_f16(float16_t *, float16x8x2_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_f32(float32_t *, float32x4x2_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_p16(poly16_t *, poly16x8x2_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_s16(int16_t *, int16x8x2_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_s32(int32_t *, int32x4x2_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_u16(uint16_t *, uint16x8x2_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst2q_lane_u32(uint32_t *, uint32x4x2_t, int __constrange(0,3));

// SECTION:vst3:64:rtv(ptr,px3)
__IEFF_NENR1 __ATTRIBUTES void vst3_f16(float16_t *, float16x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_f32(float32_t *, float32x2x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_p16(poly16_t *, poly16x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_p8(poly8_t *, poly8x8x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_s16(int16_t *, int16x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_s32(int32_t *, int32x2x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_s64(int64_t *, int64x1x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_s8(int8_t *, int8x8x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_u16(uint16_t *, uint16x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_u32(uint32_t *, uint32x2x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_u64(uint64_t *, uint64x1x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3_u8(uint8_t *, uint8x8x3_t);

// SECTION:vst3_lane:64:rtv(ptr,px3,ca)
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_f16(float16_t *, float16x4x3_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_f32(float32_t *, float32x2x3_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_p16(poly16_t *, poly16x4x3_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_p8(poly8_t *, poly8x8x3_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_s16(int16_t *, int16x4x3_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_s32(int32_t *, int32x2x3_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_s8(int8_t *, int8x8x3_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_u16(uint16_t *, uint16x4x3_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_u32(uint32_t *, uint32x2x3_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst3_lane_u8(uint8_t *, uint8x8x3_t, int __constrange(0,7));

// SECTION:vst3_q:128:rtv(ptr,px3)
__IEFF_NENR1 __ATTRIBUTES void vst3q_f16(float16_t *, float16x8x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_f32(float32_t *, float32x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_p16(poly16_t *, poly16x8x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_p8(poly8_t *, poly8x16x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_s16(int16_t *, int16x8x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_s32(int32_t *, int32x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_s8(int8_t *, int8x16x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_u16(uint16_t *, uint16x8x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_u32(uint32_t *, uint32x4x3_t);
__IEFF_NENR1 __ATTRIBUTES void vst3q_u8(uint8_t *, uint8x16x3_t);

// SECTION:vst3_q_lane:128:rtv(ptr,px3,ca)
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_f16(float16_t *, float16x8x3_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_f32(float32_t *, float32x4x3_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_p16(poly16_t *, poly16x8x3_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_s16(int16_t *, int16x8x3_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_s32(int32_t *, int32x4x3_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_u16(uint16_t *, uint16x8x3_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst3q_lane_u32(uint32_t *, uint32x4x3_t, int __constrange(0,3));

// SECTION:vst4:64:rtv(ptr,px4)
__IEFF_NENR1 __ATTRIBUTES void vst4_f16(float16_t *, float16x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_f32(float32_t *, float32x2x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_p16(poly16_t *, poly16x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_p8(poly8_t *, poly8x8x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_s16(int16_t *, int16x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_s32(int32_t *, int32x2x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_s64(int64_t *, int64x1x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_s8(int8_t *, int8x8x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_u16(uint16_t *, uint16x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_u32(uint32_t *, uint32x2x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_u64(uint64_t *, uint64x1x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4_u8(uint8_t *, uint8x8x4_t);

// SECTION:vst4_lane:64:rtv(ptr,px4,ca)
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_f16(float16_t *, float16x4x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_f32(float32_t *, float32x2x4_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_p16(poly16_t *, poly16x4x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_p8(poly8_t *, poly8x8x4_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_s16(int16_t *, int16x4x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_s32(int32_t *, int32x2x4_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_s8(int8_t *, int8x8x4_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_u16(uint16_t *, uint16x4x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_u32(uint32_t *, uint32x2x4_t, int __constrange(0,1));
__IEFF_NENR1 __ATTRIBUTES void vst4_lane_u8(uint8_t *, uint8x8x4_t, int __constrange(0,7));

// SECTION:vst4_q:128:rtv(ptr,px4)
__IEFF_NENR1 __ATTRIBUTES void vst4q_f16(float16_t *, float16x8x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_f32(float32_t *, float32x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_p16(poly16_t *, poly16x8x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_p8(poly8_t *, poly8x16x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_s16(int16_t *, int16x8x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_s32(int32_t *, int32x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_s8(int8_t *, int8x16x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_u16(uint16_t *, uint16x8x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_u32(uint32_t *, uint32x4x4_t);
__IEFF_NENR1 __ATTRIBUTES void vst4q_u8(uint8_t *, uint8x16x4_t);

// SECTION:vst4_q_lane:128:rtv(ptr,px4,ca)
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_f16(float16_t *, float16x8x4_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_f32(float32_t *, float32x4x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_p16(poly16_t *, poly16x8x4_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_s16(int16_t *, int16x8x4_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_s32(int32_t *, int32x4x4_t, int __constrange(0,3));
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_u16(uint16_t *, uint16x8x4_t, int __constrange(0,7));
__IEFF_NENR1 __ATTRIBUTES void vst4q_lane_u32(uint32_t *, uint32x4x4_t, int __constrange(0,3));

#undef __IEFF_HS
#undef __IEFF_NE
#undef __IEFF_NENR1
#undef __IEFF_NENW1

#define vfma_n_f32(a,b,x)  vfma_f32(a, b, vdup_n_f32(x))
#define vfms_n_f32(a,b,x)  vfms_f32(a, b, vdup_n_f32(x))
#define vfmaq_n_f32(a,b,x) vfmaq_f32(a, b, vdupq_n_f32(x))
#define vfmsq_n_f32(a,b,x) vfmsq_f32(a, b, vdupq_n_f32(x))

#pragma language=restore

#endif

