/* xtgmath.h internal header */
/* Copyright 2009-2017 IAR Systems AB. */
#ifndef _XTGMATH
#define _XTGMATH

#ifndef _SYSTEM_BUILD
  #pragma system_include
#endif

#ifndef _YVALS
  #include <yvals.h>
#endif /* _YVALS */

#if !_DLIB_ONLY_C89

#ifdef __cplusplus
  extern "C++" {
    #include <xtr1common>
  }

  namespace std {
    extern "C++" {
      template<class _Ty>
      struct _Promote_to_float
      { // promote integral to double
        typedef typename conditional<is_integral<_Ty>::value,
                                     double,
                                     _Ty>::type type;
      };

      template<class _Ty1, class _Ty2>
        struct _Common_float_type
        { // find type for two-argument math function
          typedef typename _Promote_to_float<_Ty1>::type _Ty1f;
          typedef typename _Promote_to_float<_Ty2>::type _Ty2f;
          typedef typename conditional<is_same<
               _Ty1f, long double>::value
            || is_same<_Ty2f, long double>::value,
            long double,
            typename conditional<   is_same<_Ty1f, double>::value
                                 || is_same<_Ty2f, double>::value,
                                 double,
                                 float>::type>::type type;
        };

      template<class _Ty1, class _Ty2>
        using _Cft = typename _Common_float_type<_Ty1, _Ty2>::type;

#ifdef __cpp_exceptions
  #define _NoExcept noexcept
#else // !__cpp_exceptions
  #define _NoExcept
#endif // __cpp_exceptions

// Remove when no longer needed
// address of overloaded function with exc_spec_in_func_type
#define __BUG_WA1
#ifdef __BUG_WA1
      template<typename _Ty1, typename _Ty2>
        constexpr bool _AvoidSame = !std::is_same<_Ty1, _Ty2>::value;
      template<typename _Ty, typename _Ty1, typename _Ty2>
        constexpr bool _AvoidSame2 = !(   std::is_same<_Ty, _Ty1>::value
                                       && std::is_same<_Ty, _Ty2>::value);
#else // !__BUG_WA1
      template<typename _Ty1, typename _Ty2>
        constexpr bool _AvoidSame = true;
      template<typename _Ty, typename _Ty1, typename _Ty2>
        constexpr bool _AvoidSame2 = true;
#endif // __BUG_WA1
    } /* extern "C++" */
  } /* namespace "std" */

  extern "C++" {
    #define _GENERIC_MATH1(FUN)                                              \
      extern "C" __ATTRIBUTES double FUN(double);                            \
      template<class _Ty> inline                                             \
        typename std::enable_if<   std::is_integral<_Ty>::value              \
                                && std::_AvoidSame<_Ty, double>,             \
                                double>::type                                \
      FUN(_Ty _Left) _NoExcept                                               \
      {                                                                      \
        return ::FUN((double)_Left);                                         \
      }

    #define _GENERIC_MATH1X(FUN, ARG2)                                       \
      extern "C" __ATTRIBUTES double FUN(double, ARG2);                      \
      template<class _Ty> inline                                             \
        typename std::enable_if<   std::is_integral<_Ty>::value              \
                                && std::_AvoidSame<_Ty, double>,             \
                                double>::type                                \
      FUN(_Ty _Left, ARG2 _Arg2) _NoExcept                                   \
      {                                                                      \
        return ::FUN((double)_Left, _Arg2);                                  \
      }

    #define _GENERIC_MATH2_CALL(FUN, CALL_OPT)                               \
      extern "C" __ATTRIBUTES double CALL_OPT FUN(double, double);           \
      template<class _Ty1, class _Ty2> inline                                \
        typename std::enable_if<   std::is_arithmetic<_Ty1>::value           \
                                && std::is_arithmetic<_Ty2>::value           \
                                && std::_AvoidSame2<std::_Cft<_Ty1, _Ty2>,   \
                                                    _Ty1, _Ty2>,             \
                                std::_Cft<_Ty1, _Ty2>>::type                 \
      FUN(_Ty1 _Left, _Ty2 _Right) _NoExcept                                 \
      {                                                                      \
        typedef std::_Cft<_Ty1, _Ty2> type;                                  \
        return ::FUN((type)_Left, (type)_Right);                             \
      }

    #define _GENERIC_MATH2(FUN) _GENERIC_MATH2_CALL(FUN, )

    extern "C"  __ATTRIBUTES double pow(double, double);
     __ATTRIBUTES float pow(float, float);
     __ATTRIBUTES long double pow(long double, long double);

    template<class _Ty1, class _Ty2> inline
      typename std::enable_if<   std::is_arithmetic<_Ty1>::value
                              && std::is_arithmetic<_Ty2>::value
                              && std::_AvoidSame2<std::_Cft<_Ty1, _Ty2>,
                                                  _Ty1, _Ty2>,
                              std::_Cft<_Ty1,_Ty2>>::type
    pow(const _Ty1 _Left, const _Ty2 _Right) _NoExcept
    {       // bring mixed types to a common type
      typedef std::_Cft<_Ty1, _Ty2> type;
      return ::pow(type(_Left), type(_Right));
    }

    //_GENERIC_MATH1(abs)      // has integer overloads
    _GENERIC_MATH1(acos)
    _GENERIC_MATH1(asin)
    _GENERIC_MATH1(atan)
    _GENERIC_MATH2(atan2)
    _GENERIC_MATH1(ceil)
    _GENERIC_MATH1(cos)
    _GENERIC_MATH1(cosh)
    _GENERIC_MATH1(exp)
    _GENERIC_MATH1(floor)
    _GENERIC_MATH2(fmod)
    _GENERIC_MATH1X(frexp, int *)
    _GENERIC_MATH1X(ldexp, int)
    _GENERIC_MATH1(log)
    _GENERIC_MATH1(log10)
    //_GENERIC_MATH1(modf)             // types must match
    //_GENERIC_MATH2(pow)      // hand crafted
    _GENERIC_MATH1(sin)
    _GENERIC_MATH1(sinh)
    _GENERIC_MATH1(sqrt)
    _GENERIC_MATH1(tan)
    _GENERIC_MATH1(tanh)

    // C99 MATH FUNCTIONS
    #define _GENERIC_MATH1R(FUN, RET)                                        \
      extern "C" __ATTRIBUTES RET FUN(double);                               \
      template<class _Ty> inline                                             \
        typename std::enable_if< std::is_integral<_Ty>::value, RET>::type    \
      FUN(_Ty _Left)                                                         \
      {                                                                      \
        return ::FUN((double)_Left);                                         \
      }

    // TEMPLATE FUNCTION fma
    #define _Fma    ::fma

    template<class _Ty1, class _Ty2, class _Ty3> inline
      typename std::_Common_float_type<_Ty1,
                                       typename std::_Common_float_type<_Ty2,
                                                             _Ty3>::type>::type
    fma(_Ty1 _Left, _Ty2 _Middle, _Ty3 _Right)
    {       // bring mixed types to a common type
      typedef typename std::_Common_float_type<_Ty1,
                                               typename std::_Common_float_type<
                                                  _Ty2, _Ty3>::type>::type type;
      return _Fma((type)_Left, (type)_Middle, (type)_Right);
    }

    // TEMPLATE FUNCTION remquo
    #define _Remquo ::remquo

    template<class _Ty1, class _Ty2> inline
      typename std::_Common_float_type<_Ty1, _Ty2>::type
    remquo(_Ty1 _Left, _Ty2 _Right, int *_Pquo)
    {       // bring mixed types to a common type
      typedef typename std::_Common_float_type<_Ty1, _Ty2>::type type;
      return _Remquo((type)_Left, (type)_Right, _Pquo);
    }

    _GENERIC_MATH1(acosh)
    _GENERIC_MATH1(asinh)
    _GENERIC_MATH1(atanh)
    _GENERIC_MATH1(cbrt)
    _GENERIC_MATH2(copysign)
    _GENERIC_MATH1(erf)
    _GENERIC_MATH1(erfc)
    _GENERIC_MATH1(expm1)
    _GENERIC_MATH1(exp2)
    _GENERIC_MATH2(fdim)
    //_GENERIC_MATH3(fma)      // hand crafted
    _GENERIC_MATH2(fmax)
    _GENERIC_MATH2(fmin)
    _GENERIC_MATH2(hypot)
    _GENERIC_MATH1R(ilogb, int)
    _GENERIC_MATH1(lgamma)
    _GENERIC_MATH1R(llrint, long long)
    _GENERIC_MATH1R(llround, long long)
    _GENERIC_MATH1(log1p)
    _GENERIC_MATH1(log2)
    _GENERIC_MATH1(logb)
    _GENERIC_MATH1R(lrint, long)
    _GENERIC_MATH1R(lround, long)
    _GENERIC_MATH1(nearbyint)
    _GENERIC_MATH2(nextafter)
    _GENERIC_MATH1X(nexttoward, long double)
    _GENERIC_MATH2(remainder)
    //_GENERIC_MATH2X(remquo)  // hand crafted
    _GENERIC_MATH1(rint)
    _GENERIC_MATH1(round)
    _GENERIC_MATH1X(scalbln, long)
    _GENERIC_MATH1X(scalbn, int)
    _GENERIC_MATH1(tgamma)
    _GENERIC_MATH1(trunc)
  }
#endif /* __cplusplus */

#endif /* !_DLIB_ONLY_C89 */
#endif /* _XTGMATH */

/*
 * Copyright (c) by P.J. Plauger. All rights reserved.
 * Consult your license regarding permissions and restrictions.
V6.50:0576 */
