// __iar_libcpp_Raise_xxx() functions The functions will either do a
// throw on a specific object or the reference to the function will be
// replaced by a reference to abort(), depending on whether the linker
// has determined that exceptions should be used or not.

#ifndef __RAISE_H
#define __RAISE_H

namespace std {
extern "C"{

//
// Defined in libcpp-src/__support/iar/iar_libcpp_Raise.cpp.
//


_LIBCPP_NORETURN void __throw_bad_alloc(void);

_LIBCPP_NORETURN void __throw_bad_array_new_length(void);

_LIBCPP_NORETURN
void __throw_bad_any_cast(void);

_LIBCPP_NORETURN void __throw_bad_cast();

_LIBCPP_NORETURN void __throw_bad_function_call(void);

_LIBCPP_NORETURN
void __throw_bad_optional_access();

_LIBCPP_NORETURN
void __throw_bad_variant_access();

_LIBCPP_NORETURN void __throw_bad_weak_ptr();

_LIBCPP_NORETURN void __throw_domain_error(void);

_LIBCPP_NORETURN void __throw_failure(void);

// Not done: __throw_filesystem_error(_Args&&...)

//_LIBCPP_NORETURN
//#ifndef _LIBCPP_NO_EXCEPTIONS
//  _LIBCPP_AVAILABILITY_FUTURE_ERROR
//#endif
//void __throw_future_error(enum class future_errc _Ev);

_LIBCPP_NORETURN void __throw_invalid_argument(void);

_LIBCPP_NORETURN void __throw_length_error(void);

_LIBCPP_NORETURN void __throw_logic_error(void);

_LIBCPP_NORETURN void __throw_out_of_range(void);

_LIBCPP_NORETURN void __throw_overflow_error(void);

_LIBCPP_NORETURN void __throw_range_error(void);

_LIBCPP_NORETURN void __throw_regex_error(int _Ev);

#pragma no_bounds
_LIBCPP_NORETURN void __throw_runtime_error(char const *__msg);

#pragma no_bounds
_LIBCPP_NORETURN void __throw_system_error(int ev, char const *what_arg);

_LIBCPP_NORETURN void __throw_underflow_error(void);

_LIBCPP_NORETURN void __throw(void);
_LIBCPP_NORETURN void __rethrow(void);

} // extern "C"
} // namespace std

#ifdef _LIBCPP_ABI_NAMESPACE
namespace _VSTD {
  using std::__throw_length_error;
  using std::__throw_out_of_range;
  using std::__throw_regex_error;
  using std::__throw_runtime_error;
}
#endif // _LIBCPP_ABI_NAMESPACE

#endif // __RAISE_H
