#ifndef _LIBCPP_SUPPORT_IAR_XLOCALE_H
#define _LIBCPP_SUPPORT_IAR_XLOCALE_H

#include <llocale.h>
#include <xctype.h>

#ifdef __cplusplus
extern "C" {
#endif

#if 1
#define LC_COLLATE_MASK  (1 << LC_COLLATE)
#define LC_CTYPE_MASK    (1 << LC_CTYPE)
#define LC_MESSAGES_MASK (1 << LC_MESSAGES)
#define LC_MONETARY_MASK (1 << LC_MONETARY)
#define LC_NUMERIC_MASK  (1 << LC_NUMERIC)
#define LC_TIME_MASK     (1 << LC_TIME)
#define LC_ALL_MASK (LC_COLLATE_MASK|\
                     LC_CTYPE_MASK|\
                     LC_MONETARY_MASK|\
                     LC_NUMERIC_MASK|\
                     LC_TIME_MASK|\
                     LC_MESSAGES_MASK)
#endif

namespace std {
  __attribute__((weak)) void freelocale(locale_t);
  locale_t newlocale(int, const char *, locale_t);
} // std

  __SIZE_T_TYPE__ wcsnrtombs(char *__dest, const wchar_t **__src,
                             __SIZE_T_TYPE__ __nwc,
                             __SIZE_T_TYPE__ __len, _Mbstatet *__ps);
  __SIZE_T_TYPE__ mbsnrtowcs(wchar_t * __dest, const char **__src,
                             __SIZE_T_TYPE__ __nms,
                             __SIZE_T_TYPE__ __len, _Mbstatet *__ps);
  int vasprintf(char **, const char *, __Va_list);


#ifdef __cplusplus
} // extern "C"
#endif

#endif // _LIBCPP_SUPPORT_IAR_XLOCALE_H
