# Installing IAR Build Tools
This document describes how to get started with IAR Build Tools using a
cloud-based licensing model.

## Installing on Windows
The default installation directory is `C:\iar\`.

### 1. Install your IAR product
There are two ways to install your IAR product: interactive installation and autonomous installation.

* 	To install the product interactively, run `<product>-<version>.exe` and follow the installation instructions. 
	Select the support files for the device family your product uses when prompted during the installation process.

* 	To install your product autonomously, invoke the installer with Administrator privileges using the options
	`/hide_usd` and `/autoinstall`:

	`<installer>.exe /hide_usd /autoinstall`

	You can optionally specify an installation directory, using the full path prefixed
	with a forward slash (/). For example:

	`<installer>.exe /hide_usd /autoinstall/D:\My Folder\IAR_Systems`

### 2. Activate your license
There are two types of licenses: user licenses and CI licenses.

* To active your user license, open IAR Embedded Workbench and log in with your Microsoft account.

* To active your CI license, contact IAR Customer Support for information on how to acquire an access token. Once you have the access token, set up the access token environment variable:

	```
	set IAR_LMS_BEARER_TOKEN=<token-string>
	```

	Note that the token has an expiration date.


## Installing on Red Hat or Ubuntu
The package manager executable file for Red Hat is `rpm` and the filename
extension for its associated archive files is `.rpm`. For Ubuntu, the package
manager executable file is `apt` or `dpkg`, and the filename extension for their associated
archive files is `.deb`. When both options are present, separated by a pipe
character, use the appropriate alternatives for the Linux distribution that you
are using.

**Note:** When installing the IAR Build Tools themselves on Ubuntu,
you must invoke `apt` with the install command `install`, otherwise dependency
files will not be installed.

The default installation directory is `/opt/iar/`. 

### 1. Install your IAR product

Execute this command line (Red Hat/Ubuntu):

```
$ sudo rpm -i ./<installer>.rpm
or
$ sudo apt install ./<installer>.deb
```
where `<installer>` is the name of your IAR product installer, on the pattern
`<product>-<version>.deb|rpm`.

### 2. Install support files for the hardware device family your product uses

Execute this command line:

```
$ sudo dpkg|rpm -i ./<devicepackage>.deb|rpm
```

The device packages have descriptive names on the pattern
`<product>-device-support-<vendor>-<version>.deb|rpm`.

### 3. Activate your license
There are two types of licenses: user licenses and CI licenses.

* To active your user license, open IAR Embedded Workbench and log in with you Microsoft account.

* To active your CI license, contact IAR Customer Support for information on how to acquire an access token. Once you have the access token, set up the access token environment variable:

	```
	export IAR_LMS_BEARER_TOKEN=<token-string>
	```

	Note that the token has an expiration date.

*&copy;2025 IAR Systems AB. Last updated on April 1, 2025.*