"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DwmExtendFrameIntoClientArea = exports.DwmEnableBlurBehindWindow = void 0;
const native = require("../build/Release/blurbehind.node");
/**
 * Enables or disable blur behind a window
 * @param window The target window's native handle.
 * @param enable Whether to enable or disable blur behind.
 */
function DwmEnableBlurBehindWindow(window, enable) {
    return native.blurbehind(window, enable);
}
exports.DwmEnableBlurBehindWindow = DwmEnableBlurBehindWindow;
;
/**
 * Extends the window frame in the client area.
 * @param window The target window's native handle.
 * @param left
 * @param right
 * @param top
 * @param bottom
 */
function DwmExtendFrameIntoClientArea(window, left, right, top, bottom) {
    return native.extendframe(window, left, right, top, bottom);
}
exports.DwmExtendFrameIntoClientArea = DwmExtendFrameIntoClientArea;
